


#include "WRA.h"
#include "MetData.h"





Tower::Tower()
{
	
	m_sProject = "<project name>";
	m_sClient = "<client name>";
	m_sName = "<site name>";
	m_nID = 0;
	m_ptGeo = Pointf(0,0);
	m_ptUTM = Pointf(0,0);
	
	m_intervalSeconds = 600;
	
	
	
	
}

int Tower::AddStream()
{
	m_streams.Add();	

	return m_streams.GetCount()-1;
}



int Tower::GetStreamIndex(String name)
{
	for(int i=0;i<m_streams.GetCount();i++)
	{
		if(name.Find(m_streams[i].m_sName)>=0)
			return i;		
	}
	
	return -1;
}

// taken from 2-Requirements_Data_Adjustment_5-May-11.docx
void Tower::ApplyAdjustments()
{
	int num = m_ts.GetCount();

	for(int i=0;i<m_streams.GetCount();i++)
	{
		MetStream& st = m_streams[i];
		
		st.m_mean2.SetCount(num);
		st.m_sd2.SetCount(num);

		const MEANING m = st.m_sensors[0].m_meaning;
		
		if(m!=WS)
			continue;
		
		bool bNRG = false;
		bool bDFW = false;
		
		int nS = 0;
		Tower::Sensor& sen = st.GetSensor(nS);
		
		for(int j=0;j<num;j++)
		{
			Time t = m_ts[j];

			int nJ = st.GetSensor(t);

			if(nS!=nJ)
			{
				nS = nJ;
				sen = st.GetSensor(nS);
			}
			
			bNRG = sen.IsNRG();

			bDFW = bNRG ? sen.IsDFW() : false;

			double ws = st.m_mean[j];
			double sd = st.m_sd[j];
			
			// 1.01 Outline for TI Adjustment
			if(bNRG && ws>0.0 && ws<60.0 && sd>=0.0 && sd<10.0)
			{
				double ti = sd/ws;
				
				st.m_mean2[j] = ws/(0.095*ti+0.992);
				
				st.m_sd2[j] = ti*st.m_mean2[j];
				
				// 1.02 Outline for DFW Correction
				if(bDFW)
				{
					ws = st.m_mean2[j];
					
					double hz = (ws-0.35)/0.765;
					
					
					
					
					
					
					
					
					
					
					
					
					
					
				}
			}			
		} // next time step
	} // next stream
	
	// 1.04 Outline for Data Averaging

	// tower correction
	
	
	
	
	
	// averaging
	
	
	
	
	
	// substitution
	
}

int Tower::MetStream::GetSensor(Time t)
{
	for(int i=m_sensors.GetCount()-1;i>=0;i--)
	{
		if(t>m_sensors[i].m_date)
			return i;		
	}
	
	return 0;
}



















