

#ifndef __METDATA_H__
#define __METDATA_H__


#include "Utils.h"


enum MEANING
{
	UNKNOWN = 0,
	WS = 1,
	DIR = 2,
	TEMP = 3,
	PRESS = 4,
	SD = 5, // unused
	RWS = 6, // unused
	VOLT = 7
};

class Tower
{
public:

	Tower();
	virtual ~Tower(){}

	void Serialize(Stream& s);

	String GetProject()			{return m_sProject;}
	String GetClient()			{return m_sClient;}	
	String GetName()			{return m_sName;}
	int GetID()					{return m_nSiteID;}
	Pointf GetPosGeo()			{return m_ptGeo;}
	Pointf GetPosUTM()			{return m_ptUTM;}
	int GetSiteID()				{return m_nSiteID;}

	void SetProject(String s)	{m_sProject=s;}
	void SetClient(String s)	{m_sClient=s;}	
	void SetName(String s)		{m_sName=s;}
	void SetID(int n)			{m_nID=n;}
	void SetPosGeo(Pointf pt)	{m_ptGeo=pt;}
	void SetPosUTM(Pointf pt)	{m_ptUTM=pt;}

	int GetStreamIndex(String name);

	void CrossTheStreams(int n1,int n2){m_streams.Swap(n1,n2);}

	void ClearMetData()
	{
		m_ts.Clear();
		for(int i=0;i<m_streams.GetCount();i++)
		{
			m_streams[i].m_mean.Clear();
			m_streams[i].m_sd.Clear();
			m_streams[i].m_flag.Clear();		
		}
	}

	Time GetTime(int rec)
	{
		return m_ts[rec];	
	}
	
	int GetRecordCount(){return m_ts.GetCount();}


//protected:
	int m_nID;
	String m_sProject;
	String m_sClient;
	String m_sName;
	Pointf m_ptGeo;
	Pointf m_ptUTM;
	Time m_start;
	Time m_end;
	bool m_bDeleted;
	int m_nGuyLevels;
	double m_fModelHeight;
	double m_fBaseElevation;
	int m_nSiteID;
	int m_nProjectID;
	String m_sTowerModel;
	int m_nMastID;
	int m_intervalSeconds;
	
public:
	struct Sensor
	{
		Sensor() // not used
		{
			m_meaning = UNKNOWN;
			m_nSerial=0;
			m_fHeight=m_fBearing=m_fSlope=m_fOffset=0.0;
			m_bPrimary = true;
			m_sSerial = "unconnected";
		}
		Sensor(Time date)
		{
			m_meaning = UNKNOWN;
			m_nSerial=0;
			m_fHeight=m_fBearing=m_fSlope=m_fOffset=0.0;
			m_bPrimary = true;
			m_sSerial = "unconnected";
			m_date = date;
		}
		virtual ~Sensor(){}	
		
		bool IsNRG()	{return ToUpper(m_sManufacturer).Find("NRG")>=0;}
		bool IsDFW()	{return false;}
		
		Time m_date;
		
		String m_sSerial;
		int m_nSerial;
		double m_fHeight;
		double m_fBearing;
		double m_fSlope;
		double m_fOffset;
		String m_sModelName;
		String m_sManufacturer;

		bool m_bPrimary;
		
		MEANING m_meaning;
	};

	struct MetStream
	{
		MetStream()
		{
			
		}
		virtual ~MetStream(){}
		
		void AddValue(int n,double f)
		{
			switch(n)
			{
				case 0:
					m_mean.Add(f);
					return;
				case 1:
					m_sd.Add(f);
					return;
				case 2:
					m_flag.Add(int(f));
					return;
			}
		}		

		int GetSensor(Time t);
		Sensor& GetSensor(int i)		{return m_sensors[i];}
		



		
		int m_nID;
		int m_nMastID;
		String m_sName; // most important!!!
		
			
		Array <Sensor> m_sensors;
		
		Time m_start;
		Time m_stop; 
		
		// original data before adjustments - step 1
		doubleArray m_mean;
		doubleArray m_sd;
		intArray m_flag;
		
		// step 2
		doubleArray m_mean2;
		doubleArray m_sd2;
	
		
		
		
	};

protected:

	Array <Tower::MetStream> m_streams; 



public:

	void ApplyAdjustments();
	int AddStream();	
	int GetStreamCount()		{return m_streams.GetCount();}
	MetStream& GetStream(int i)	{return m_streams[i];}

	Vector <Time> m_ts;
};



















#endif