#ifndef _WRA_WRA_h
#define _WRA_WRA_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;


#include <CtrlLib/CtrlLib.h>
#include <GridCtrl/GridCtrl.h>


#define VERSION_MAJOR 0
#define VERSION_MINOR 1
#define VERSION_COMMIT 1



#include "Utils.h"

static String TimeAsString(Time date)
{
	String s = Format("%04d-%02d-%02d %02d:%02d:00",date.year,date.month,date.day,date.hour,date.minute);
	
	return s;
}

class PopupZoom : public TopWindow
{
	typedef PopupZoom CLASSNAME;	
public:	
	
	PopupZoom()
	{
		m_pOverview = NULL;

		SetRect(20,20,400,400);
		
		WantFocus(false);
	}
	virtual ~PopupZoom(){}	
	
	virtual void Paint(Draw& w);
	
	void* m_pOverview;
	
};

class Overview : public Ctrl
{
public:
	Overview()					{m_pTower=NULL;m_nRec=0;m_nOffset=0;}
	virtual ~Overview(){}	
	
	virtual void Paint(Draw& w);
	
	virtual void MouseMove(Point pos, dword flags);
	virtual void LeftDown(Point p, dword keyflags);	
	
	virtual void MouseEnter(Point p,dword keyflags);
	virtual void MouseLeave();
	virtual void MouseWheel(Point p, int zdelta, dword keyflags);	
	
	int GetMouseMoveRecord()	{return m_nRec+m_nOffset;}
	
	void Set(void* pT);

	PopupZoom m_popZ;

	int m_nRec;

	void* m_pMain;
	void* m_pTower;
	Grid2d<int> m_flags;
	int m_nOffset;
};

#define LAYOUTFILE <WRA/WRA.lay>
#include <CtrlCore/lay.h>

#define IMAGECLASS WRAImg
#define IMAGEFILE <WRA/WRA.iml>
#include <Draw/iml_header.h>



#include "MetData.h"

#include "GoogleMaps.h"

class FlagDisplay : public Display
{
public:
	virtual ~FlagDisplay(){}
	
	virtual void PaintBackground(Draw& w,const Rect& r,const Value& q,Color ink,Color paper,dword style) const;

//	virtual void Paint(Draw& w,const Rect& r,const Value& q,Color ink,Color paper,dword style) const
//	{
//		w.DrawRect(r,Blue);		
//	}
	
	void* m_pMain;

	
};


struct NumberToDateTime : public Convert 
{
	virtual ~NumberToDateTime(){}
	
	
	void Init(void* pTower){m_pTower=pTower;}
	
	
	virtual Value Format(const Value& q) const 
	{
		Tower& tower = *(Tower*)m_pTower;
		
		
		int n = q;
		return TimeAsString(tower.m_ts[n]);
	}

	void* m_pTower;

};

struct ConvertMet1 : public Convert 
{
	virtual ~ConvertMet1(){}

	void Init(void* pTower,int nStream,int nCol){m_pTower=pTower; m_nCol=nCol; m_nStream=nStream;}
	
	virtual Value Format(const Value& q) const 
	{
		Tower& tower = *(Tower*)m_pTower;
		
		int n = q;
		
		switch(m_nCol)
		{
			case 0:
				if(n<tower.GetStream(m_nStream).m_mean.GetCount())
					return tower.GetStream(m_nStream).m_mean[n];
				break;
			case 1:
				if(n<tower.GetStream(m_nStream).m_mean.GetCount())
					return tower.GetStream(m_nStream).m_sd[n];
				break;
			case 2:
				if(n<tower.GetStream(m_nStream).m_mean.GetCount())
					return tower.GetStream(m_nStream).m_flag[n];
		}

		return " ";
	}

	void* m_pTower;
	int m_nCol;
	int m_nStream;

};

struct ConvertEdit : public Convert 
{
	virtual ~ConvertEdit(){}

	void Init(void* pTower,int nStream,int nCol){m_pTower=pTower; m_nCol=nCol; m_nStream=nStream;}
	
	virtual Value Format(const Value& q)const
	{
		Tower& tower = *(Tower*)m_pTower;
		
		if(tower.GetStream(m_nStream).m_mean.GetCount()<=0)
			return " ";

		String s = q.ToString();
		int n = atoi(s);
		
		if(n<0 || n>=tower.GetStream(m_nStream).m_mean.GetCount())
			return q;
		
		switch(m_nCol)
		{
			case 0:
				if(n<tower.GetStream(m_nStream).m_mean.GetCount())
					return ::Format("%.2f",tower.GetStream(m_nStream).m_mean[n]);
				break;
			case 1:
				if(n<tower.GetStream(m_nStream).m_mean.GetCount())
					return ::Format("%.2f",tower.GetStream(m_nStream).m_sd[n]);
				break;
			case 2:
				if(n<tower.GetStream(m_nStream).m_mean.GetCount())
					return ::Format("%d",tower.GetStream(m_nStream).m_flag[n]);
		}

		return " ";
	}

	virtual Value Scan(const Value& text) const
	{
		Tower& tower = *(Tower*)m_pTower;
		
		if(tower.GetStream(m_nStream).m_mean.GetCount()<=0)
			return " ";
		
		if(m_nCol<2)
		{
			double f = atof(text.ToString());	
			
			if(m_nCol==0)
			{
				tower.GetStream(m_nStream).m_mean[m_nRec] = f;						
			}
			else
			{
				tower.GetStream(m_nStream).m_sd[m_nRec] = f;						
			}			
		}
		else
		{
			int n = atoi(text.ToString());
			
			tower.GetStream(m_nStream).m_flag[m_nRec] = n;			
		}
		
		return text;	
	}


	void* m_pTower;
	int m_nRec;
	int m_nCol;
	int m_nStream;
};

class Step1Tab : public WithGridLayout1<ParentCtrl>
{
	typedef Step1Tab CLASSNAME;
public: 	
	Step1Tab(const Step1Tab& s1t)
	{
		m_pMain = s1t.m_pMain;
		m_nSiteID = s1t.m_nSiteID;
		
		m_disp.m_pMain = m_pMain;
		m_overview.m_pMain = m_pMain;

		m_grid.WhenScroll = THISBACK(OnScroll);
		m_grid.WhenCursor = THISBACK(OnScroll);

		up.SetImage(WRAImg::Up);
		down.SetImage(WRAImg::Down);

		down.WhenAction = THISBACK(OnNextFlag);
		up.WhenAction = THISBACK(OnLastFlag);
		
		buttonProcess.WhenAction = THISBACK(Step122);
	}
	Step1Tab(void* pMain,int nMastID)
	{
		m_pMain=pMain;
		m_nSiteID=nMastID;
		
		m_disp.m_pMain = m_pMain;
		m_overview.m_pMain = m_pMain;
		
		m_grid.WhenScroll = THISBACK(OnScroll);
		m_grid.WhenCursor = THISBACK(OnScroll);
		
		up.SetImage(WRAImg::Up);
		down.SetImage(WRAImg::Down);

		down.WhenAction = THISBACK(OnNextFlag);
		up.WhenAction = THISBACK(OnLastFlag);
		
		buttonProcess.WhenAction = THISBACK(Step122);

	}
	virtual ~Step1Tab(){m_grid.Clear();}
	
	void OnScroll();
	
	void OnNextFlag();
	void OnLastFlag();
	
	void DragAndDrop(Point p, PasteClip& d);	
	
	void* m_pMain;
	int m_nSiteID;
	
	void Step122();

	FlagDisplay m_disp;
	NumberToDateTime m_conDate;
	Array <ConvertMet1> m_converts;
	Array <EditDouble> m_edits;
	Array <ConvertEdit> m_convertEdits;

};



class FlagColorsDlg : public WithFlagsLayout<TopWindow>
{
	typedef FlagColorsDlg CLASSNAME;	
public:
	FlagColorsDlg()
	{
		CtrlLayoutOKCancel(*this,"Choose Flag Colours");
		
		
		
	}
	
	virtual~ FlagColorsDlg(){}	
	
	
	
};


class TowersTab : public WithMetTowersLayout<ParentCtrl>
{
	
public: 	
	
	virtual ~TowersTab(){}
	
	void DragAndDrop(Point p, PasteClip& d);	
	
	void* m_pMain;
	
};



class Wrap : public WithWrapLayout<TopWindow> 
{
public:
	typedef Wrap CLASSNAME;
	Wrap();
	
	virtual ~Wrap(){}
	
	TowersTab towers;
	Array<WithMetTowerDefLayout<ParentCtrl> > towerDefs; // array of tabs

	
	WithMetDataLayout<ParentCtrl> step1;
	WithMetDataLayout<ParentCtrl> step2;
	WithMetDataLayout<ParentCtrl> step3;
	WithMetDataLayout<ParentCtrl> step4;
	WithMetDataLayout<ParentCtrl> step5;
	WithMetDataLayout<ParentCtrl> step6;

	Array <Step1Tab> met1s;
	Array <WithGridLayout2<ParentCtrl> > met2s;
	Array <WithGridLayout2<ParentCtrl> > met3s;
	
	MenuBar menu;
	// menu event handler functions
	void MainMenu(Bar& bar);
	void SubMenuFile(Bar& bar);
	void SubMenuView(Bar& bar);
	void SubMenuSettings(Bar& bar);

	
	// main toolbar
	ToolBar tool;
	void FillToolBar(Bar& bar);
	
	void OnViewMap();
	void OnAddTower();
	void OnFlagColors();
	
	void GetTowerDefs();
	void GetTowerDef(int i);
	void UpdateTowerDefs();
	void UpdateTowerDef(int i);

	void UpdateLog(int iMast);
	void Step122();


	void UpdateStep1(int n);
	void OnStartEditStep1(int n);

	void OpenTowerXML(String path);
	void OpenTabDelimited(String path,int nMastID);
	void OpenCSV(String path,int nSiteID);




	Time StringToTime(String s);
	String MeaningAsString(MEANING m);
	MEANING StringToMeaning(String s);
	
	int SiteToIndex(int nMastID);	
	int MastToIndex(int nMastID);
	
	void OnSave();
	void OnOpenXML();
	void OnExit();
	
	Color GetFlagColor(int flag);
	
	
	
protected:	
		
	Array <Tower> m_towers;
	
	MapDlgDlg m_map;
	
	Color m_colFlags[10];
	
};

#endif
