#ifndef _GoogleMaps_GoogleMaps_h
#define _GoogleMaps_GoogleMaps_h

#include <CtrlLib/CtrlLib.h>
#include <Web/Web.h>


using namespace Upp;





struct MapImage : public Ctrl 
{
	Image  map;
	String error;
	Point  home;
	
	Callback1<Point> WhenLeftClick;
	
	virtual void LeftDown(Point p, dword)
	{
		WhenLeftClick(p);
	}
	
	virtual void Paint(Draw& w);
	
	MapImage() { SetFrame(ViewFrame()); BackPaint(); }
	
	virtual void MouseWheel(Point p, int zdelta, dword keyflags){GetParent()->MouseWheel(p,zdelta,keyflags);}

//	virtual void MouseLeftDown(Point p, dword);

//	virtual void MouseMove(Point pos, dword flags);
	
	virtual bool Key(dword key,int count);
	
	
	
};


struct MapDlgDlg : public WithMapDlgLayout<TopWindow> 
{
	typedef MapDlgDlg CLASSNAME;

	Pointf   home;
	Pointf   center;
	MapImage map;
	
	void LoadMap();
	void SetHome();
	void MapClick(Point p);
	
	void ZoomIn();
	void ZoomOut();
	void Move(int x, int y);
	
	virtual void MouseWheel(Point p, int zdelta, dword keyflags);	
	
	
	void   Set(Pointf p);
	Pointf Get() { return home; }
	
	MapDlgDlg();


};


void   SetGoogleMapsKey(const char *key);
String GetGoogleMap(double center_x, double center_y, int zoom, int cx, int cy,
                    const char *format = "png", String *error = NULL);
Image  GetGoogleMapImage(double center_x, double center_y, int zoom, int cx, int cy,
                         const char *format = "png", String *error = NULL);
double CvDeg(double deg, double minutes, double seconds);

Pointf GoogleMapsPixelToGps(Pointf center, int zoom, Point diff);
Pointf GoogleMapsPixelToGps(Pointf center, int zoom, Size sz, Point p);
Pointf GoogleMapsGpsToPixelDiff(Pointf center, int zoom, Pointf gps);
Pointf GoogleMapsGpsToPixel(Pointf center, int zoom, Size sz, Pointf gps);

Pointf ScanGPS(const char *s);

String FormatGPSX(double x);
String FormatGPSY(double y);
String FormatGPS(Pointf p);

bool MapDlg(Pointf& p);
void MapDlgAsThread(Pointf& p);

#endif
