//
//
// Utils.cpp: implementation of the CUtils class.
//
//////////////////////////////////////////////////////////////////////


#include "WRA.h"

#include "Utils.h"





//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CUtils::CUtils()
{

}

CUtils::~CUtils()
{

}

int CUtils::GetMonthIndex(String month)
{
	if(ToUpper(month).Find("JAN")>=0)
		return 1;	
	if(ToUpper(month).Find("FEB")>=0)
		return 2;	
	if(ToUpper(month).Find("MAR")>=0)
		return 3;	
	if(ToUpper(month).Find("APR")>=0)
		return 4;	
	if(ToUpper(month).Find("MAY")>=0)
		return 5;	
	if(ToUpper(month).Find("JUN")>=0)
		return 6;	
	if(ToUpper(month).Find("JUL")>=0)
		return 7;	
	if(ToUpper(month).Find("AUG")>=0)
		return 8;	
	if(ToUpper(month).Find("SEP")>=0)
		return 9;	
	if(ToUpper(month).Find("OCT")>=0)
		return 10;	
	if(ToUpper(month).Find("NOV")>=0)
		return 11;	
	if(ToUpper(month).Find("DEC")>=0)
		return 12;	
	
	return -1;
}


String CUtils::GetMonth(int m) // 1 based
{
	switch(m)
	{
		case 1:
			return "January";
		case 2:
			return "February";
		case 3:
			return "March";
		case 4:
			return "April";
		case 5:
			return "May";
		case 6:
			return "June";
		case 7:
			return "July";
		case 8:
			return "August";
		case 9:
			return "September";
		case 10:
			return "October";
		case 11:
			return "November";
		case 12:
			return "December";
		default:
			return "undefined";	
	}
	
	return "unknown error";
}

int CUtils::GetDaysInMonth(int m)
{
	int days[12] = {31,31,28,30,31,30,31,31,30,31,30,31};
	
	return days[m-1];	
}

int CUtils::GetMonthFromMinuteOfYear(int moy)
{
	int day = moy/1440;
	
	for(int i=1;i<=12;i++)
	{
		day-=GetDaysInMonth(i);
	
		if(day<0)
			return i;
	}
	
	return 12;  
}

bool CUtils::IsSame(Rectf rc1,Rectf rc2)
{
	if(fabs(rc1.left-rc2.left)>0.01)return false;
	if(fabs(rc1.right-rc2.right)>0.01)return false;
	if(fabs(rc1.bottom-rc2.bottom)>0.01)return false;
	if(fabs(rc1.top-rc2.top)>0.01)return false;

	return true;
}

bool CUtils::IsGeo(Rectf& rc)
{
	if(rc.left>360.0)return false;
	if(rc.left<-360.0)return false;
	if(rc.right>360.0)return false;
	if(rc.right<-360.0)return false;
	
	if(rc.top>180.0)return false;
	if(rc.top<-180.0)return false;
	if(rc.bottom>180.0)return false;
	if(rc.bottom<-180.0)return false;
	
	return true;	
}

Pointf CUtils::GetNearestNodePt(Pointf pt,Rectf rcGrid,double res)
{
	pt.x = rcGrid.left + res*int((pt.x-rcGrid.left)/res+0.5);
	pt.y = rcGrid.bottom + res*int((pt.y-rcGrid.bottom)/res+0.5);
		
	return pt;	
}

short CUtils::BigEndianShort(char* p)
{
	short* pI;
	char cBuf[3];

	cBuf[0] = p[1];
	cBuf[1] = p[0];
	cBuf[2] = 0;
	pI = (short*)cBuf;

	return *pI;	
}

unsigned short CUtils::BigEndianUnsignedShort(char* p)
{
	unsigned short* pI;
	char cBuf[3];

	cBuf[0] = p[1];
	cBuf[1] = p[0];
	cBuf[2] = 0;
	pI = (unsigned short*)cBuf;

	return *pI;	
}


unsigned int CUtils::BigEndianUnsignedInt(char* p)
{
	unsigned int* pI;
	char cBuf[5];

	cBuf[0] = p[3];
	cBuf[1] = p[2];
	cBuf[2] = p[1];
	cBuf[3] = p[0];
	cBuf[4] = 0;
	pI = (unsigned int*)cBuf;

	return *pI;	
}

int CUtils::BigEndianInt(char* p)
{
	int* pI;
	char cBuf[5];

	cBuf[0] = p[3];
	cBuf[1] = p[2];
	cBuf[2] = p[1];
	cBuf[3] = p[0];
	cBuf[4] = 0;
	pI = (int*)cBuf;

	return *pI;	
}
	
double CUtils::BigEndianDouble(char* p)
{
	double* pD;
	char cBuf[9];

	cBuf[0] = p[7];
	cBuf[1] = p[6];
	cBuf[2] = p[5];
	cBuf[3] = p[4];
	cBuf[4] = p[3];
	cBuf[5] = p[2];
	cBuf[6] = p[1];
	cBuf[7] = p[0];
	cBuf[8] = 0;
	pD = (double*)cBuf;

	return *pD;	
}

float CUtils::BigEndianFloat(char* p)
{
	float* pD;
	char cBuf[5];

	cBuf[0] = p[3];
	cBuf[1] = p[2];
	cBuf[2] = p[1];
	cBuf[3] = p[0];
	cBuf[4] = 0;
	pD = (float*)cBuf;

	return *pD;	
}


int CUtils::LittleEndianInt(char* p)
{
	int* pI;
	char cBuf[5];

	memcpy(cBuf,p,4);
	cBuf[4] = 0;
	pI = (int*)cBuf;

	return *pI;	
}
	
double CUtils::LittleEndianDouble(char* p)
{
	double* pD;
	char cBuf[9];

	memcpy(cBuf,p,8);
	cBuf[8] = 0;
	pD = (double*)cBuf;

	return *pD;	
}

float CUtils::LittleEndianFloat(char* p)
{
	float* pD;
	char cBuf[5];

	memcpy(cBuf,p,4);
	cBuf[4] = 0;
	pD = (float*)cBuf;

	return *pD;	
}

int CUtils::comma(const char *ptr, int j)
{

	for(;j<=LILEN;j++)
	{
		if(ptr[j]==',')
			break;
	}		

	return(j+1);
}

String CUtils::tocomma(const char *ptr,int j)
{
	int start = j;
	char cBuf[LILEN];
	String s;
	int i;
	
	for(i=0;j<=LILEN;j++,i++)
	{
		if(ptr[j]==',')
			break;
	}		
	
	strncpy(cBuf,ptr+start,i);
	cBuf[i]=0;
	
	s = Format("%s",cBuf);
	
	return s;	
}

int CUtils::space(const char *ptr, int j)
{

//	for(;j<=LILEN;j++)
	for(;;j++)
	{
		if(isspace(ptr[j])==0)// && ptr[j]!='\r' && ptr[j]!='\n')
			break;
	}		

	return(j);
}

int CUtils::number(const char *ptr, int j)
{
//	for(;j<=LILEN;j++)
	for(;;j++)
	{
		if(ptr[j]==0 || (isgraph(ptr[j])==0 && ptr[j]!='-')) // any character except space
			break;
	}		

	return(j);
}

int CUtils::graph(const char *ptr, int j)
{
//	for(;j<=LILEN;j++)
	for(;;j++)
	{
		if(isgraph(ptr[j])==0) // any character except space
			break;
	}		

	return(j);
}

String CUtils::TermInQuotes(char* pBuf,int& c)
{
	char cQuote = '\"';

	return TermInQuotes(pBuf,c,cQuote);
}

String CUtils::TermInQuotes(char* pBuf,int& c,char cQuote)
{
	char cBuf[LILEN];
	String s;
	int i=0;

	for(;c<(int)strlen(pBuf);c++)
	{
		if(pBuf[c]==cQuote)
			break;		
	}

	c++;

	for(;c<(int)strlen(pBuf);c++)
	{
		if(pBuf[c]==cQuote)
			break;

		cBuf[i++] = pBuf[c];
	}

	c++;

	cBuf[i] = '\0';

	s=cBuf;

	return s;
}

Point CUtils::GetSouthEastNodeIndices(const Pointf& pt,const Rectf& rcGrid,const double& res)
{
	Point ptSE;
	
	ptSE.x = int((pt.x-rcGrid.left)/res);
	ptSE.y = int((pt.y-rcGrid.bottom)/res);
	
	return ptSE;
}

Pointf CUtils::GetSouthEastNodePt(const Pointf& pt,const Rectf& rcGrid,const double& res)
{
	Point ptI = CUtils::GetSouthEastNodeIndices(pt,rcGrid,res);

	return Pointf(rcGrid.left+ptI.x*res,rcGrid.bottom+ptI.y*res);
}

bool CUtils::IsPtInRect(Point& pt, Rect& rc) // references are for speed only
{
	if(pt.x>rc.right) return false;
	if(pt.x<rc.left) return false;
	if(pt.y>rc.top) return false;
	if(pt.y<rc.bottom) return false;

	return true;
}

bool CUtils::IsPtInRect(Pointf& pt, Rectf& rc) // references are for speed only
{
	if(pt.x>rc.right) return false;
	if(pt.x<rc.left) return false;
	if(pt.y>rc.top) return false;
	if(pt.y<rc.bottom) return false;

	return true;
}

// below is some sample code from the microsoft website
// I believe this code is public domain as it is discussed in at least 
// two books by different authors

 /*************************************************************************

   * FUNCTION:   G_PtInPolygon
   *
   * PURPOSE
   * This routine determines if the point passed is in the polygon. It uses

   * the classical polygon hit-testing algorithm: a horizontal ray starting

   * at the point is extended infinitely rightwards and the number of
  * polygon edges that intersect the ray are counted. If the number is odd,

   * the point is inside the polygon.
   *
   * RETURN VALUE
   * (bool) true if the point is inside the polygon, false if not.
 *************************************************************************/ 

bool CUtils::G_PtInPolygon(Point *rgpts, int wnumpts, Point ptTest,Rect r)
{
	
	Point  *ppt ;
	int   i ;
	Point  pt1, pt2 ;
	int   wnumintsct = 0 ;
	bool b1;//,b2,b3;
	
	if (!G_PtInPolyRect(rgpts,wnumpts,ptTest,&r))
		return false ;
	
	{
		pt1 = pt2 = ptTest ;
		pt2.x = r.right + 1000000 ; // we draw one line only
		
		// Now go through each of the lines in the polygon and see if it
		// intersects
		for (i = 0, ppt = rgpts ; i < wnumpts-1 ; i++, ppt++)
		{
			if (Intersect(ptTest, pt2, *ppt, *(ppt+1)))
				wnumintsct++ ;
		}
		
		// And the last line
		if (Intersect(ptTest, pt2, *ppt, *rgpts))
			wnumintsct++ ;
		
		b1 = (wnumintsct&1) ;
	}
	
	return (wnumintsct&1) ;
}

bool CUtils::G_PtInPolygonf(Pointf *rgpts, int wnumpts, Pointf ptTest,Rectf r)
{
	Pointf  *ppt ;
	int   i ;
	Pointf  pt1, pt2 ;
	int   wnumintsct = 0 ;
	bool b1;//,b2,b3;
	
	if (!G_PtInPolyRectf(rgpts,wnumpts,ptTest,&r))
		return false ;
	
	{
		pt1 = pt2 = ptTest ;
		pt2.x = r.right + 1000000.0 ; // we draw one line only
		
		// Now go through each of the lines in the polygon and see if it
		// intersects
		for (i = 0, ppt = rgpts ; i < wnumpts-1 ; i++, ppt++)
		{
			if(		(pt1.y < (*ppt).y && pt1.y > (*(ppt+1)).y)
			   ||	(pt1.y > (*ppt).y && pt1.y < (*(ppt+1)).y)	)
			{
				if (Intersectf(ptTest, pt2, *ppt, *(ppt+1)))
					wnumintsct++;
			}
		}
		
		// And the last line
		if (Intersectf(ptTest, pt2, *ppt, *rgpts))
			wnumintsct++ ;
		
		b1 = (wnumintsct&1) ;
	}

	return (wnumintsct&1) ;
}


/*************************************************************************

   * FUNCTION:   G_PtInPolyRect
   *
   * PURPOSE
   * This routine determines if a point is within the smallest rectangle
   * that encloses a polygon.
   *
   * RETURN VALUE
   * (bool) true or false depending on whether the point is in the rect or

   * not.
 *************************************************************************/ 

bool  CUtils::G_PtInPolyRect(Point *rgpts, int wnumpts, Point ptTest,
         Rect *prbound)
{
	
	// If a bounding rect has not been passed in, calculate it
	if (prbound->bottom!=0 || prbound->right!=0 || prbound->top!=0)
	{
		//	   TRACE("\nbad nick!!!");
		;
	}
	else
	{
		//		TRACE("\nbad rect!!!");
		int   xmin, xmax, ymin, ymax ;
		Point *ppt ;
		int  i ;
		
		xmin = ymin = ABOVE_RANGE;//INT_MAX ;
		xmax = ymax = -ABOVE_RANGE;//-INT_MAX ;
		
		for (i=0, ppt = rgpts ; i < wnumpts ; i++, ppt++)
		{
			if (ppt->x < xmin)
				xmin = ppt->x ;
			if (ppt->x > xmax)
				xmax = ppt->x ;
			if (ppt->y < ymin)
				ymin = ppt->y ;
			if (ppt->y > ymax)
				ymax = ppt->y ;
		}
		//      SetRect(*prbound, xmin, ymin, xmax, ymax) ;
		
		prbound->left = xmin;
		prbound->right = xmax;
		prbound->top = ymax;
		prbound->bottom = ymin;
	}
	
	return (PtInMPRect(*prbound,ptTest)) ;

}
 
bool  CUtils::G_PtInPolyRectf(Pointf *rgpts, int wnumpts, Pointf ptTest,
             Rectf *prbound)
{
	
	// If a bounding rect has not been passed in, calculate it
	if (prbound->bottom!=0 || prbound->right!=0 || prbound->top!=0)
	{
		;
	}
	else
	{
		double   xmin, xmax, ymin, ymax ;
		Pointf *ppt ;
		int  i ;
		
		xmin = ymin = ABOVE_RANGE;//INT_MAX ;
		xmax = ymax = -ABOVE_RANGE;//-INT_MAX ;
		
		for (i=0, ppt = rgpts ; i < wnumpts ; i++, ppt++)
		{
			prbound->left = min(prbound->left,ppt->x);
			prbound->right = max(prbound->right,ppt->x);
			prbound->bottom = min(prbound->bottom,ppt->y);
			prbound->top = max(prbound->top,ppt->y);
		}
	
	}
	
	return (PtInMPRectf(*prbound,ptTest)) ;

}
 

/*************************************************************************
   * FUNCTION:   Intersect
   *
   * PURPOSE
   * Given two line segments, determine if they intersect.
   *
   * RETURN VALUE
   * true if they intersect, false if not.
 *************************************************************************/ 

bool CUtils::Intersect(Point& p1, Point& p2, Point& p3, Point& p4)
{
	return ((( CCW(p1, p2, p3) * CCW(p1, p2, p4)) <= 0)	
	    && (( CCW(p3, p4, p1) * CCW(p3, p4, p2)  <= 0) )) ;
}

// floating point version
bool CUtils::Intersectf(Pointf& p1, Pointf& p2, Pointf& p3, Pointf& p4)
{
	return ((( CCWf(p1, p2, p3) * CCWf(p1, p2, p4)) <= 0)	
	    && (( CCWf(p3, p4, p1) * CCWf(p3, p4, p2)  <= 0) )) ;
}


/*************************************************************************

   * FUNCTION:   CCW (CounterClockWise)
   *
   * PURPOSE
   * Determines, given three points, if when travelling from the first to
   * the second to the third, we travel in a counterclockwise direction.
   *
   * RETURN VALUE
   * (int) 1 if the movement is in a counterclockwise direction, -1 if
   * not.
 *************************************************************************/ 

int CUtils::CCW(Point& p0, Point& p1, Point& p2)

{
	
	int dx1, dx2 ;
	int dy1, dy2 ;
	
	dx1 = p1.x - p0.x ; dx2 = p2.x - p0.x ;
	dy1 = p1.y - p0.y ; dy2 = p2.y - p0.y ;
	
	/* This is basically a slope comparison: we don't do divisions because
	
	* of divide by zero possibilities with pure horizontal and pure
	* vertical lines.
	*/ 
	
	return ((dx1 * dy2 > dy1 * dx2) ? 1 : -1) ;

}

// floating point version
int CUtils::CCWf(Pointf& p0, Pointf& p1, Pointf& p2)

{
	
	double dx1, dx2 ;
	double dy1, dy2 ;
	
	dx1 = p1.x - p0.x ; dx2 = p2.x - p0.x ;
	dy1 = p1.y - p0.y ; dy2 = p2.y - p0.y ;
	
	/* This is basically a slope comparison: we don't do divisions because
	
	* of divide by zero possibilities with pure horizontal and pure
	* vertical lines.
	*/ 
	
	return ((dx1 * dy2 > dy1 * dx2) ? 1 : -1) ;

}


 /*************************************************************************

   * FUNCTION:   PtInPolyPolygon
   *
   * PURPOSE
   * 
   * this function uses the point in polygon function above to test a more
   * complex shape made of multiple polygons
   * 
   * the point is inside the polygon.
   *
   * RETURN VALUE
   * (bool) true if the point is inside the polygon, false if not.
 *************************************************************************/ 

bool CUtils::PtInPolyPolygon(LineArray& lines, Point ptTest,Rect r)
{

	int i,j,num,nMax = lines.GetCount();
	int count = 0;
	Point *rgpts;
	
	for(i=0;i<nMax;i++)
	{
		num = lines[i].GetCount();
	
		rgpts = new Point[num];
	
		for(j=0;j<num;j++)
		{
			rgpts[j] = lines[i][j];
		}
	
		if(G_PtInPolygon(rgpts,num,ptTest,r))
			count++;
	
		delete[] rgpts;
	}

return (count&1) ;

}

// floating point version
bool CUtils::PtInPolyPolygonf(LinefArray& lines, Pointf ptTest,Rectf r)
{
	int i,j,num,nMax = lines.GetCount();
	int count = 0;
//	Pointf *rgpts;
	Buffer<Pointf> rgpts;
	
	for(i=0;i<nMax;i++)
	{
		num = lines[i].GetCount();
	
//		rgpts = new Pointf[num];
		rgpts.Alloc(num);
	
		for(j=0;j<num;j++)
		{
			rgpts[j] = lines[i][j];
		}
	
		if(G_PtInPolygonf(rgpts,num,ptTest,r))
			count++;
	
//		delete[] rgpts;
	}
	
	return (count&1) ;

}




bool CUtils::PtInMPRect(Rect& rc,Point& pt)
{
	if(pt.x>rc.right)return false;
	if(pt.x<rc.left)return false;
	if(pt.y>rc.bottom && pt.y>rc.top)return false;
	if(pt.y<rc.bottom && pt.y<rc.top)return false;

	return true;
}

bool CUtils::PtInMPRectf(Rectf rc,Pointf pt)
{
	if(pt.x>rc.right)return false;
	if(pt.x<rc.left)return false;
	if(pt.y>rc.bottom && pt.y>rc.top)return false;
	if(pt.y<rc.bottom && pt.y<rc.top)return false;

	return true;
}


bool CUtils::PtInflatedMPRectf(Rectf& rc,Pointf& pt,double d)
{
	if(pt.x>rc.right+d)return false;
	if(pt.x<rc.left-d)return false;
	if(pt.y>rc.top+d)return false;
	if(pt.y<rc.bottom-d)return false;
	
	return true;
}

bool CUtils::PtInflatedMPRectf(Pointf ptRC1,Pointf ptRC2,Pointf& pt,double d)
{
	if(pt.x > max(ptRC1.x,ptRC2.x)+d)return false;
	if(pt.x < min(ptRC1.x,ptRC2.x)-d)return false;
	if(pt.y > max(ptRC1.y,ptRC2.y)+d)return false;
	if(pt.y < min(ptRC1.y,ptRC2.y)-d)return false;
	
	return true;
}




// back to string functions...  
  
int CUtils::GetFolderPath(char* folder,const char* path)
{
	int i,len = strlen(path);

	for(i=len-1;i>0;i--)
	{
#ifdef PLATFORM_WIN32
		if(path[i]=='\\')
#else
		if(path[i]=='/')
#endif
		{
			memcpy(folder,path,i);
			folder[i] = 0;
			break;
		}
	}

	return i;
}

String CUtils::GetFolder(const String path)
{
#ifdef PLATFORM_WIN32
	String s = path.Left(path.ReverseFind('\\'));
#else
	String s = path.Left(path.ReverseFind('/'));
#endif

	return s;
}

void CUtils::CombinedMapRect(Rectf& rc1,const Rectf rc2)
{
	rc1.left = min(rc1.left,rc2.left);
	rc1.right = max(rc1.right,rc2.right);
	rc1.top = max(rc1.top,rc2.top);
	rc1.bottom = min(rc1.bottom,rc2.bottom);
}

String CUtils::GetFileName(String path)
{
#ifdef PLATFORM_WIN32
	return path.Right(path.GetLength()-path.ReverseFind('\\')-1);
#else
	return path.Right(path.GetLength()-path.ReverseFind('/')-1);
#endif
}


/*************************************************************************
   * FUNCTION:   Intersection
   *
   * PURPOSE
   * Given two line segments that intersect, determine where they intersect.
   *
   * RETURN VALUE
   * the point at which they intersect
 *************************************************************************/ 

Point CUtils::Intersection(Point& p1, Point& p2, Point& p3, Point& p4)
{
	static double den, Ua, Ub;
	  
	den = ((p4.y-p3.y)*(p2.x-p1.x) - (p4.x-p3.x)*(p2.y-p1.y));

	if(den==0) // parallel
	{
		return Point(0,0);
	}

	Ua = ((p4.x-p3.x)*(p1.y-p3.y) - (p4.y-p3.y)*(p1.x-p3.x))/den;

//	Ub = ((p2.x-p1.x)*(p1.y-p3.y) - (p2.y-p1.y)*(p1.x-p3.x))/den;

	if(Ua>1 || Ua<0)return Point(0,0);

//	if(Ub>1 || Ub<0)return Point(0,0);

	return Point((int)(p1.x+Ua*(p2.x-p1.x)+0.5),(int)(p1.y+Ua*(p2.y-p1.y)));	  

}

/*************************************************************************
   * FUNCTION:   Intersection
   *
   * PURPOSE
   * Given two line segments that intersect, determine where they intersect.
   *
   * RETURN VALUE
   * the point at which they intersect
 *************************************************************************/ 

Pointf CUtils::Intersectionf(Pointf& p1, Pointf& p2, Pointf& p3, Pointf& p4)
{
	static double den, Ua, Ub;
	  
	den = ((p4.y-p3.y)*(p2.x-p1.x) - (p4.x-p3.x)*(p2.y-p1.y));

	if(den==0) // parallel
	{
		return Point(0,0);
	}

	Ua = ((p4.x-p3.x)*(p1.y-p3.y) - (p4.y-p3.y)*(p1.x-p3.x))/den;

//		Ub = ((p2.x-p1.x)*(p1.y-p3.y) - (p2.y-p1.y)*(p1.x-p3.x))/den;

	if(Ua>1 || Ua<0)return Point(0,0);

//		if(Ub>1 || Ub<0)return Point(0,0);

	return Pointf(p1.x+Ua*(p2.x-p1.x),p1.y+Ua*(p2.y-p1.y));	  

}

// use only if we know we're crossing from inside to outside of rect or vice-versa
Pointf CUtils::Intersectionf(Pointf& p1, Pointf& p2,Rectf& rc)
{
	Pointf pt3,pt4;
	
	pt3 = rc.TopLeft();
	pt4 = rc.TopRight();
	
	if(CUtils::Intersectf(p1,p2,pt3,pt4))
	{
		return CUtils::Intersectionf(p1,p2,pt3,pt4);	
	}
	
	pt3 = rc.BottomRight();
	
	if(CUtils::Intersectf(p1,p2,pt3,pt4))
	{
		return CUtils::Intersectionf(p1,p2,pt3,pt4);	
	}
	
	pt4 = rc.BottomLeft();
	
	if(CUtils::Intersectf(p1,p2,pt3,pt4))
	{
		return CUtils::Intersectionf(p1,p2,pt3,pt4);	
	}
	
	pt3 = rc.TopLeft();
	
	if(CUtils::Intersectf(p1,p2,pt3,pt4))
	{
		return CUtils::Intersectionf(p1,p2,pt3,pt4);	
	}
	
	return Pointf(0.0,0.0); // should never happen	
}


/*
double CUtils::frand()
{
	return (double)rand()/(double)RAND_MAX;
}
 */
 /*
double CUtils::frand()
{
	return RandomInt32()/double(0xFFFFFFFF);
	//return RandomInt32()/4294967295.0; // there must be a better way to convert int into double 0 to 1
}
*/
/* 
// quick and dirty random number
// but way better than 16 bit ones 
// provided by the compiler
uint32 CUtils::RandomInt32()
{
	static uint32 idum = (uint32)time(NULL); // initialised different every time - phew!
	
//	DUMP(idum);
	
	idum = 1664525*idum + 1013904223;

	return idum;	
}
*/

String CUtils::EatSpace(String s)
{
	while(s[0]==' ')
		s.Remove(0);
	
	int c = s.GetLength()-1;

	if(c<0)
		return " ";
	
	while(s[c]==' ')
		s.Remove(c--);
	
	return s;
	
}

// in the following code we use point P to be a point
// points P0 and P1 to be the two ends of a line
// and points v and w to represent two vectors
double CUtils::Distance( Pointf P, Pointf P0, Pointf P1 )
{
	Pointf v = P1 - P0;
	Pointf w = P - P0;
	double c1,c2;
	if ( (c1 = DotProduct(w,v)) <= 0 )
	    return Distance(P, P0);
	if ( (c2 = DotProduct(v,v)) <= c1 )
	    return Distance(P, P1);
	double b = c1 / c2;
	Pointf Pb = P0 + b*v;
	return Distance(P, Pb);
}

Pointf CUtils::DistanceManhattan( Pointf P, Pointf P0, Pointf P1 )
{
	Pointf v = P1 - P0;
	Pointf w = P - P0;
	double c1,c2;
	if ( (c1 = DotProduct(w,v)) <= 0 )
	    return P-P0;
	if ( (c2 = DotProduct(v,v)) <= c1 )
	    return P-P1;
	double b = c1 / c2;
	Pointf Pb = P0 + b*v;
	return P-Pb;
}


double CUtils::DotProduct(Pointf v1, Pointf v2)
{
	return v1.x * v2.x + v1.y * v2.y;
}

double CUtils::Distance(Pointf p1,Pointf p2)
{
	return sqrt((p1.x-p2.x)*(p1.x-p2.x) + (p1.y-p2.y)*(p1.y-p2.y));	
}

float CUtils::Sqrt(float x)
{
	float xhalf = 0.5f*x;
	int i = *(int*)&x;
	i = 0x5f3759df - (i >> 1);
	x = *(float*)&i;
	x = x*(1.5f - xhalf*x*x);
	return float(1.0/x);
}


double CUtils::Distance3D(Pointf p1,double z1, Pointf p2,double z2)
{
	return sqrt((p1.x-p2.x)*(p1.x-p2.x) + (p1.y-p2.y)*(p1.y-p2.y) + (z1-z2)*(z1-z2));	
}

double CUtils::DistanceOfPointFromLine(Pointf3 pt3P,Pointf3 pt3A,Pointf3 pt3B)
{
	// taken from mathforum.org

//	Solution 1
//	__________
//	
//	Let,    A(x1,y1,z1), B(x2,y2,z2) = Two points defining the line 
//	        P(x,y,z) = Point whose distance from line AB is to be found
//	
//	We can find vectors,
//	        AB = <x2-x1, y2-y1, z2-z1> = <x3, y3, z3>
//	        AP = < x-x1,  y-y1, z-z1 > = <x4, y4, z4>
//	
//	I am using angle brackets < > to distinguish vectors from points.
//	
//	Now, let's take the cross product AB X AP.  This is how you can calculate it:
//	
//	    AB X AP = < y3*z4 - z3*y4, -(x3*z4 - x4*z3), x3*y4 - x4*y3 >
//	
//	Let's let (a) be the length of AB X AP.  Then
//	
//	    a = Sqrt{ (y3*z4 - z3*y4)^2 + (x3*z4 - x4*z3)^2 + (x3*y4 - x4*y3)^2 }
//	
//	If you divide (a) by the distance AB you will get the distance of P 
//	from line AB. Distance AB can be found using the distance formula as,
//	    AB = square root of (x3^2 + y3^2 + z3^2)
//	
//	Thus the distance we are looking for is a/AB.
//	
//	Now, did you see why it works? Because the length of the cross product (a)
//	gives the area of the Parallelogram formed by the vectors AB and AP as
//	shown. If you rest the parallelogram on AB as the base, its area (a) is
//	AB*h. Where (h) is the height, which is nothing but the distance we are
//	looking for!
//	
//	      P
//	      o------+------o
//	       \     |       \
//	        \    |h       \
//	         \   |         \
//	    ------o--+----------o-----------
//	          A             B
//	
//	As for the last part of your question : When a line is given only in 
//	terms of its inclinations with the coordinate axes, then the line could 
//	'float' anywhere parallel to itself, because its not 'anchored' to (or 
//	through) any point. In such a case, its distance from point P is not 
//	fixed.
//	
//	
//	Solution 2
//	__________
//	
//	If you want, you can avoid using vectors and cross products, but it 
//	takes a little more work, because you need to find distances AB, BP, PA 
//	first using the distance formula. After that it's just as quick!
//	
//	This time use triangle ABP instead of the parallelogram.
//	
//	Let   h = height of triangle ABP (with AB as base)
//	        = the distance to be found
//	      T = Area of triangle ABP
//	      s = (AB + BP + PA)/2  This is called the semiperimeter
//	
//	Then, T = square root of {s*(s-AB)*(s-BP)*(s-PA)}
//	
//	The desired distance h = 2*T/AB
//	
	
	// implementing solution 1 above
	
	Pointf3 vAB(pt3B.x-pt3A.x,pt3B.y-pt3A.y,pt3B.z-pt3A.z);
	Pointf3 vAP(pt3P.x-pt3A.x,pt3P.y-pt3A.y,pt3P.z-pt3A.z);

	double a = sqrt( sqr(vAB.y*vAP.z-vAB.z*vAP.y) + sqr(vAB.x*vAP.z-vAB.z*vAP.x) + sqr(vAB.x*vAP.y-vAB.y*vAP.x) );
	double AB = sqrt( sqr(vAB.x) + sqr(vAB.y) + sqr(vAB.z) );
	
	return a/AB;
	
	// many thanks to Ujjwal Rane (urane@asu.edu)
}

Rectf CUtils::MPRect(Pointf pt1,Pointf pt2)
{
	Rectf rc;
	
	rc.left = min(pt1.x,pt2.x);
	rc.right = max(pt1.x,pt2.x);
	rc.top = max(pt1.y,pt2.y);
	rc.bottom = min(pt1.y,pt2.y);
	
	return rc;	
}

Rectf CUtils::MPRect(Pointf pt1,Pointf pt2,Pointf pt3)
{
	Rectf rc;
	
	rc.left = min(min(pt1.x,pt2.x),pt3.x);
	rc.right = max(max(pt1.x,pt2.x),pt3.x);
	rc.top = max(max(pt1.y,pt2.y),pt3.y);
	rc.bottom = min(min(pt1.y,pt2.y),pt3.y);
	
	return rc;	
}

Rectf CUtils::MPRect(Rectf rc,Pointf pt2)
{
	rc.left = min(rc.left,pt2.x);
	rc.right = max(rc.right,pt2.x);
	rc.top = max(rc.top,pt2.y);
	rc.bottom = min(rc.bottom,pt2.y);
	
	return rc;	
}
/*
void CUtils::GetGaussianDistributedRandomNumber(double& y1,double& y2)
{
	double x1, x2, w;
	
	do {
		 x1 = 2.0 * frand() - 1.0;
		 x2 = 2.0 * frand() - 1.0;
		 w = x1 * x1 + x2 * x2;
	}while(w >= 1.0);
	
	w = sqrt( (-2.0 * log( w ) ) / w );
	y1 = x1 * w;
	y2 = x2 * w;
	
//	return sqrt(-2.0 * log(frand())) * cos(2.0 * PI * frand());
}


double CUtils::GetGaussianDistributedRandomNumber()
{
	double x1, x2, w, y1, y2;
	
	do {
		 x1 = 2.0 * frand() - 1.0;
		 x2 = 2.0 * frand() - 1.0;
		 w = x1 * x1 + x2 * x2;
	} while ( w >= 1.0 );
	
	w = sqrt( (-2.0 * log( w ) ) / w );
	y1 = x1 * w;
	y2 = x2 * w;

	return y1;
	
//	return sqrt(-2.0 * log(frand())) * cos(2.0 * PI * frand());
}
*/

// used as a better alternaive to interpolating a value
double CUtils::GetNormAreaUnderRose(double startRadians,double stopRadians,doubleArray& d,doubleArray& prob)
{
	// this function peices together the wind rose to give an precise estimate of the 
	// area under the curve. 

	int nSectors = d.GetCount();
	double fSectors = nSectors;
	
	double f,res=0.0;
	double p=0.0;
	
	// express start and stop angle as sectors
	startRadians*=fSectors/(2.0*PI);
	stopRadians*=fSectors/(2.0*PI);
	
	// rotate by half a sector clockwise to convert into sector indices
	startRadians += 0.5;
	stopRadians += 0.5;
	
	// get first sector
	int sec = (int)(startRadians);
	while(sec>=nSectors)
	{
		sec-=nSectors;
		startRadians-=fSectors;
		stopRadians-=fSectors;
	}

	// first segment
	f = min(stopRadians,(double)sec+1.0);
	res += (f-startRadians)*d[sec]*prob[sec];
	p += (f-startRadians)*prob[sec];

	// middle segments
	while(stopRadians>(double)(++sec+1)) // increment sec ready for last segment
	{
		while(sec>=nSectors)
		{
			sec-=nSectors;
			startRadians-=fSectors;
			stopRadians-=fSectors;
		}
		// add a whole wind rose sector
		res += d[sec]*prob[sec];///fSectors; // probably never executed
		p += prob[sec];
	}
	
	while(sec>=nSectors)
	{
		sec-=nSectors;
		startRadians-=fSectors;
		stopRadians-=fSectors;
	}

	// last segment
	f = max(0.0,stopRadians-(double)sec);
	res += f*d[sec]*prob[sec];
	p += f*prob[sec];
	
	if(p<=0.0)
		return 0.0; // if there are no occurrences then there should be zero quantity
	
	return res/p; 
}


double CUtils::GetNormAreaUnderRose(double startRadians,double stopRadians,doubleArray& d)
{
	// this function peices together the wind rose to give an precise estimate of the 
	// area under the curve. 

	int nSectors = d.GetCount();
	double fSectors = nSectors;
	
	double f,res=0.0;
	double p=0.0;
	
	// express start and stop angle as sectors
	startRadians*=fSectors/(2.0*PI);
	stopRadians*=fSectors/(2.0*PI);
	
	// rotate by half a sector clockwise to convert into sector indices
	startRadians += 0.5;
	stopRadians += 0.5;
	
	// get first sector
	int sec = (int)(startRadians);
	while(sec>=nSectors)
	{
		sec-=nSectors;
		startRadians-=fSectors;
		stopRadians-=fSectors;
	}

	if(sec<0)
		return 0.0;

	// first segment
	f = min(stopRadians,(double)sec+1.0);
	res += (f-startRadians)*d[sec];//*prob[sec];
//	p += (f-startRadians);//*prob[sec];

	// middle segments
	while(stopRadians>(double)(++sec+1)) // increment sec ready for last segment
	{
		while(sec>=nSectors)
		{
			sec-=nSectors;
			startRadians-=fSectors;
			stopRadians-=fSectors;
		}
		// add a whole wind rose sector
		res += d[sec];//*prob[sec];///fSectors; // probably never executed
//		p += prob[sec];
	}
	
	while(sec>=nSectors)
	{
		sec-=nSectors;
		startRadians-=fSectors;
		stopRadians-=fSectors;
	}

	// last segment
	f = max(0.0,stopRadians-(double)sec);
	res += f*d[sec];//*prob[sec];
//	p += f*prob[sec];
	
	return res/(stopRadians-startRadians);///p; 
}

bool CUtils::IsRectfInRectf(Rectf rcOuter,Rectf rcInner)
{
	if(rcInner.left<rcOuter.left)return false;
	if(rcInner.right>rcOuter.right)return false;
	if(rcInner.bottom<rcOuter.bottom)return false;
	if(rcInner.top>rcOuter.top)return false;	
	
	return true;	
}

double CUtils::Decimals(double val,int dec)
{
	double f = 1.0;
	
	for(int i=0;i<dec;i++)
		f*=10.0;
	
	val *= f;
	
	val += 0.5; // to round up as well as down
	
	val = (int)val;
	
	return val/f;	
}


double CUtils::BiLinear(Pointf pt,double res,double d1,double d2,double d3,double d4)
{
	return BiLinear(pt,res,res,d1,d2,d3,d4);
}

// takes 4 values
double CUtils::BiLinear(Pointf pt,double resX,double resY,double d1,double d2,double d3,double d4)
{
// taken from What's the point? Interpolation and extrapolation with a regular grid DEM
//	David Kidner1, Mark Dorey1 & Derek Smith2
//	University of Glamorgan
//	1School of Computing
//	2Division of Mathematics & Computing
//	Pontypridd, Rhondda Cynon Taff
//	WALES, U.K. CF37 1DL 
// found at http://www.geovista.psu.edu/sites/geocomp99/Gc99/082/gc_082.htm

//RTIMING("CUtils::BiLinear");

	const double x = pt.x/resX;
	const double y = pt.y/resY;

	const double a00 = d1;
	const double a10 = d2-d1;
	const double a01 = d3-d1;
	const double a11 = d1-d2-d3+d4; 
	
	return a00 + a10*x + a01*y + a11*x*y;
	
	
	
}


double CUtils::BiCubic(Pointf pt,Pointf ptOffset,int nX,int nY,double resx,double resy,const Grid3d<double>& d,const int sec)//d[x][y][sec]
{
	// dont copy whole array, just the 16 points we need
	int x,y;
	
	x = (int)((pt.x-ptOffset.x) / resx);
	y = (int)((pt.y-ptOffset.y) / resy);
	
	d2Array z;
	z.SetCount(4);
	for(int i=0;i<4;i++)
	{
		z[i].SetCount(4);
		for(int j=0;j<4;j++)
		{
//			z[i][j] = d[min(nX-1,max(0,(x+i-1)))][min(nY-1,max(0,(y+j-1)))][sec];	
			z[i][j] = d.Get(min(nX-1,max(0,(x+i-1))),min(nY-1,max(0,(y+j-1))),sec);	
		}
	}
	
	pt.x -= ptOffset.x + x*resx;
	pt.y -= ptOffset.y + y*resy;

	return BiCubic(pt,resx,resy,z);
}


double CUtils::BiCubic(Pointf pt,Pointf ptOffset,int nX,int nY,double resx,double resy,const d2Array& d)//d[x][y]
{
	// dont copy whole array, just the 16 points we need
	int x,y;
	
	x = (int)((pt.x-ptOffset.x) / resx);
	y = (int)((pt.y-ptOffset.y) / resy);
	
	d2Array z;
	z.SetCount(4);
	for(int i=0;i<4;i++)
	{
		z[i].SetCount(4);
		for(int j=0;j<4;j++)
		{
			z[i][j] = d[min(nX-1,max(0,(x+i-1)))][min(nY-1,max(0,(y+j-1)))];	
		}
	}
	
	pt.x -= ptOffset.x + x*resx;
	pt.y -= ptOffset.y + y*resy;
	
	return BiCubic(pt,resx,resy,z);
}


double CUtils::BiCubic(Pointf pt,double resx,double resy,d2Array& z)
{
// taken from What's the point? Interpolation and extrapolation with a regular grid DEM
//	David Kidner1, Mark Dorey1 & Derek Smith2
//	University of Glamorgan
//	1School of Computing
//	2Division of Mathematics & Computing
//	Pontypridd, Rhondda Cynon Taff
//	WALES, U.K. CF37 1DL 
// found at http://www.geovista.psu.edu/sites/geocomp99/Gc99/082/gc_082.htm
	
	const double x = pt.x/resx;
	const double y = pt.y/resy;
	
	// four corner values
	double zz[4];
	zz[0] = z[1][1];
	zz[1] = z[2][1];
	zz[2] = z[2][2];
	zz[3] = z[1][2];

	const double res2x = 2.0*resx; // saves 3 *
	const double res2y = 2.0*resy; // saves 3 *

	// x derivatives using central differences
	double zdx[4];
	zdx[0] = (z[2][1]-z[0][1])/(res2x);
	zdx[1] = (z[3][1]-z[1][1])/(res2x);
	zdx[2] = (z[2][2]-z[0][2])/(res2x);
	zdx[3] = (z[3][2]-z[1][2])/(res2x);
		
	// y derivatives
	double zdy[4];
	zdy[0] = (z[1][2]-z[1][0])/(res2y);
	zdy[1] = (z[2][2]-z[2][0])/(res2y);
	zdy[2] = (z[2][3]-z[2][1])/(res2y);
	zdy[3] = (z[1][3]-z[1][1])/(res2y);
	
	// xy derivatives
	double zdxy[4];
//	zdxy[0] = 0.0;
//	zdxy[1] = 0.0;
//	zdxy[2] = 0.0;
//	zdxy[3] = 0.0;
	zdxy[0] = (z[2][2]-z[2][0]-z[0][2]+z[0][0])/(res2x*res2y);//1,1
	zdxy[1] = (z[3][2]-z[3][0]-z[1][2]+z[1][0])/(res2x*res2y);//2,1
	zdxy[2] = (z[3][3]-z[3][1]-z[1][3]+z[1][1])/(res2x*res2y);//2,2
	zdxy[3] = (z[2][3]-z[0][1]-z[0][3]+z[0][1])/(res2x*res2y);//1,2
	
	return 0;//BiCubic(zz,zdx,zdy,zdxy,resx,resy,pt); // had to delete NMRC code - looking for alternative
}

// this function returns a height correction based on the idea that the earth is a perfect 
// sphere and that the input rectangle includes our entire area of interest
// it effectively transforms a flat coordinate space (rectangle) into one on which the centre of the
// rectangle bulges outwards. However, we assume that the centre of the rectangle is correct and 
// that as we move away from it, our terrain elevation begins to dip down by the return value 
//
// we use the equatorial radius of 6,378,200m rather than the slightly less conservative
// polar mean radius of 6,356,750m 
//
// also, we assume that for the distances we are interested in, a vertical pole in the flat
// coordinate system is still very well approximated by a vertical pole in the curved system
// as a 40km distant vertical pole will appear (from the side and referenced to the centre) to
// be leaning by a mere 0.23 degrees so we can ignore this. (100km => 0.57deg)
/*
float CUtils::COE(Rectf rc,Pointf pt)
{
	// get angle between centre and pt
	Pointf ptC((rc.right+rc.left)/2.0,(rc.top+rc.bottom)/2.0);
	float dist = (float)sqrt((pt.x-ptC.x)*(pt.x-ptC.x)+(pt.y-ptC.y)*(pt.y-ptC.y));
	float A = dist/EARTH_RADIUS; // angle in radians	
	// right angled triangle with angle A at the core
	// adjacent = EARTH_RADIUS
	// hypotenuse = EARTH_RADIUS + length we are interested in
	// 
	return (float)(-EARTH_RADIUS*(1.0-cos(A)));
}
*/
// faster
double CUtils::COE(Rectf rc,Pointf pt)
{
	// get angle between centre and pt
	Pointf ptC((rc.right+rc.left)/2.0,(rc.top+rc.bottom)/2.0);
//	double dist2 = (sqr(pt.x-ptC.x)+sqr(pt.y-ptC.y));
//	double A = dist2/EARTH_RADIUS_SQUARED; // angle in radians	
	// right angled triangle with angle A at the core
	// adjacent = EARTH_RADIUS
	// hypotenuse = EARTH_RADIUS + length we are interested in
	// 

	double dist = Distance(pt,ptC);
	double A = dist/EARTH_RADIUS; // angle in radians	

	return (-EARTH_RADIUS*(1.0-cos(A)));
}

void CUtils::GetABK(String MapDatum,double& a, double& b, double& k)
{
	if(MapDatum.Find("WGS")>=0 && MapDatum.Find("84")>=0) 
	{
		a = 6378137.0;
		b = 6356752.31424518;
		k = 0.9996;
	}
	else if(MapDatum.Find("NAD")>=0 && MapDatum.Find("83")>=0) 
	{
		a = 6378137.0;
		b = 6356752.31414036;
		k = 0.9996;
	}
	else if(MapDatum.Find("NAD")>=0 && MapDatum.Find("27")>=0) 
	{
		a = 6378206.4; // approx
		b = 6356583.8; // approx
		k = 0.9996;
	}
	else if(MapDatum.Find("OSGB")>=0 && MapDatum.Find("36")>=0)
	{
		a = 6378206.4; // approx
		b = 6356583.8; // approx
		k = 0.9996012717;
	}
	// add more here
	else
	{
		// WGS84 is the default
		a = 6378137.0;
		b = 6356752.31424518;
		k = 0.9996;
	}
}

int CUtils::GetZoneUTM(Pointf ptGeo)
{
	double Longitude = ptGeo.x;
	
	int N1 = (int)(31.0 + Longitude/6.0); // zone number
	
	return N1;	
}
/*
Pointf CUtils::GeographicToUTM(Pointf ptGeo,String MapDatum)
{
	return GeographicToUTM(ptGeo,GetZoneUTM(ptGeo),MapDatum);
}

Pointf CUtils::GeographicToUTM(Pointf ptGeo,void* pMain,String MapDatum)
{
	OpenWind* ptr = (OpenWind*)pMain;

	if(ptr->IsZoneSet())
		return GeographicToUTM(ptGeo,ptr->GetZoneUTM());
	else
	{
		ptr->SetZoneUTM(GetZoneUTM(ptGeo));
		ptr->SetNorth(ptGeo.y>=0.0);
		return GeographicToUTM(ptGeo);
	}
}
*/
double CUtils::GetCentralMeridian(int zone)
{
	return 6*(zone-31)+3;
}

// taken from http://www.uwgb.edu/dutchs/UsefulData/UTMFormulas.htm by Steve Dutch, University of Wisconsin
Pointf CUtils::GeographicToUTM(Pointf ptGeo,int N1,String MapDatum)
{
	double a,b,S,Q,AD,A1,N,B1,C1,D1,e1,k,nu,e,Sin1,P,O,esq,K1,K2,K3,K4,K5;//,N1;
	
	Pointf ptUtm;

	double Latitude = ptGeo.y;
	double Longitude = ptGeo.x;
	
	GetABK(MapDatum,a,b,k);    
		
	N = (a - b) / (a + b);

	A1 = a * (1.0 - N + (5.0*N*N/4.0)*(1.0-N) + (81.0*N*N*N*N/64.0)*(1.0-N));
	B1 = (3.0*a*N/2.0) * (1.0 - N + (7.0*N*N/8.0)*(1.0-N) + (55.0*N*N*N*N/64.0)*(1.0-N));
	C1 = (15.0*a*N*N/16.0) * (1.0 - N + (3.0*N*N/4.0)*(1.0-N));
	D1 = (35.0*a*N*N*N/48.0) * (1.0 - N + (11.0*N*N/16.0)*(1.0-N));
	e1 = (315.0*a*N*N*N*N/51.0) * (1.0 - N);

	Q = Latitude * PI / 180.0; 																	// lat in radians
	S = A1 * Q - B1 * sin(2.0 * Q) + C1 * sin(4.0 * Q) - D1 * sin(6.0 * Q) + e1 * sin(8.0 * Q); // S
	K1 = S * k; 																				
	e = sqrt(1.0 - ((b*b) / (a*a)));															// e
	nu = a / sqrt(1.0 - (e*e * pow(sin(Q),2.0)));												// nu
	Sin1 = PI / (180.0 * 3600.0);																// Sin1
	K2 = nu * sin(Q) * cos(Q) * Sin1*Sin1 * k * 100000000.0 / 2.0;								
//	N1 = (int)(31.0 + Longitude/6.0); // zone number
	O = 6.0 * N1 - 183.0;
	P = (Longitude - O) * 3600.0 / 10000.0;
	esq = e * e / (1.0 - e*e);																	// ei2
	K3 = ((Sin1*Sin1*Sin1*Sin1*nu*sin(Q) * pow(cos(Q),3.0))/24.0) * (5.0 - pow(tan(Q),2.0) + 9.0 * esq * pow(cos(Q),2.0) + 4.0*esq*esq * pow(cos(Q),4.0)) * k * 1E16;
	AD = K1 + K2*P*P + K3*P*P*P*P;
	
	if(AD < 0.0)
		ptUtm.y = AD + 10000000.0;
	else
		ptUtm.y = AD;	

	K4 = nu * cos(Q) * Sin1 * k * 10000.0;
	K5 = pow(Sin1 * cos(Q),3.0) * (nu/6.0) * (1.0 - pow(tan(Q),2.0) + esq * pow(cos(Q),2.0)) * k * (1000000000000.0);
	ptUtm.x = 500000.0 + (K4*P + K5*P*P*P);

	return ptUtm;
}

Rectf CUtils::UTMtoGeographicMax(Rectf rcUtm, int ZoneNum, bool bSouth,String MapDescription)
{
	Rectf rcGeo(ABOVE_RANGE,-ABOVE_RANGE,-ABOVE_RANGE,ABOVE_RANGE);
	
	Pointf ptG,ptU;
	
	ptU = rcUtm.BottomLeft();
	
	ptG = UTMtoGeographic(ptU,ZoneNum,bSouth,MapDescription);
	
	rcGeo.left = rcGeo.right = ptG.x;
	rcGeo.bottom = rcGeo.top = ptG.y;
	
	ptU = rcUtm.BottomRight();
	
	ptG = UTMtoGeographic(ptU,ZoneNum,bSouth,MapDescription);

	rcGeo.left = min(rcGeo.left,ptG.x);
	rcGeo.right = max(rcGeo.right,ptG.x);
	rcGeo.bottom = min(rcGeo.bottom,ptG.y);
	rcGeo.top = max(rcGeo.top,ptG.y);

	ptU = rcUtm.TopRight();
	
	ptG = UTMtoGeographic(ptU,ZoneNum,bSouth,MapDescription);

	rcGeo.left = min(rcGeo.left,ptG.x);
	rcGeo.right = max(rcGeo.right,ptG.x);
	rcGeo.bottom = min(rcGeo.bottom,ptG.y);
	rcGeo.top = max(rcGeo.top,ptG.y);

	ptU = rcUtm.TopLeft();
	
	ptG = UTMtoGeographic(ptU,ZoneNum,bSouth,MapDescription);

	rcGeo.left = min(rcGeo.left,ptG.x);
	rcGeo.right = max(rcGeo.right,ptG.x);
	rcGeo.bottom = min(rcGeo.bottom,ptG.y);
	rcGeo.top = max(rcGeo.top,ptG.y);

	return rcGeo;
}

// taken from http://www.uwgb.edu/dutchs/UsefulData/UTMFormulas.htm by Steve Dutch, University of Wisconsin
Pointf CUtils::UTMtoGeographic(Pointf ptUtm, int ZoneNum, bool bSouth,String MapDescription)
{
	if(bSouth)
	{
		ptUtm.y = 10000000.0 - ptUtm.y;		
	}
	
	double Northing = ptUtm.y;
	double Easting = ptUtm.x;
	
	Pointf ptGeo;
	
	// lots of variables
	double k;                       // k = scaling factor
	double a,b,e,ei,eisq,RawLat,FootprintLat,mu,ArcLength;
	double J1,J2,J3,J4,D,EastPrime;
	double N1,Q1,R1,Q2,Q3,T1,C1,Q4,ZoneCM,DeltaLong,Q5,Q6,Q7;
	
	GetABK(MapDescription,a,b,k);    
	
	e = sqrt(1.0 - ((b*b)/(a*a)));
	ei = (1.0 - sqrt(1.0-e*e)) / (1.0 + sqrt(1.0 - e * e));
	eisq = (e*e)/ (1.0-e*e);
	ArcLength = Northing / k;
	mu = ArcLength / (a * (1.0 - e*e/4.0 - 3.0*e*e*e*e/64.0 - 5.0*e*e*e*e*e*e/256.0));
	J1 = 3.0*ei/2.0 - 27.0*ei*ei*ei/32.0;
	J2 = 21.0*ei*ei/16.0 - 55.0*ei*ei*ei*ei/32.0;
	J3 = 151.0*ei*ei*ei/96.0;
	J4 = 1097.0*ei*ei*ei*ei/512.0;
	FootprintLat = mu + J1 * sin(2.0*mu) + J2 * sin(4.0*mu) + J3 * sin(6.0*mu) + J4 * sin(8.0*mu);
	EastPrime = 500000.0 - Easting;
	N1 = a / sqrt(1.0 - pow(e * sin(FootprintLat),2.0));
	R1 = a * (1.0 - e*e) / pow(1.0 - pow(e * sin(FootprintLat),2.0),1.5);
	Q1 = N1 * tan(FootprintLat) / R1;
	D = EastPrime / (N1 * k);
	Q2 = D * D / 2.0;
	T1 = pow(tan(FootprintLat),2.0);
	C1 = eisq * pow(cos(FootprintLat),2.0);
	Q3 = (5.0 + 3.0*T1 + 10.0*C1 - 4.0*C1*C1 - 9.0*eisq)*D*D*D*D/24.0;
	Q4 = (61.0 + 90.0*T1 + 298.0*C1 + 45.0*T1*T1 - 252.0*eisq - 3.0*C1*C1) * D*D*D*D*D*D/720.0;
	RawLat = 180.0 * (FootprintLat - Q1 * (Q2 + Q3 + Q4)) / PI;
	if(!bSouth) //(NS = "N") Then
		ptGeo.y = RawLat;
	else
		ptGeo.y = RawLat * -1.0;
	
	Q5 = D;
	Q6 = (1.0 + 2.0*T1 + C1) * D*D*D/6.0;
	Q7 = (5.0 - 2.0*C1 + 28.0*T1 - 3.0*C1*C1 + 8.0*eisq + 24.0*T1*T1) * D*D*D*D*D / 120.0;
	DeltaLong = (Q5 - Q6 + Q7) / cos(FootprintLat);
	
	ZoneCM = 6.0 * (double)ZoneNum - 183.0;
	ptGeo.x = ZoneCM - DeltaLong * 180.0 / PI;
		
	return ptGeo;
}

bool CUtils::MPRectfInMPRectf(Rectf& rcInner,Rectf& rcOuter)
{
	if(rcInner.left<rcOuter.left)return false;	
	if(rcInner.right>rcOuter.right)return false;	
	if(rcInner.top>rcOuter.top)return false;	
	if(rcInner.bottom<rcOuter.bottom)return false;	

	return true;	
}
/*
Pointf GeographicToUKtm(Pointf ptGeo,String MapDatum=String("OSGB36"))
{
	
	
	
	
	
}

Pointf UKtmToGeographic(Pointf ptUKtm,String MapDatum=String("OSGB36"))
{
	
	
	
	
	
}
*/

bool CUtils::Intersects(const Rectf& rc1,const Rectf& rc2)
{
	if(rc1.left>rc2.right
	|| rc1.right<rc2.left
	|| rc1.top<rc2.bottom
	|| rc1.bottom>rc2.top)
		return false;
	
	return true;
}

bool CUtils::Intersects(const Rect& rc1,const Rect& rc2)
{
	if(rc1.left>rc2.right
	|| rc1.right<rc2.left
	|| rc1.top>rc2.bottom
	|| rc1.bottom<rc2.top)
		return false;
	
	return true;
}

void CUtils::SerializeMultiLineString(Stream& s,String& ss)
{
	char* pBuf;

	if(s.IsStoring())
	{
		int n = ss.GetLength()+1;
		s % n;
		
		pBuf = (char*)~ss;
		pBuf[n-1] = 0;
		
		s.Put(pBuf,n);
	}
	else // IsLoading
	{
		int n;
		s % n;
		
		pBuf = new char[n];
		
		s.Get(pBuf,n);

		ss = Format("%s\0",pBuf);

//		if(ss.Find('\r')>=0)
//			ss.Trim(ss.Find('\r'));
//		if(ss.Find('\n')>=0)
//			ss.Trim(ss.Find('\n'));
	
		delete[] pBuf;
	}		
}

void CUtils::SerializeString(Stream& s,String& ss)
{
	char* pBuf;

	if(s.IsStoring())
	{
		int n = ss.GetLength()+1;
		s % n;
		
		pBuf = (char*)~ss;
		pBuf[n-1] = 0;
		
		s.Put(pBuf,n);
	}
	else // IsLoading
	{
		int n;
		s % n;
		
		pBuf = new char[n];
		
		s.Get(pBuf,n);

		ss = Format("%s\0",pBuf);

		if(ss.Find('\r')>=0)
			ss.Trim(ss.Find('\r'));
		if(ss.Find('\n')>=0)
			ss.Trim(ss.Find('\n'));
	
		delete[] pBuf;
	}		
}

void CUtils::SerializeStringArray(Stream& s,StringArray& ar)
{
	int n;
	
	if(s.IsStoring())
	{
		n = ar.GetCount();
		s % n;
	}
	else // IsLoading
	{
		s % n;
		ar.SetCount(n);		
	}	

	for(int i=0;i<n;i++)
	{
		SerializeString(s,ar[i]);			
	}		
}

template<class T> void Fill(Vector<T>& a,T t)
{
	for(int i=0;i<a.GetCount();i++)
	{
		a[i] = t;	
	}
}

void CUtils::Fill(d2Array& ar,double val)
{
	for(int i=0;i<ar.GetCount();i++)
	{
		for(int j=0;j<ar[i].GetCount();j++)
		{
			ar[i][j] = val;
		}
	}	
}

Rectf CUtils::Inflate(Rectf rc,double dx,double dy)
{
	return Rectf(rc.left-dx,rc.top+dy,rc.right+dx,rc.bottom-dy);	
}

void CUtils::GrowRectToIncludePt(Rectf& rc,Pointf pt)
{
	rc.left = min(rc.left,pt.x);
	rc.right = max(rc.right,pt.x);
	rc.top = max(rc.top,pt.y);
	rc.bottom = min(rc.bottom,pt.y);	
}


/*
// its very hard to get accurate information on what atan2 does and it behaves differently in 
// different implementations (e.g. excel versus here versus wikipedia's documentation of it ) 
// and so it might even work differently across different platforms (*nix versus windows)
// use this function to find out what it is actually doing
void CUtils::Atan2Test()
{
	double x,y,angle;
	// step clockwise through one full rotation of a circle of radius 1 and dump to log file
	for(double a=0;a<=2.0*PI;a+=0.1)
	{
		x = sin(a);
		y = cos(a);
		angle = atan2(x,y);
		if(angle<0.0)
			angle+=PI*2.0;
		String s = Format("%f\t%f\t%f\t%f\t",a,x,y,angle);
		DUMP(s);
	}
}

void CUtils::ReadProjection(void* pOW,String path)
{
	OpenWind* ptr = (OpenWind*)pOW;
	
	if(ptr->IsZoneSet())
		return;

	Projection proj(path);
	
	if(!proj.IsValid())
		return;

	if(proj.GetProjection()==PRJ_UTM)
		ptr->SetZoneUTM(proj.GetZone());
	
	ptr->SetNorth(proj.IsNorth());	
	
	ptr->SetDatum(proj.GetDatum());
	ptr->SetProjectionString(proj.GetProjectionString());
	
}
*/
Projection::Projection(String path)
{
	sProjection = "Universal Transverse Mercator";
	sDatum = "WGS84";
	sSpheroid = "Geodetic_Reference_System_of_1980";
	bFeetZ = false;
	bDeg = true;
	bNorth = true;
	nZone = 0;
	proj = PRJ_UNKNOWN;
	
	bValid = false;
	FileIn file;	
	
	{
		FindFile ff;
		path = ForceExt(path,".prj");
		if(ff.Search(path))
		{
			file.Open(path);
		}

		if(!file.IsOpen())
		{
			path = ForceExt(path,".PRJ");
		
			if(ff.Search(path))
			{
				file.Open(path);
			}
		}
		
		if(!file.IsOpen())
		{
			ff.Search("*.prj");
			path = ff.GetName();
			file.Open(path);
			if(!file.IsOpen())				
				return;
		}
	}
	
	char cBuf[10000];
	String s;

	int z,n,left = int(file.GetLeft());
	file.GetAll(cBuf,left);
	String sAll(cBuf);
	n = sAll.Find("PROJCS");
	
	if(n>=0 && n<left)
	{
		// so its projected!
		int geo = sAll.Find("GEOGCS");
		
		if(sAll.Find("UTM") || (sAll.Find("Transverse") && sAll.Find("Mercator")))
		{
			proj = PRJ_UTM;				
		}
		
		z = ToUpper(sAll).Find("ZONE");
		nZone = int(atof(sAll.Mid(z+5)));
		
		bNorth = sAll[z+7]=='N' || sAll[z+8]=='N';		
	}

	z = sAll.Find("GEOGCS");
	if(z>=0)
		sDatum = CUtils::TermInQuotes(cBuf,z);
	
	file.Close();
	
	bValid = true;
}

Pointf CUtils::Rotate(double rotAngle,Pointf pt)
{
	Pointf ptOut;
	ptOut.x = pt.x*cos(rotAngle) + pt.y*sin(rotAngle);
	ptOut.y = pt.y*cos(rotAngle) - pt.x*sin(rotAngle);
	return ptOut;
}

template<class T> static void Fill(Array<T>& a,T t)
{
	int n = a.GetCount();
	
	for(int i=0;i<n;i++)
	{
		a[i] = t;	
	}	
}


