#include "WRA.h"

#include "MetData.h"

#include "GoogleMaps.h"

#define IMAGECLASS WRAImg
#define IMAGEFILE <WRA/WRA.iml>
#include <Draw/iml_source.h>

Wrap::Wrap()
{
	CtrlLayout(*this, "AWST WRA Processor");
	Icon(WRAImg::MainIcon());

	AddFrame(menu);
	AddFrame(TopSeparatorFrame());
	AddFrame(tool);

	menu.Set(THISBACK(MainMenu));
	tool.Set(THISBACK(FillToolBar));
	
	CtrlLayout(towers);
	m_tab.Add(towers.SizePos(),"Towers");
	
	CtrlLayout(step1);
	m_tab.Add(step1.SizePos(),"Step 1");
	
	CtrlLayout(step2);
	m_tab.Add(step2.SizePos(),"Step 2");
	
	CtrlLayout(step3);
	m_tab.Add(step3.SizePos(),"Step 3");

	towers.m_pMain = this;
	
	m_colFlags[0] = Color(128,255,128);
	m_colFlags[1] = Color(255,255,128);
	m_colFlags[2] = Color(128,255,255);
	m_colFlags[3] = Color(128,255,128);
	m_colFlags[4] = Color(255,128,128);
	m_colFlags[5] = Color(128,128,255);
	m_colFlags[6] = Color(50,255,50);
	m_colFlags[7] = Color(255,255,50);
	m_colFlags[8] = Color(50,255,255);
	m_colFlags[9] = Color(255,50,255);

//	towers.m_ButtonAddtower.WhenAction = THISBACK(OnAddTower);
}

void Wrap::FillToolBar(Bar& bar)
{
	bar.Add(WRAImg::Map,THISBACK(OnViewMap));
	
	
}

void Wrap::MainMenu(Bar& bar)
{
	bar.Add("File",THISBACK(SubMenuFile));
	bar.Add("View",THISBACK(SubMenuView));
	bar.Add("Settings",THISBACK(SubMenuSettings));
	
	
}

void Wrap::SubMenuFile(Bar& bar)
{
	bar.Add("Open Mast XML",THISBACK(OnOpenXML));
	bar.Add("Save Workbook",THISBACK(OnSave));
	bar.Add("Exit",THISBACK(OnExit));
	
	
}

void Wrap::SubMenuView(Bar& bar)
{
	bar.Add("Map",THISBACK(OnViewMap));
//	bar.Add("Save Workbook",THISBACK(OnSave));
//	bar.Add("Exit",THISBACK(OnExit));
	
	
}

void Wrap::OnViewMap()
{
	Pointf pt(-105,50);
	
	// start at coordinates of currently selected mast
	
	if(m_towers.GetCount())
	{
		int tab = towers.m_tab.Get();
		
		if(tab>=0 && tab<m_towers.GetCount())
		{
			pt = m_towers[tab].GetPosGeo();			
		}		
	}
	
//	MapDlg(pt);

//	Thread().Run(callback1(MapDlgAsThread,pt));
	
	m_map.Set(pt);
	
	if(!m_map.IsOpen())
		m_map.Open();


//		Thread().Run(callback(&m_map,&MapDlgDlg::Open));
}



void Wrap::SubMenuSettings(Bar& bar)
{
	bar.Add("Flag Colors",THISBACK(OnFlagColors));	
	
	
}


void Wrap::OnOpenXML()
{
	FileSel dlg;
	dlg.Type("XML files","*.xml");
	dlg.Multi();
	
	dlg.ActiveDir(GetCurrentDirectory());
	
	if(!dlg.ExecuteOpen("Open Mast File"))
		return;
	
	CUtils::SetCurrentDirectory_(dlg.GetActiveDir());

	for(int i=0;i<dlg.GetCount();i++)
	{
		OpenTowerXML(dlg.GetFile(i));		
	}
	
	UpdateTowerDefs();
}

void Wrap::OnSave()
{
	
	
	
}

void Wrap::OnExit()
{
	Break();
	
	
}

Color Wrap::GetFlagColor(int flag)
{
	flag+=990;
	flag*=-1;
	
	return m_colFlags[flag];	
}

void Wrap::OnFlagColors()
{
	FlagColorsDlg dlg;
	
	CtrlRetriever r;
	r
	(dlg.m_990,		m_colFlags[0])
	(dlg.m_991,		m_colFlags[1])
	(dlg.m_992,		m_colFlags[2])
	(dlg.m_993,		m_colFlags[3])
	(dlg.m_994,		m_colFlags[4])
	(dlg.m_995,		m_colFlags[5])
	(dlg.m_996,		m_colFlags[6])
	(dlg.m_997,		m_colFlags[7])
	(dlg.m_998,		m_colFlags[8])
	(dlg.m_999,		m_colFlags[9])
	;
	
	if(dlg.Execute()!=IDOK)
		return;
	
	r.Retrieve();	
}


void Wrap::OnAddTower()
{
	towerDefs.Add();
	CtrlLayout(towerDefs.Top());
	towers.m_tab.Add(towerDefs.Top().SizePos(),Format("Mast %04d",m_towers.Top().m_nSiteID));

	met1s.Add( Step1Tab(this,m_towers.Top().m_nSiteID));
	CtrlLayout(met1s.Top());
	step1.m_tab.Add(met1s.Top().SizePos(),Format("Mast %04d",m_towers.Top().m_nSiteID));

	met2s.Add();
	CtrlLayout(met2s.Top());
	step2.m_tab.Add(met2s.Top().SizePos(),Format("Mast %04d",m_towers.Top().m_nSiteID));

	met3s.Add();
	CtrlLayout(met3s.Top());
	step3.m_tab.Add(met3s.Top().SizePos(),Format("Mast %04d",m_towers.Top().m_nSiteID));
	
	towers.m_tab.Set(towerDefs.GetCount()-1);
	
//	UpdateTowerDefs();
}

void Wrap::UpdateLog(int iMast)
{
	towerDefs[iMast].m_grid.Clear(true);
	towerDefs[iMast].m_grid.AddColumn("Streams",100);
	int n=0;
	for(int i=0;i<m_towers[iMast].GetStreamCount();i++)
	{
		n = max(n,m_towers[iMast].GetStream(i).m_sensors.GetCount());
	}
	if(n<=0)
		return;

	for(int i=0;i<n;i++)
	{
		towerDefs[iMast].m_grid.AddColumn("Sensors",150);
	}

	for(int i=0;i<m_towers[iMast].GetStreamCount();i++)
	{
		
		String s;
		towerDefs[iMast].m_grid.Set(i*11,0,m_towers[iMast].GetStream(i).m_sName);

		s = "Sensor S/N";
		towerDefs[iMast].m_grid.Set(i*11+1,0,s);
		s = "Model";
		towerDefs[iMast].m_grid.Set(i*11+2,0,s);
		s = "Manufacturer";
		towerDefs[iMast].m_grid.Set(i*11+3,0,s);
		s = "Height";
		towerDefs[iMast].m_grid.Set(i*11+4,0,s);
		s = "Bearing";
		towerDefs[iMast].m_grid.Set(i*11+5,0,s);
		s = "Slope";
		towerDefs[iMast].m_grid.Set(i*11+6,0,s);
		s = "Offset";
		towerDefs[iMast].m_grid.Set(i*11+7,0,s);
		s = "Meaning";
		towerDefs[iMast].m_grid.Set(i*11+8,0,s);
		s = "Date Installed";
		towerDefs[iMast].m_grid.Set(i*11+9,0,s);

		for(int j=0;j<m_towers[iMast].GetStream(i).m_sensors.GetCount();j++)
		{
			towerDefs[iMast].m_grid.Set(i*11+1,j+1,m_towers[iMast].GetStream(i).m_sensors[j].m_nSerial);
			towerDefs[iMast].m_grid.Set(i*11+2,j+1,m_towers[iMast].GetStream(i).m_sensors[j].m_sModelName);
			towerDefs[iMast].m_grid.Set(i*11+3,j+1,m_towers[iMast].GetStream(i).m_sensors[j].m_sManufacturer);
			towerDefs[iMast].m_grid.Set(i*11+4,j+1,m_towers[iMast].GetStream(i).m_sensors[j].m_fHeight);
			towerDefs[iMast].m_grid.Set(i*11+5,j+1,m_towers[iMast].GetStream(i).m_sensors[j].m_fBearing);
			towerDefs[iMast].m_grid.Set(i*11+6,j+1,m_towers[iMast].GetStream(i).m_sensors[j].m_fSlope);
			towerDefs[iMast].m_grid.Set(i*11+7,j+1,m_towers[iMast].GetStream(i).m_sensors[j].m_fOffset);
			towerDefs[iMast].m_grid.Set(i*11+8,j+1,MeaningAsString(m_towers[iMast].GetStream(i).m_sensors[j].m_meaning));
			Time& time = m_towers[iMast].GetStream(i).m_sensors[j].m_date;
			towerDefs[iMast].m_grid.Set(i*11+9,j+1,Format("%04d-%02d-%02d",time.year,time.month,time.day));
			
			
		}
	}
}

String Wrap::MeaningAsString(MEANING m)
{
	switch(m)
	{
		case WS:
			return "Wind Speed";
		case DIR:
			return "Direction";
		case TEMP:
			return "Temperature";
		case VOLT:
			return "Voltage";
		case PRESS:
			return "Pressure";	
	}
	
	return "unknown";
		
}




void TowersTab::DragAndDrop(Point p, PasteClip& d)
{
	Vector<String> files;
	
	if (AcceptFiles(d)) 
	{
		files = GetFiles(d);
	}

	if(files.GetCount()<=0)
		return;
	
	Wrap* ptr = (Wrap*)m_pMain;

	for(int i=0;i<files.GetCount();i++)
	{
		ptr->OpenTowerXML(files[i]);
	}
	
	ptr->UpdateTowerDefs();
	
}

void Wrap::OpenTowerXML(String path)
{
	FileIn iFile(path);

	if(!iFile.IsOpen())
	{
		PromptOK("failed to open file");
		return;
	}
	
//	int k = int(iFile.GetSize());
	int64 k = iFile.GetLeft();
	char* pBuf = new char[k];
	if(!iFile.GetAll(pBuf,k))
	{
		iFile.Close();
		delete[] pBuf;
		return;	
	}
	
	iFile.Close();

	String xml(pBuf);
	
	XmlNode xn = ParseXML(xml);

	if(xn.IsVoid() || xn.IsEmpty())
		return;

	int c = 0;

	const XmlNode& xnMast = xn["serviceResponse"]["mast"];

	if(xnMast.IsVoid() || xnMast.IsEmpty())
		return;

	if(xnMast.GetCount())
	{
		Tower& tower = m_towers.Add();
	
		Pointf ptGeo;

		ptGeo.x = atof(xnMast["x1"][0].GetText());
		ptGeo.y = atof(xnMast["y1"][0].GetText());
		
		tower.SetPosGeo(ptGeo);

		tower.m_nProjectID = atoi(xnMast["project_id"][0].GetText());
		tower.m_nSiteID = atoi(xnMast["site_id"][0].GetText());
		tower.m_nMastID = atoi(xnMast["id"][0].GetText());
		
		tower.m_sTowerModel = xnMast["model_name"][0].GetText();
		
		int n = xnMast.GetCount();
		if(n>100)
		{
			PromptOK(Format("n=%d",n));
			return;	
		}

		for(int i=0;i<n;i++) // step through streams
		{
			if(xnMast[i].GetText().Find("stream")>=0)	
			{
				int index = tower.AddStream();
				
				Tower::MetStream& ms = tower.GetStream(index);
				
				ms.m_nMastID = atoi(xnMast[i]["mast_id"][0].GetText());
				
				ms.m_sName = xnMast[i]["name"][0].GetText();				
				
				int m = xnMast[i].GetCount();				
				if(m>100)
				{
					PromptOK(Format("m=%d",m));
					return;	
				}
				
				for(int j=0;j<m;j++) // step through mss_records
				{
					if(xnMast[i][j].GetText().Find("mss_record")>=0)	
					{
						Tower::Sensor& sensor = ms.m_sensors.Add();
						
						sensor.m_fBearing = atof(xnMast[i][j]["boom_orientation"][0].GetText());
						sensor.m_fOffset = atof(xnMast[i][j]["calibration_offset"][0].GetText());
						sensor.m_fSlope = atof(xnMast[i][j]["calibration_slope"][0].GetText());
						sensor.m_fHeight = atof(xnMast[i][j]["height"][0].GetText());
						sensor.m_nSerial = atoi(xnMast[i][j]["serial_no"][0].GetText());
						sensor.m_date = StringToTime(xnMast[i][j]["date_installed"][0].GetText());
						sensor.m_meaning = StringToMeaning(xnMast[i][j]["sensor_type_code"][0].GetText());
						sensor.m_sManufacturer = xnMast[i][j]["sensor_mfg_name"][0].GetText();
						sensor.m_sModelName = xnMast[i][j]["sensor_model_name"][0].GetText();
						
					}
				}
			}
		}		
	}
	else
	{
		PromptOK("This does not appear to be a valid mast XML configuration");	
		delete[] pBuf;	
		return;
	}
	
	delete[] pBuf;	

	OnAddTower();
	UpdateTowerDefs();
	
//	Sleep(1000);
}

Time Wrap::StringToTime(String s)//,int& gmt)
{
	Time time;

	if(s.Find("/")>=0)
	{
		int m = atoi(s);
		int c = s.Find("/");
		int d = atoi(~s+ ++c);
		c = s.Find("/",c);
		int y = atoi(~s+ ++c);
		
		int h = atoi(~s+c+4);

		c = s.Find(":",c+4);

		int mm = atoi(~s+ ++c);

		return Time(y,m,d,h,mm,0);
	}
	else
	{
		int y = atoi(s);
		int m = atoi(~s+5);
		int d = atoi(~s+8);
		int h = atoi(~s+11);
		int mm = atoi(~s+14);
	
		return Time(y,m,d,h,mm,0);
	}
}

MEANING Wrap::StringToMeaning(String s)
{
	MEANING m;
	
	if(ToUpper(s).EndsWith("WS"))
		m = WS;
	else if(ToUpper(s).EndsWith("DIR"))
		m = DIR;
	else if(ToUpper(s).EndsWith("VOLT"))
		m = VOLT;
	else if(ToUpper(s).EndsWith("TEMP"))
		m = TEMP;
	else if(ToUpper(s).EndsWith("PRESS"))
		m = PRESS;

	return m;
}

void Wrap::UpdateTowerDefs()
{
	for(int i=0;i<m_towers.GetCount();i++)
	{
		UpdateTowerDef(i);
	}	
}

void Wrap::GetTowerDefs()
{
	if(towers.m_tab.GetCount()!=m_towers.GetCount())
	{
		PromptOK("Number of towers does not match in interface. Please contact support.");
		return;		
	}
	
	for(int i=0;i<m_towers.GetCount();i++)
	{
		GetTowerDef(i);	
	}
	
}

void Wrap::GetTowerDef(int i)
{
	
}

void Wrap::UpdateTowerDef(int i)
{
	towerDefs[i].m_sProject = m_towers[i].GetProject();
	towerDefs[i].m_sClient = m_towers[i].GetClient();
	towerDefs[i].m_nID = m_towers[i].GetSiteID();
	towerDefs[i].m_fEast = m_towers[i].GetPosUTM().x;
	towerDefs[i].m_fNorth = m_towers[i].GetPosUTM().y;
	towerDefs[i].m_fLat = m_towers[i].GetPosGeo().y;
	towerDefs[i].m_fLon = m_towers[i].GetPosGeo().x;
	towerDefs[i].m_sTowerModel = m_towers[i].m_sTowerModel;
	
	/////////
	
	UpdateLog(i);
}
/*
void Wrap::UpdateStep1(int n)
{
	met1s[n].m_grid.Clear();
	
	met1s[n].m_grid.AddColumn("Time Stamp",200);
		
	if(m_towers[n].GetStreamCount()<=0)
		return;

	met1s[n].m_overview.Set(&m_towers[n]);
	
	for(int i=0;i<m_towers[n].GetStreamCount();i++)
	{
		met1s[n].m_edits.Add();
		met1s[n].m_edits.Add();
		met1s[n].m_edits.Add();
		met1s[n].m_grid.AddColumn(Format("%s val",m_towers[n].GetStream(i).m_sName),100).Edit(met1s[n].m_edits[i*3]);
		met1s[n].m_grid.AddColumn(Format("%s sd",m_towers[n].GetStream(i).m_sName),100).Edit(met1s[n].m_edits[i*3+1]);
		met1s[n].m_grid.AddColumn(Format("%s flag",m_towers[n].GetStream(i).m_sName),100).Edit(met1s[n].m_edits[i*3+2]);
	}

	met1s[n].m_grid.SetCount(m_towers[n].GetStream(0).m_mean.GetCount());
	met1s[n].m_grid.Refresh();
	
	for(int j=0;j<m_towers[n].GetStream(0).m_mean.GetCount();j++)
	{
		Vector <Value> vals;
		
		vals.Add(TimeAsString(m_towers[n].m_ts[j]));

		for(int i=0;i<m_towers[n].GetStreamCount();i++)
		{
			if(i>=m_towers[n].GetStream(i).m_mean.GetCount())
			   break;
			
			vals.Add(m_towers[n].GetStream(i).m_mean[j]);
			vals.Add(m_towers[n].GetStream(i).m_sd[j]);
			vals.Add(m_towers[n].GetStream(i).m_flag[j]);			
			
			if(m_towers[n].GetStream(i).m_flag[j]<-900)
				met1s[n].m_grid.SetDisplay(j,3+i*3,met1s[n].m_disp);
		}
		
		met1s[n].m_grid.Set(j,vals);
	}



}
*/

void Wrap::UpdateStep1(int n)
{
	met1s[n].m_grid.Clear();
	
	met1s[n].m_conDate.Init(&m_towers[n]);
	
	met1s[n].m_grid.AddRowNumColumn("Time Stamp",200).SetConvert(met1s[n].m_conDate);
	
	if(m_towers[n].GetStreamCount()<=0)
		return;
	
	met1s[n].m_grid.WhenStartEdit = THISBACK1(OnStartEditStep1,n);

	met1s[n].m_overview.Set(&m_towers[n]);

	met1s[n].m_converts.SetCount(m_towers[n].GetStreamCount()*3);
	met1s[n].m_convertEdits.SetCount(m_towers[n].GetStreamCount()*3);
	
	for(int i=0;i<m_towers[n].GetStreamCount();i++)
	{
		met1s[n].m_converts[i*3].Init(&m_towers[n],i,0);
		met1s[n].m_converts[i*3+1].Init(&m_towers[n],i,1);
		met1s[n].m_converts[i*3+2].Init(&m_towers[n],i,2);
		met1s[n].m_convertEdits[i*3].Init(&m_towers[n],i,0);
		met1s[n].m_convertEdits[i*3+1].Init(&m_towers[n],i,1);
		met1s[n].m_convertEdits[i*3+2].Init(&m_towers[n],i,2);
		met1s[n].m_edits.Add().SetConvert(met1s[n].m_convertEdits[i*3]);
		met1s[n].m_edits.Add().SetConvert(met1s[n].m_convertEdits[i*3+1]);
		met1s[n].m_edits.Add().SetConvert(met1s[n].m_convertEdits[i*3+2]);
		met1s[n].m_grid.AddRowNumColumn(Format("%s val",m_towers[n].GetStream(i).m_sName),100).Edit(met1s[n].m_edits[i*3]).SetConvert(met1s[n].m_converts[i*3]);
		met1s[n].m_grid.AddRowNumColumn(Format("%s sd",m_towers[n].GetStream(i).m_sName),100).Edit(met1s[n].m_edits[i*3+1]).SetConvert(met1s[n].m_converts[i*3+1]);
		met1s[n].m_grid.AddRowNumColumn(Format("%s flag",m_towers[n].GetStream(i).m_sName),100).Edit(met1s[n].m_edits[i*3+2]).SetConvert(met1s[n].m_converts[i*3+2]);
	}

	met1s[n].m_grid.SetVirtualCount(m_towers[n].GetStream(0).m_mean.GetCount());

	for(int j=0;j<m_towers[n].GetStream(0).m_mean.GetCount();j++)
	{
		for(int i=0;i<m_towers[n].GetStreamCount();i++)
		{
			if(i>=m_towers[n].GetStream(i).m_mean.GetCount())
			   break;
			
			if(m_towers[n].GetStream(i).m_flag[j]<-900)
				met1s[n].m_grid.SetDisplay(j,3+i*3,met1s[n].m_disp);
		}		
	}
}

void Wrap::OnStartEditStep1(int n)
{
	int index = met1s[n].m_grid.GetCursor();
	
	for(int i=0;i<met1s[n].m_convertEdits.GetCount();i++)
	{
		met1s[n].m_convertEdits[i].m_nRec = index;		
	}	
}

/*
String Wrap::TimeAsString(Time date)
{
	String s = Format("%04d-%02d-%02d %02d:%02d:00",date.year,date.month,date.day,date.hour,date.minute);
	
	return s;
}
*/


int Wrap::SiteToIndex(int nSiteID)
{
	for(int i=0;i<m_towers.GetCount();i++)	
	{
		if(nSiteID==m_towers[i].m_nSiteID)
			return i;	
	}
	return -1;
}

int Wrap::MastToIndex(int nMastID)
{
	for(int i=0;i<m_towers.GetCount();i++)	
	{
		if(nMastID==m_towers[i].m_nSiteID)
			return i;	
	}
	return -1;
}


void Wrap::OpenTabDelimited(String path,int nMastID)
{
	if(!ToUpper(path).EndsWith(".TXT"))
	{
		PromptOK("Please use a tab-delimited text file with the '.txt' extension.");
		return;
	}
	
	FileIn fi(path);
	
	if(!fi.IsOpen())
	{
		PromptOK(Format("Failed to open %s for reading. Please drop a tab-delimited text file.",path));
		return;		
	}
	
	int towerIndex = MastToIndex(nMastID);
	Tower& tower = m_towers[towerIndex];
	tower.ClearMetData();
		
	// process header
	String line = fi.GetLine();
	int c = line.Find("\t",0); // first field is always time stamp
	int index, nStream = 0; // first
	do
	{
		String s = ~line+c+1;
		
		c = line.Find("\t",c+1);
		
		if(c<0)
		{
			index = tower.GetStreamIndex(s);	
			
			if(index!=nStream)
				tower.CrossTheStreams(nStream,index);
			break;
		}
		
		s.Trim(s.Find("\t"));
		
		index = tower.GetStreamIndex(s);	
		
		if(index!=nStream/3)
			tower.CrossTheStreams(nStream/3,index);
		
		nStream++;
		
	}while(c<line.GetLength() && c>0);
	
	// load data
	do
	{
		line = fi.GetLine();
		
		nStream = 0;
		int c = line.Find(",",0);
		tower.m_ts.Add(StringToTime(line));
		do
		{
			String s = ~line+c+1;//
			
			c = line.Find("\t",c+1);
			
			if(c<0)
			{

				break;
			}		
			
			s.Trim(s.Find("\t"));
			
			double val = atof(s);
			
			tower.GetStream(nStream/3).AddValue(nStream%3,val);			
			
			nStream++;
			
		}while(c<line.GetLength() && c>0);
		
	}while(!fi.IsEof());
	
	fi.Close();

	UpdateStep1(towerIndex);
}

void Wrap::OpenCSV(String path,int nMastID)
{
	if(!ToUpper(path).EndsWith(".CSV"))
	{
		PromptOK("Please use a comma-delimited text file with the '.csv' extension.");
		return;
	}
	
	char sep = ',';
		
	FileIn fi(path);
	
	if(!fi.IsOpen())
	{
		PromptOK(Format("Failed to open %s for reading. Please drop a comma-delimited text file.",path));
		return;		
	}
	
	int64 len = fi.GetLeft();
	Buffer<char> pBuf;
	pBuf.Alloc(len+1);
	if(!fi.GetAll(pBuf,len))
		return;

//	PromptOK("read from disk - about to parse");


	pBuf[len] = 0;

	String buf(pBuf);
	StringStream ss(buf);


	int towerIndex = MastToIndex(nMastID);
	Tower& tower = m_towers[towerIndex];
	tower.ClearMetData();
		
	// process header
	String line = ss.GetLine();
	int c = line.Find(",",0); // first field is always time stamp
	int index, nStream = 0; // first
	do
	{
		String s = ~line+c+1;
		
		c = line.Find(",",c+1);
		
		if(c<0)
		{
			index = tower.GetStreamIndex(s);	
			
			if(index!=nStream)
				tower.CrossTheStreams(nStream/3,index);
			break;
		}
		
		s.Trim(s.Find(","));
		
		index = tower.GetStreamIndex(s);	
		
		if(index!=nStream/3)
			tower.CrossTheStreams(nStream/3,index);
		
		nStream++;
		
	}while(c<line.GetLength() && c>0);
	
	// load data
	do
	{
		line = ss.GetLine();
		
		nStream = 0;
		int c = line.Find(",",0);
		tower.m_ts.Add(StringToTime(line));
		do
		{
			String s = ~line+c+1;//
			
			c = line.Find(",",c+1);
			
			if(c<0)
			{
				double val = atof(s);
				
				tower.GetStream(nStream/3).AddValue(nStream%3,val);			

				break;
			}		
			
			s.Trim(s.Find(","));
			
			double val = atof(s);
			
			tower.GetStream(nStream/3).AddValue(nStream%3,val);			
			
			nStream++;
			
		}while(c<line.GetLength() && c>0);
		
	}while(!ss.IsEof());
	
	fi.Close();

//	PromptOK("finished parsing");

	UpdateStep1(towerIndex);
}

void Wrap::Step122()
{
	// average and adjust the data
	// go stream by stream and try to find partners
	
	
//	for(int i
	
	
	
	
	
	
	
	
}

void Step1Tab::DragAndDrop(Point p, PasteClip& d)
{
	Vector<String> files;
	
	if (AcceptFiles(d)) 
	{
		files = GetFiles(d);
	}

	if(files.GetCount()<=0)
		return;
	
	Wrap* ptr = (Wrap*)m_pMain;

	if(ToUpper(files[0]).EndsWith("TXT"))
		return ptr->OpenTabDelimited(files[0],m_nSiteID);
	
	if(ToUpper(files[0]).EndsWith("CSV"))
		return ptr->OpenCSV(files[0],m_nSiteID);
	
	if(files.GetCount()>1)
	{
		PromptOK("This interface can only take one file at a time. Please select the next mast and paste it's data directly into it's grid.");
		return;				
	}
	
}

void Step1Tab::OnScroll()
{
	m_overview.Refresh();
	
	
	
}

void Step1Tab::OnNextFlag()
{
	Tower& tower = *(Tower*)m_overview.m_pTower;

	int i=m_grid.GetCursor()+1;
	
	if(i>=m_grid.GetCount())
		return;
	
	for(   ;i<m_grid.GetCount();i++)
	{
		bool b = false;
		for(int j=0;j<m_overview.m_flags.GetCols();j++)
		{
			if(m_overview.m_flags[j][i]<-900)
			{
				b = true;
				break;
			}	
		}
		
		if(b)
		{
			m_grid.SetCursor(i);
			m_grid.CenterCursor();
			return;
		}
	}
	
	m_grid.SetCursor(i-1);
}

void Step1Tab::OnLastFlag()
{
	Tower& tower = *(Tower*)m_overview.m_pTower;

	int i=m_grid.GetCursor()-1;
	
	if(i<0)
		return;	
	
	for(   ;i<m_grid.GetCount();i--)
	{
		bool b = false;
		for(int j=0;j<m_overview.m_flags.GetCols();j++)
		{
			if(m_overview.m_flags[j][i]<-900)
			{
				b = true;
				break;
			}	
		}
		
		if(b)
		{
			m_grid.SetCursor(i);
			m_grid.CenterCursor();
			return;
		}
	}
	
	m_grid.SetCursor(0);
}

void Step1Tab::Step122()
{
	Wrap* ptr = (Wrap*)m_pMain;
	
	ptr->Step122();	
}

void Overview::Set(void* pT)
{
	m_pTower = pT;
	
	Tower& tower = *(Tower*)m_pTower;
	
	m_flags.Dimension(tower.GetStreamCount(),tower.GetRecordCount(),0);	
	
	for(int i=0;i<tower.GetRecordCount();i++)
	{
		for(int j=0;j<tower.GetStreamCount();j++)
		{
			if(tower.GetStream(j).m_flag.GetCount()>j && tower.GetStream(j).m_flag[i]<-900)
			{
				m_flags[j][i] = tower.GetStream(j).m_flag[i];
			}
		}
	}
		
}

void Overview::Paint(Draw& w)
{
	if(!m_pTower)
		return;
	
	
	Size sz = GetSize();
	
	ImageDraw buf(sz);
	buf.DrawRect(sz,White);
	
	Tower& tower = *(Tower*)m_pTower;
		
	double scaleX = sz.cx/double(tower.GetStreamCount());
	double scaleY = sz.cy/double(tower.GetRecordCount());
	
	Wrap* ptr = (Wrap*)m_pMain;
	
	for(int i=0;i<tower.GetRecordCount();i++)
	{
		for(int j=0;j<tower.GetStreamCount();j++)
		{
			if(m_flags[j][i]<-900)
			{
				Rect rc;
				
				rc.left = j*scaleX;
				rc.right = (j+0.5)*scaleX;
				rc.top = i*scaleY;
				rc.bottom = rc.top+1;				
				
				Color col = ptr->GetFlagColor(m_flags[j][i]);
				
				buf.DrawRect(rc,col);
			}
		}
	}

	int n = ((Step1Tab*)GetParent())->m_grid.GetCursor();

	buf.DrawLine(0,n*scaleY,sz.cx,n*scaleY,0,Black);
		
	w.DrawImage(0,0,buf);
}

void Overview::MouseMove(Point pos, dword flags)
{
	if(!m_pTower)
		return;

//	m_nOffset = 0;

	Size sz = GetSize();
	
	Tower& tower = *(Tower*)m_pTower;
		
	int n = (pos.y*tower.GetRecordCount())/sz.cy;
	
	String s = TimeAsString(tower.GetTime(n));

	((Step1Tab*)GetParent())->m_sDateTime.SetData(s);	
	
	m_nRec = n;
	
	m_popZ.Refresh();
	
}

void Overview::LeftDown(Point p, dword keyflags)
{
	if(!m_pTower)
		return;

	Size sz = GetSize();
	
	Tower& tower = *(Tower*)m_pTower;
	
	int n = (p.y*tower.GetRecordCount())/sz.cy+m_nOffset;
	
	Wrap* ptr = (Wrap*)m_pMain;
	
	Step1Tab* pParent = ((Step1Tab*)GetParent());
	
	pParent->m_grid.SetCursor(n);
	pParent->m_grid.CenterCursor();
	
	Refresh();

}

void Overview::MouseEnter(Point p,dword keyflags)
{
	if(!m_pTower)
		return;

	Rect rc = GetScreenRect();

	int width = rc.Width();

	m_popZ.m_pOverview = this;

	m_popZ.SetRect(rc);
	m_popZ.Open();
	
	SetCapture();
	SetFocus();
	
	m_nOffset=0;
	
}

void Overview::MouseLeave()
{
	m_popZ.Close();	
	
	m_nOffset=0;
	
	ReleaseCapture();
}

void Overview::MouseWheel(Point p, int zdelta, dword keyflags)
{
	m_nOffset -= zdelta/abs(zdelta)*2;
	
	m_popZ.Refresh();
}




void PopupZoom::Paint(Draw& w)
{
	Size sz = GetSize();	
	
	// so just take however many records around the current mouse position
	
	ImageDraw buf(sz);
	buf.DrawRect(sz,White);
	
	Overview* pO = (Overview*)m_pOverview;
	
	if(pO->m_pTower==NULL)
		return;

	Tower& tower = *(Tower*)pO->m_pTower;
		
	double scaleX = sz.cx/double(tower.GetStreamCount());
	
	Wrap* ptr = (Wrap*)pO->m_pMain;

	int n = pO->GetMouseMoveRecord();
	
	int iStart = max(0,n-sz.cy/2);
	
	for(int i=iStart,k=0;i<min(tower.GetRecordCount(),n+sz.cy/2);i++,k++)
	{
		for(int j=0;j<tower.GetStreamCount();j++)
		{
			if(pO->m_flags[j][i]<-900)
			{
				Rect rc;
				
				rc.left = j*scaleX;
				rc.right = (j+0.5)*scaleX;
				rc.top = k;
				rc.bottom = rc.top+1;				
				
				Color col = ptr->GetFlagColor(pO->m_flags[j][i]);
				
				buf.DrawRect(rc,col);
			}
		}
	}


	Step1Tab* pParent = ((Step1Tab*)pO->GetParent());
	int win = pParent->m_grid.GetSize().cy/pParent->m_grid.GetLineCy();
	win/=2;
	
	buf.DrawLine(0,sz.cy/2-win,sz.cx,sz.cy/2-win,0,Black);
	buf.DrawLine(0,sz.cy/2,sz.cx,sz.cy/2,0,LtGray);
	buf.DrawLine(0,sz.cy/2+win,sz.cx,sz.cy/2+win,0,Black);

	w.DrawImage(0,0,buf);	
}





void FlagDisplay::PaintBackground(Draw& w,const Rect& r,const Value& q,Color ink,Color paper,dword style) const
{
	Color col = paper;

	if(int(q)<-900)
	{
		Wrap* ptr = (Wrap*)m_pMain;
		col = ptr->GetFlagColor(int(q));			
	}

	w.DrawRect(r,col);		
}


GUI_APP_MAIN
{
	Wrap().Zoomable().Sizeable().Run();
}
