#ifndef _CtrlLibTest_DialSlider_h_
#define _CtrlLibTest_DialSlider_h_

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#define IMAGECLASS DSImg
#define IMAGEFILE <DialSlider/DialSlider.iml>
#include <Draw/iml_header.h>

class DialSlider : public Ctrl
{
public:
	struct Style : ChStyle<Style> {
		Image frame;
		Image mask;
		Image pos;
		Image marker;
		Font font;
	};
		
public:
	typedef DialSlider CLASSNAME;
	
	DialSlider();

	virtual void 	LeftDown(Point p, dword keyflags);
	virtual void 	LeftUp(Point p, dword keyflags);
	virtual void 	MouseMove(Point p, dword keyflags);
	virtual void	Paint(Draw &w);

	DialSlider &	Min(int _min)			{ MinMax(_min, max); return *this; }
	DialSlider &	Max(int _max)			{ MinMax(min, _max); return *this;  }
	void 		  	MinMax(int min, int max);
	void			SetPos(int pos);
	
	int				GetPos() const			{ return pos; }
	int 			GetMin() const			{ return min; }
	int 			GetMax() const			{ return max; }

	DialSlider &	Marker(bool v = true)	{ marker = v; return *this; }
	DialSlider &	NoMarker()				{ return Marker(false); }

	DialSlider &	Labels(bool v = true)	{ labels = v; return *this; }
	DialSlider &	NoLabels()				{ return Labels(false); }

	virtual void   	SetData(const Value& data);
	virtual Value  	GetData() const			{ return GetPos(); }

	void 				SetStyle(const Style &s) { style = &s; };
	static const Style &StyleDefault();
protected:
	virtual Image GetPosImage();
	virtual Image GetMarkerImage();
	virtual void  PaintLabels(Draw &w);
private:	
	Image 	posimg, markerimg;
	int 	min, max, pos;
	bool 	marker, labels;
	const 	Style *style;

	bool	PointInSlider(Point p);
	int		ClientToSlider(Point p);
	Size	GetImageSize();
	void 	UpdateSync();
	int 	GetAngle() const;
};

#endif
