#ifndef _GraphCtrl_SeriesConfig_h_
#define _GraphCtrl_SeriesConfig_h_

#include <ScatterDraw/SeriesPlot.h>
#include <ScatterDraw/MarkPlot.h>
#include <DataSource/DataSource.h>

namespace GraphDraw_ns
{

	template <class COORDCONVERTER, class SERIESPLOT=SeriesPlot, class MARKPLOT=MarkPlot>
	class SeriesConfigBase {
		public:
			bool sequential;

			One<SERIESPLOT> seriesPlot;
			double thickness;
			Color color;
			String dash;

			One<MARKPLOT> markPlot;
			double markWidth;
			Color markColor;
			Color fillColor;

			String legend;

			double opacity;
			int id;
			bool trendLine;

			COORDCONVERTER* xConverter;
			COORDCONVERTER* yConverter;

			SeriesConfigBase()
			{
				color = Null;
				thickness = 3;
				legend = "";
				opacity = 1;
				sequential = false;
				dash = LINE_SOLID;
				seriesPlot;// = new LineSeriesPlot();
				markPlot;  // = new CircleMarkPlot();
				markWidth = 8;
				markColor = Null;
				fillColor = Null;
				xConverter = 0;
				yConverter = 0;
			}

			void Init(int id)
			{
				color = GetNewColor(id);
				markColor = Color(max(color.GetR()-30, 0), max(color.GetG()-30, 0), max(color.GetB()-30, 0));
				//dash = GetNewDash(id);
			}
	};

	template <class COORDCONVERTER, class SERIESPLOT=SeriesPlot, class MARKPLOT=MarkPlot>
	class SeriesConfig : public Moveable< SeriesConfig<COORDCONVERTER, SERIESPLOT, MARKPLOT> >, public SeriesConfigBase<COORDCONVERTER, SERIESPLOT, MARKPLOT> {
		public:
		SeriesConfig()	{pD = 0;}
		void SetDataSource(DataSource *pointsData, bool ownsData = true) {pD = pointsData; owns = ownsData;}
		inline DataSource *PointsData()	{return pD;}
		~SeriesConfig()	{if(pD && owns) delete pD;}

		private:
		DataSource *pD;
		bool owns;
	};
};
#endif
