


//#define TRACE_INFO(TXT) { std::ostringstream str; str <<  "\n" << TXT; LOG(str.str().c_str()); }
#define TRACE_INFO(TXT) std::cout <<  "\n" << TXT << std::flush

#include "GraphDraw_test.h"


using namespace GraphDraw_ns;




	template<class COORDCONVERTER>
	class ExclusionAreaDraw : public CRTPGraphElementFrame< ExclusionAreaDraw<COORDCONVERTER> >
	{
		private:
		COORDCONVERTER& _xConverter;
		COORDCONVERTER& _yConverter;
		typedef  CRTPGraphElementFrame< ExclusionAreaDraw<COORDCONVERTER> > _B;

		public:
		typedef ExclusionAreaDraw<COORDCONVERTER>   CLASSNAME;
		ExclusionAreaDraw(COORDCONVERTER& xConv, COORDCONVERTER& yConv) :  _yConverter(yConv), _xConverter(xConv){};
		~ExclusionAreaDraw() {};

		virtual CLASSNAME* Clone() { return new CLASSNAME(_xConverter, _yConverter); }


		virtual void PaintElement(Draw& dw, int scale) { /* do noting */}
		virtual void PaintOnPlot(Draw& dw, int otherWidth, int scale)
		{
			int xMin = _xConverter.getScreenMin();
			int xMax = _xConverter.getScreenMax();
			int yMin = _yConverter.getScreenMin();
			int yMax = _yConverter.getScreenMax();
			int zXMin = _xConverter.toScreen(5);
			int zXMax = _xConverter.toScreen(7);
			int zYMin = _yConverter.toScreen(4);
			int zYMax = _yConverter.toScreen(8);


			Vector<Point> zone1;
			Vector<Point> zone2;
			zone1 << Point(xMin, zYMin) << Point(zXMin, zYMin) << Point(zXMin, yMax) << Point(xMin, yMax);
			zone2 << Point(xMax, zYMax) << Point(zXMax, zYMax) << Point(zXMax, yMin) << Point(xMax, yMin);
			dw.DrawPolygon(zone1, Color(148, 235, 242), 2, Black());
			dw.DrawPolygon(zone2, Color(250, 150, 150), 2, Black());
		}
	};

GraphDraw_test::GraphDraw_test()
{
	
	typedef GraphDrawTypes< double, Upp::int32, DataSource, SeriesPlot, MarkPlot > MyGraphTypes;

	CtrlLayout(*this, "Window title");

	points << Pointf(0,0) << Pointf(1, 3.5)<< Pointf(2,1.8)<< Pointf(4, 3)<< Pointf(5.5, 2.5);
	points << Pointf(6,7) << Pointf(7, 9)<< Pointf(8,10)<< Pointf(10, 15)<< Pointf(15, 15);


	g1.AddSeries(points);
	g2.AddSeries(points);
	g3.AddSeries(points);
	g4.AddSeries(points);

	g1.GetSeriesConfig(0).seriesPlot = new StaggeredSeriesPlot();
	g1.CloneRightElement( 20, g1.GetYGridAxisDraw());
	g1.setGraphSize(0,20,0,20);
	

	g2.GetSeriesConfig(0).markPlot = new XMarkPlot();
	g2.setGraphSize(0,20,0,20);
	g2.GetYCoordConverter().SetConvLog();


	g3.GetXCoordConverter().SetConvLog();
	g3.GetYCoordConverter().SetConvLog();
	g3.CloneTopElement( 20, g3.GetXGridAxisDraw());
	g3.GetSeriesConfig(0).markPlot = new TriangleMarkPlot();
	g3.setGraphSize(1,20,1,20);


	g4.CloneTopElement( 20, g4.GetXGridAxisDraw() );
	g4.CloneRightElement( 40, g4.GetYGridAxisDraw() );
	g4.CreateElement<ExclusionAreaDraw<MyGraphTypes::CoordConverter>, OVER_GRAPH>(0, g4.GetXCoordConverter(), g4.GetYCoordConverter() );
	g4.CreateElement<MyGraphTypes::LabelElement, TOP_OF_GRAPH>( 50 )
			.SetLabel("This is the title")
			.SetFont(StdFont().Bold().Underline().Height(30))
			.SetTextColor(Green());
	g4.CreateElement<MyGraphTypes::LabelElement, LEFT_OF_GRAPH>( 18 ).SetLabel("Y axis").SetFont(StdFont().Bold().Underline()).SetTextColor(Green());;
	g4.CreateElement<MyGraphTypes::LabelElement, BOTTOM_OF_GRAPH>( 18 ).SetLabel("X axis").SetFont(StdFont().Bold().Underline()).SetTextColor(Green());;
	g4.GetSeriesConfig(0).seriesPlot = new LineSeriesPlot();
	g4.GetSeriesConfig(0).markPlot = new XMarkPlot();
	g4.setGraphSize(0,20,0,20);
	g4.GetYGridAxisDraw().setMajorTickMark( (new LineTickMark())->SetTickLength( 10 ) );

}


using namespace GraphDraw_ns;



GUI_APP_MAIN
{
	TRACE_INFO("STARTING application");
	One<GraphDraw_test> app = new GraphDraw_test();
	app->Sizeable().Run();
	TRACE_INFO("ENDING application");
}
