#ifndef _GraphCtrl_GrapCtrl_h
#define _GraphCtrl_GrapCtrl_h

#include <GraphDraw/GraphDraw.h>

using namespace Upp;


namespace GraphCtrl_ns
{
	typedef GraphDraw_ns::StdGraphDraw< DataSource > TypeGDraw;
	typedef GraphDraw_ns::GridAxisDraw<TypeGDraw::TypeCoordConverter> TypeGAxisDraw;
	typedef GraphDraw_ns::LabelElement<TypeGDraw::TypeCoordConverter> TypeLabelElement;
	typedef GraphDraw_ns::RichLabelElement<TypeGDraw::TypeCoordConverter> TypeRichLabelElement;
	typedef GraphDraw_ns::GridStepManager<TypeGDraw::TypeCoordConverter> TypeGridStepManager;

	void OpenGridAxisPropertiesCtrl( GraphDraw_ns::GridAxisDraw<GraphDraw_ns::StdGraphDraw< DataSource >::TypeCoordConverter>* v);
};


// ============================
//    GraphCtrlBase   CLASS
// ============================
template<class DATASOURCE,
		class SERIESPLOT,
		class MARKPLOT,
		class COORDCONVERTER,
		class GRAPHDRAW = GraphDraw_ns::EmptyGraphDraw< DATASOURCE, SERIESPLOT, MARKPLOT, COORDCONVERTER> >
class GraphCtrlBase : public GRAPHDRAW, public Ctrl
{
	public:
	typedef GraphCtrlBase<DATASOURCE, SERIESPLOT, MARKPLOT, COORDCONVERTER> CLASSNAME;

	private:
	typedef GRAPHDRAW _GD;

	public:
	GraphCtrlBase() {
		setScreenSize( GetSize() );
	}

	virtual void Refresh() {
		Ctrl::Refresh();
	};

	virtual void   Paint(Draw& w) {
		setScreenSize( GetSize() );
		_GD::Paint(w, 1);
	}

	virtual void LeftDouble(Point p, dword keyflags)
	{
		
		TRACE_INFO("GraphCtrlBase::LeftDouble(" << p.x << ", " << p.y << ")");
		for (int j = 0; j < _GD::_overElements.GetCount(); j++)
		{
			if (_GD::_overElements[j]->Contains(p)) {
				TRACE_INFO("IN OVER(" << p.x << ", " << p.y << ")");
				_GD::_overElements[j]->WhenLeftDouble(_GD::_overElements[j]);
				return;
			}
		}
		for (int j = 0; j < _GD::_leftElements.GetCount(); j++)
		{
			if (_GD::_leftElements[j]->Contains(p)) {
				TRACE_INFO("IN LEFT(" << p.x << ", " << p.y << ")");
				_GD::_leftElements[j]->WhenLeftDouble(_GD::_leftElements[j]);
				return;
			}
		}

		for (int j = 0; j < _GD::_bottomElements.GetCount(); j++)
		{
			if (_GD::_bottomElements[j]->Contains(p)) {
				TRACE_INFO("IN BOTTOM(" << p.x << ", " << p.y << ")");
				_GD::_bottomElements[j]->WhenLeftDouble(_GD::_bottomElements[j]);
				return;
			}
		}

		for (int j = 0; j < _GD::_rightElements.GetCount(); j++)
		{
			if (_GD::_rightElements[j]->Contains(p)) {
				TRACE_INFO("IN RIGHT(" << p.x << ", " << p.y << ")");
				_GD::_rightElements[j]->WhenLeftDouble(_GD::_rightElements[j]);
				return;
			}
		}

		for (int j = 0; j < _GD::_topElements.GetCount(); j++)
		{
			if (_GD::_topElements[j]->Contains(p)) {
				TRACE_INFO("IN TOP(" << p.x << ", " << p.y << ")");
				_GD::_topElements[j]->WhenLeftDouble(_GD::_topElements[j]);
				return;
			}
		}

		_GD::updateSizes();

		Refresh();
	}

};


template<class DATASOURCE, class SERIESPLOT=SeriesPlot, class MARKPLOT=MarkPlot, class COORDCONVERTER = GraphDraw_ns::GenericCoordinateConverter<Upp::int32, double> >
class StdGraphCtrl :	public GraphCtrlBase< DATASOURCE,
	                                        SERIESPLOT,
	                                        MARKPLOT,
	                                        COORDCONVERTER,
	                                        GraphDraw_ns::StdGraphDraw< DATASOURCE, SERIESPLOT, MARKPLOT, COORDCONVERTER> >
{
	public:
	typedef StdGraphCtrl<DATASOURCE, SERIESPLOT, MARKPLOT, COORDCONVERTER> CLASSNAME;
	typedef GraphCtrlBase< DATASOURCE,
                          SERIESPLOT,
                          MARKPLOT,
                          COORDCONVERTER,
                          GraphDraw_ns::StdGraphDraw< DATASOURCE, SERIESPLOT, MARKPLOT, COORDCONVERTER> > _B;

	private:
	void OpenGridAxisProperties(GraphDraw_ns::GraphElementFrame* v)
	{
		typedef GraphDraw_ns::StdGraphDraw< DataSource > TypeGDraw;
		typedef GraphDraw_ns::GridAxisDraw<TypeGDraw::TypeCoordConverter> TypeGAxisDraw;
		GraphCtrl_ns::OpenGridAxisPropertiesCtrl( dynamic_cast<TypeGAxisDraw*>(v) );
	}


	public:
	StdGraphCtrl() {
		_B::setScreenSize( Ctrl::GetSize() );
		_B::_xGridDraw.WhenLeftDown << THISBACK(OpenGridAxisProperties);
		_B::_yGridDraw.WhenLeftDown << THISBACK(OpenGridAxisProperties);
		_B::_xGridDraw.WhenLeftDouble << THISBACK(OpenGridAxisProperties);
		_B::_yGridDraw.WhenLeftDouble << THISBACK(OpenGridAxisProperties);
	}
};





#endif
