#include "GraphCtrl.h"


#define LAYOUTFILE <GraphCtrl/GraphCtrl.lay>
#include <CtrlCore/lay.h>




namespace GraphCtrl_ns
{
	void OpenGridAxisPropertiesCtrl( GraphDraw_ns::GridAxisDraw<GraphDraw_ns::StdGraphDraw< DataSource >::TypeCoordConverter>* v)
	{
		typedef GraphDraw_ns::StdGraphDraw< DataSource >::TypeCoordConverter TypeCoordConverter;

		TypeCoordConverter& converter = v->GetCoordConverter();
		CtrlRetriever r;
		double gMin = converter.getGraphMin();
		double gMax = converter.getGraphMax();

		WithGridAxisPropertiesLayout<TopWindow> dlg;
		r ( dlg.axisLineColor, v->_axisColor)
		  ( dlg.axisTextcolor, v->_axisTextColor)
		  ( dlg.gridColor, v->_gridColor)
		  ( dlg.min, gMin)
		  ( dlg.max, gMax)
		  ;
		CtrlLayoutOKCancel(dlg, "");

		if ( dlg.Execute() == IDOK ){
			r.Retrieve();
			converter.updateGraphSize(gMin, gMax);
		}
	}




};




