#include <Core/Core.h>

using namespace Upp;

CONSOLE_APP_MAIN
{
	const Vector<String>& cmdLine = CommandLine();

	if (cmdLine.GetCount() == 0) {
		Cout() << "Specify XML file to load\n";
		return;
	}

	String fileName(NormalizePath(cmdLine[0]));

	XmlNode node;
	{
		// Loading contents of file to String
		const String data = LoadFile(fileName);
		if (data.IsVoid()) {
			Cerr() << "Error, while loading '" << NormalizePath(fileName) << "' file\n";
			SetExitCode(1);
			return;
		}
	
		try { // Trying to parse XML data
			node = ParseXML(data);
		}
		catch (XmlError e) {
			Cerr() << "XmlError: " << e << '\n';
			SetExitCode(1);
			return;
		}
	}

	const XmlNode& linput = node["Xml"]["InputDataInformation"];
	if (linput.IsVoid()) {
		Cerr() << "There is no Xml/InputDataInformation tag\n";
		SetExitCode(1);
		return;
	}

	const String outputPath = "output";
	if (!DirectoryExists(outputPath))
		if (!RealizeDirectory(outputPath)) {
			Cerr() << "Error while creating '" << outputPath << "' directory\n";
			SetExitCode(1);
			return;
		}

	for (int i = 0, n = linput.GetCount(); i < n; ++i) {
		const XmlNode& linfo = linput[i];
		if (!linfo.IsTag("Information"))
			continue;

		const XmlNode& lname = linfo["Name"];
		if (linfo.IsVoid())
			continue;

		const String name = lname[0].GetText();
		if (name.IsEmpty()) {
			Cerr() << "Empty name for " << i << " tag\n";
			continue;
		}

		const String outputFile = AppendFileName(outputPath, name + ".xml");
		if (!SaveFile(outputFile, AsXML(linfo, XML_HEADER))) {
			Cerr() << "Error, while saving '" << outputFile << "' file\n";
			SetExitCode(1);
			return;
		}
	}
}
