#include "../DiscountTerminal.h"

#define IMAGECLASS TabCtrlEqImg
#define IMAGEFILE <DiscountTerminal/TabCtrlEq/TabCtrlEq.iml>
#include <Draw/iml_source.h>
#include "../MainWindow.h"
extern MainWindow* mw;
//TabCtrlEq::Style  ts = TabCtrl::StyleDefault();
#define FONT StdFont(PLACECFG.modebuttonfontsize/mw->FONTDIVIDER).Bold() 
void TabCtrlEq::SetDefStyle(){
	static TabCtrlEq::Style  ts = TabCtrl::StyleDefault();
	ts.font = FONT;
	ts.body = TabCtrlEqImg::Body();
	ts.normal[0] = TabCtrlEqImg::BackTab();
	ts.normal[1] = TabCtrlEqImg::BackTab();
	ts.normal[2] = TabCtrlEqImg::SelTab();
	ts.normal[3] = TabCtrlEqImg::BackTab();
	ts.first[0] = TabCtrlEqImg::BackTab();
	ts.first[1] = TabCtrlEqImg::BackTab();
	ts.first[2] = TabCtrlEqImg::SelTab();
	ts.first[3] = TabCtrlEqImg::BackTab();
	ts.last[0] = TabCtrlEqImg::BackTab();
	ts.last[1] = TabCtrlEqImg::BackTab();
	ts.last[2] = TabCtrlEqImg::SelTab();
	ts.last[3] = TabCtrlEqImg::BackTab();
	ts.sel = Rect(0, 0, 0, 2);
	ts.edge = Rect(100, 1000, 100, 100);
	ts.tabheight = 85/mw->FONTDIVIDER;
	ts.margin = 14/mw->FONTDIVIDER;
	ts.text_color[0] = Color(146,146,146);
	ts.text_color[1] = Color(146,146,146);
	ts.text_color[2] = White();
	ts.text_color[3] = Color(146,146,146);
	SetStyle(ts);
	
}

void TabCtrlEq::AdjustSize(){
	if (GetSize().cx == 0) return;
	Size chsz = GetTextSize("M", FONT);
	int n = GetCount();
	if (n==0) n = 1;
	SetTabSize((GetSize().cx - (14/mw->FONTDIVIDER*2) - 38/mw->FONTDIVIDER*n - chsz.cx*n)/n);
	RefreshLayoutDeep();
}


void TabCtrlEq::Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword s) const {
	w.DrawRect(GetSize(),Color(26,26,27));
}
void TabCtrlEq::VCenterDisplay::Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword s) const {
	
	String text,image;
	
	Font fnt = FONT;
	//Font fnt = ts.font;
	
	Size chsz = GetTextSize("M", fnt);
	if(IsString(q))
		text = q;
	else
		text = StdFormat(q);
	
	Vector<String> rs = Split(text,"#");
	if (rs.GetCount() >1) {
		text = rs[0];
		image = rs[1];
	} else {
		image = "";
	}
	int space = 20/mw->FONTDIVIDER;		
	
	Image img;
	if (image == "medved") 
		img = TabCtrlEqImg::Medved();
	else if (image == "map") 
		img = TabCtrlEqImg::Map();
	else if (image == "info") 
		img = TabCtrlEqImg::Info();
	
	Size img_sz = img.GetSize();
	Size tsz = GetSmartTextSize(text, fnt);
	
	Rescale(img,Size(img_sz.cx/mw->FONTDIVIDER,img_sz.cy/mw->FONTDIVIDER));
	img_sz = img.GetSize();
	
	//w.DrawImage(r.left,r.top,r.Width()+chsz.cx,r.Height(),TabCtrlEqImg::sqr);
	if (!img.IsEmpty()) {
		w.DrawImage(r.left + (r.Width()+chsz.cx - tsz.cx - space - img_sz.cx) / 2 , r.top + (r.Height() - img_sz.cy) / 2, img,ink);
		w.DrawText(r.left + (r.Width()+chsz.cx - tsz.cx - space - img_sz.cx) / 2 + space + img_sz.cx , r.top + (r.Height() - tsz.cy) / 2, text, fnt, ink);
	} else {
		w.DrawText(r.left + (r.Width()+chsz.cx - tsz.cx) / 2 , r.top + (r.Height() - tsz.cy) / 2, text, fnt, ink);
	}
	
	
}

void TabCtrlEq::AddLabel(String text){
	
	Value v;
	TabCtrl::Item& t = Add();
	t.Picture(PaintRect(Single<VCenterDisplay>(),text));
	
	
}