#ifndef _TestTabCtrl_TestTabSV_h_
#define _TestTabCtrl_TestTabSV_h_
#include <CtrlLib/CtrlLib.h>

#include "../DiscountTerminal.h"
using namespace Upp;

#define IMAGECLASS TabCtrlEqImg
#define IMAGEFILE <DiscountTerminal/TabCtrlEq/TabCtrlEq.iml>
#include <Draw/iml_header.h>



class TabCtrlEq : public TabCtrl {
	typedef TabCtrlEq CLASSNAME;
public:
	int tabsize;
	void SetTabSize(int n) {tabsize = n; Single<VCenterDisplay>().SetTabSize(n);}
	void AdjustSize();
	void AdjustSize(int n) { SetTabSize(n); AdjustSize(); }
	
	void AddLabel(String text);
	void SetDefStyle();
	void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword s) const ;
	class VCenterDisplay : public Display
	{
	public:
		void SetTabSize(int n) {tabsize = n; }
		int tabsize;
		
		Font font;
		
		void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword s) const ;
		virtual Size GetStdSize(const Value& q) const {                                                                                                                                 
			return Size(tabsize,50);
		}
	
	};
	
};

#endif
