


//#define TRACE_INFO(TXT) { std::ostringstream str; str <<  "\n" << TXT; LOG(str.str().c_str()); }
#define TRACE_INFO(TXT) std::cout <<  "\n" << TXT << std::flush


#include "GraphDraw_test.h"


using namespace GraphDraw_ns;




template<class TYPES>
class ExclusionAreaDraw : public CRTPGraphElementFrame< ExclusionAreaDraw<TYPES> >
{
	private:
	typename TYPES::TypeCoordConverter& _xConverter;
	typename TYPES::TypeCoordConverter& _yConverter;
	typedef  CRTPGraphElementFrame< ExclusionAreaDraw<TYPES> > _B;

	public:
	typedef ExclusionAreaDraw<TYPES>   CLASSNAME;
	ExclusionAreaDraw(typename TYPES::TypeCoordConverter& xConv, typename TYPES::TypeCoordConverter& yConv) :  _yConverter(yConv), _xConverter(xConv){};
	~ExclusionAreaDraw() {};

	virtual CLASSNAME* Clone() { return new CLASSNAME(_xConverter, _yConverter); }


	virtual void PaintElement(Draw& dw, int scale) { /* do noting */}
	virtual void PaintOnPlot(Draw& dw, int otherWidth, int scale)
	{
		int xMin = _xConverter.getScreenMin();
		int xMax = _xConverter.getScreenMax();
		int yMin = _yConverter.getScreenMin();
		int yMax = _yConverter.getScreenMax();
		int zXMin = _xConverter.toScreen(5);
		int zXMax = _xConverter.toScreen(7);
		int zYMin = _yConverter.toScreen(4);
		int zYMax = _yConverter.toScreen(8);


		Vector<Point> zone1;
		Vector<Point> zone2;
		zone1 << Point(xMin, zYMin) << Point(zXMin, zYMin) << Point(zXMin, yMax) << Point(xMin, yMax);
		zone2 << Point(xMax, zYMax) << Point(zXMax, zYMax) << Point(zXMax, yMin) << Point(xMax, yMin);
		dw.DrawPolygon(zone1, Color(148, 235, 242), 2, Black());
		dw.DrawPolygon(zone2, Color(250, 150, 150), 2, Black());
	}
};

GraphDraw_test::GraphDraw_test()
{
	
	CtrlLayout(*this, "Window title");

	points << Pointf(0,0) << Pointf(1, 3.5)<< Pointf(2,1.8)<< Pointf(4, 3)<< Pointf(5.5, 2.5);
	points << Pointf(6,7) << Pointf(7, 9)<< Pointf(8,10)<< Pointf(10, 15)<< Pointf(15, 15);

	points2 << Pointf(0,0) << Pointf(1, 2)<< Pointf(2,3)<< Pointf(4, 3)<< Pointf(5.5, 4);
	points2 << Pointf(6,5) << Pointf(7, 6)<< Pointf(8,10)<< Pointf(10, 9)<< Pointf(15, 8);


	g1.AddSeries(points);
	g4.AddSeries(points);

	g1.GetSeriesConfig(0).seriesPlot = new StaggeredSeriesPlot();
	g1.CloneRightElement( 20, g1.GetYGridAxisDraw());
	g1.setGraphSize(0,20,0,20);
	g1.SetMode( GraphDraw_ns::MD_DRAW );
	

//	g2.GetSeriesConfig(0).markPlot = new XMarkPlot();
//	g2.setGraphSize(0,20,1,20);
//	g2.GetYCoordConverter().SetConvLog();
//	g2.SetMode( GraphDraw_ns::MD_ANTIALIASED );



	for (int t = 0; t < 100000; ++t) {
		s1 <<Pointf(t,20*sin(2*M_PI*t/100000));
	}
	g3.AddSeries(s1);
//	g3.GetXCoordConverter();//.SetConvLog();
//	g3.GetYCoordConverter();//.SetConvLog();
	g3.CloneTopElement( 20, g3.GetXGridAxisDraw());
	g3.GetSeriesConfig(0).markPlot;// = new TriangleMarkPlot();
	g3.GetSeriesConfig(0).seriesPlot = new LineSeriesPlot();
	g3.setGraphSize(0, 100000, -22, +22);
	g3.SetMode( GraphDraw_ns::MD_NOAA);
	g3.CreateElement<GraphDraw_ns::LabelElement, TOP_OF_GRAPH>( 30 )
			.SetLabel("BIG DATA SET")
			.SetFont(StdFont().Bold().Underline().Height(20))
			.SetTextColor(Green());
	g3.CreateElement<GraphDraw_ns::BlankAreaElement, RIGHT_OF_GRAPH>( 15 );


	g4.CloneTopElement( 20, g4.GetXGridAxisDraw() );
	g4.CreateElement<ExclusionAreaDraw<MyGraphCtrl::Types>, OVER_GRAPH>(0, g4.GetXCoordConverter(), g4.GetYCoordConverter() );
	g4.CreateElement<GraphDraw_ns::LabelElement, TOP_OF_GRAPH>( 50 )
			.SetLabel("This is the title")
			.SetFont(StdFont().Bold().Underline().Height(30))
			.SetTextColor(Green());
	g4.CreateElement<GraphDraw_ns::LabelElement, LEFT_OF_GRAPH>( 18 ).SetLabel("Y axis").SetFont(StdFont().Bold().Underline()).SetTextColor(Green());
	g4.CreateElement<GraphDraw_ns::LabelElement, BOTTOM_OF_GRAPH>( 18 ).SetLabel("X axis").SetFont(StdFont().Bold().Underline()).SetTextColor(Green());
	g4.GetSeriesConfig(0).seriesPlot = new LineSeriesPlot();
	g4.GetSeriesConfig(0).markPlot = new XMarkPlot();
	g4.setGraphSize(0,20,0,20);
	g4.GetYGridAxisDraw().setMajorTickMark( (new LineTickMark())->SetTickLength( 5 ) );

	//g4.CloneRightElement( 40, g4.GetYGridAxisDraw() );
	// ADD Y2 AXIS
	y2CoordConverter.updateGraphSize(0, 20);
	g4.AddYConverter(y2CoordConverter);
	g4.CreateElement<MyGraphCtrl::Types::TypeGridAxisDraw, RIGHT_OF_GRAPH>( 35, y2CoordConverter ).setGridColor(Null).setMajorTickMark((new GraphDraw_ns::TriangleTickMark())->SetTickLength( 8 ));
	g4.CreateElement<GraphDraw_ns::LabelElement, RIGHT_OF_GRAPH>( 18 ).SetLabel("Y2 AXIS").SetFont(StdFont().Bold().Underline()).SetTextColor(Green());

	g4.AddSeries(points2); // tied to last X/Y  coordConverters ==> X / Y2
	g4.GetSeriesConfig(1).seriesPlot = new LineSeriesPlot();
	g4.SetMode( GraphDraw_ns::MD_SUBPIXEL );


}


using namespace GraphDraw_ns;



GUI_APP_MAIN
{
	TRACE_INFO("STARTING application");
	One<GraphDraw_test> app = new GraphDraw_test();
	app->Sizeable().Run();
	TRACE_INFO("ENDING application");
}
