#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <Resize2/ResizeLayout.lay>
#include <CtrlCore/lay.h>

struct MyAppBase :WithResizeLayout<TopWindow>
{
	MyAppBase()
	{
		
		CtrlLayout(*this, "Proportionate Resizable Window");
		
	}
};

struct MyApp: MyAppBase
{
	MyApp()
	{
		Rect_<float> pi;
		Size sz=GetSize();
		for(Ctrl* c=GetFirstChild(); c!=NULL; c=c->GetNext())
		{
			Rect r=c->GetRect();
			pi.left=(float)r.left/sz.cx;
			pi.top=(float)r.top/sz.cy;
			pi.right=(float)r.right/sz.cx;
			pi.bottom=(float)r.bottom/sz.cy;
			posinfo.Add(c, pi );
		}
	}
	virtual void Layout()
	{
		static bool inLayout; // to guard against re-entrance
		if(inLayout)
			return;
		inLayout=true;
		Size sz=GetSize();
		for(Ctrl* c=GetFirstChild(); c!=NULL; c=c->GetNext())
		{
			Rect_<float>& pi=posinfo.Get(c);
			c->SetRect((int)(sz.cx*pi.left), (int)(sz.cy*pi.top), 
						(int)(sz.cx*pi.Width()), (int)(sz.cy*pi.Height()));
		}
		
		
		
		inLayout=false;
	}
	
	VectorMap<Ctrl*, Rect_<float>> posinfo;
};

GUI_APP_MAIN
{
	MyApp().Sizeable().Run();
}
