#include "iostream"
#include "iomanip"
#include "math.h"
#include "box_calc.h"
#include "Sheet2D.h"
#include "My_OGL_Obj_Lib.h"

using namespace std;

/***************************************************
            TO DO LIST
****************************************************
1. Write the Calculus program
1.5 Write a normalizing function for (x)
2. Draw the Cube with one face open taking 'x' as param
3. Draw the 2D sheet with x squares.
4. Draw the 2D graph
5. for now ignore the GUI component and assume we r 
   getting the values from GUI. based on that make 
   the program work.

*****************************************************/

/***************************************************
        CALCULUS - PROGRAM
****************************************************/


bool Calculate_Maxima_Minima(const float& L, const float& W, float *maxima, float *minima){

        // v = (L-2x) * (W-2x) * x;
        //   = LWx - 2Lx^2 - 2Wx^2 + 4x^3     
        // dv/dx = LW - 4Lx - 4Wx + 12x^2;                      
        // = 12x^2 + (-(4*L) -(4*W))x + LW
        // ax^2+bx+c
        // a=12
        // b=(-(4*L) -(4*W))
        // c=LW
                        
    if (L<=0||W<=0) return false;
    
    float a=12, b=(-4.0f * (L+W)), c=L*W;
    float D=0.0f;
    
    D=sqrt((b*b)-(4.0f * a * c));

//  if (a=0){retun false;} // it cant happen in this equation
    b=(b*-1.0);    
    if(D==0){
       *minima = *maxima = b /(2*a); 
    }else if(D>0){
       *maxima = (b + D)/(2*a);
       *minima = (b - D)/(2*a);
    }

    //cout<<"X_Maxima="<<*maxima<<" X_Minima="<<*minima<<" a="<<a<<" b="<<b<<" c= "<<c<<" D= "<<D<<endl;

    return true;
}


float Calculate_Volume(const float& x, const float& L, const float& W){
	// FOR DEBUGGING ONLY
	//cout<<"x,L,W="<<x<<","<<L<<","<<W<<endl;
	
	// Saving CPU Clcok Cycle secrificing a Float Memory
	float x2=x*2.0f;
	if(x<=0 || x2>L || x2>W){
		 return 0.0f;
	}else{
		return (L-x2)*(W-x2)*x;
	}
}


const GLfloat* Graph_Array::Generate(int number_of_vertices, float length, float width){
	// For number_of_vertices <10 is not produced.
	if(number_of_vertices<10){ return NULL; }
	
	int tmp_var=number_of_vertices*2;
	
	// If an array already exist
	if(graph_array!=NULL||Array_Size>0){
		// If the existing array size is different from the new array size
		// then delete the existing array and create a new array
		if(Array_Size!=tmp_var){ 
			delete[] graph_array;
			Array_Size=tmp_var;
			graph_array=new GLfloat[Array_Size];
			for(int i=0; i<Array_Size; i++){graph_array[i]=0.1f;}
		}
		// Else if the existing array and new array size same, no need to 
		// delete the array. just reuse it.
	
	}else{
		// else if there are no existing array, then create one.
		Array_Size=tmp_var;
		graph_array=new GLfloat[Array_Size];
		for(int i=0; i<Array_Size; i++){graph_array[i]=0.1f;}
	}
	

	// create the necessory temporary veriables
    float x_max=0.0f, x_min=0.0f;
    float v_max=0.0f, v_min=0.0f;
    float x_low=0.0f, x_high=0.0f;
    float increment=0.0f, temp_x=0.0f;	
	coordinate_translator ctx, ctv;
	int i=0,i_limit=0; // veriables for 'for loops'
	
	Calculate_Maxima_Minima(length, width, &x_max, &x_min); 
    v_max=Calculate_Volume(x_min, length, width);
	v_min=x_low=0.0f;	
	x_high=x_max;
	
	// initializing coordinate translator for x and v axis
	ctx.recalculate(x_high, x_low, 1.0f, -1.0f);
 	ctv.recalculate(v_max, v_min, 1.0f, -1.0f);	
	
	// Setting the first and the last x and v
 	// all the other elements will be set using for loop
	graph_array[0]=ctx.translate(x_low);
	graph_array[1]=ctv.translate(Calculate_Volume(x_low,length,width));
	graph_array[Array_Size-2]=ctx.translate(x_high);
	graph_array[Array_Size-1]=ctv.translate(Calculate_Volume(x_high,length,width));
	
	if(number_of_vertices%2==0){
		tmp_var=number_of_vertices-1; //(number_of_vertices-2) + 1
	}else{
		tmp_var=number_of_vertices-2;		
	}
	
	graph_array[tmp_var-1]=ctx.translate(x_min);
	graph_array[tmp_var]=ctv.translate(Calculate_Volume(x_min,length,width));	
	
	increment=(x_min-x_low)/(tmp_var/2);
	temp_x=x_low;
	i_limit=(tmp_var-2);
    for(i=2; i<i_limit; i+=2){
        temp_x=temp_x+increment; 
		graph_array[i]=ctx.translate(temp_x);
		graph_array[i+1]=ctv.translate(Calculate_Volume(temp_x,length,width));
    }
    
	increment=(x_max-x_min-3)/((tmp_var)/2);
	temp_x=x_min;
	i_limit=(Array_Size-3);

    for(i=tmp_var+1; i<i_limit; i+=2){
        temp_x=temp_x+increment; 
		graph_array[i]=ctx.translate(temp_x);
		graph_array[i+1]=ctv.translate(Calculate_Volume(temp_x,length,width));
    }
    


		
}





/*	
	// Array Size = Number of Vertices * 2, as each 2D Vertices has (x,y)
	const int Array_Size=40;
	
	float graph_array[Array_Size]={0};
	
    float x_max=0.0f, x_min=0.0f;
    float v_max=0.0f, v_min=0.0f;
    float x_low=0.0f, x_high=0.0f, v_max1=0.0f, v_min1=0.0f;
    float length=60.0f, width=60.0f, increment=0.0f, temp_x=0.0f;
    
    
    
	Calculate_Maxima_Minima(length, width, &x_max, &x_min); 
    v_max=Calculate_Volume(x_min, length, width);
	v_min=0.0f;
	
	x_low=0.0f;
	x_high=x_max;
	
	// FOR DEBUGGING ONLY
	cout<<"v_max="<<v_max<<" v_min="<<v_min<<" x_max="<<x_max<<" x_min="<<x_min<<" x_high="<<x_high<<" x_low="<<x_low<<endl;
	
	// initializing coordinate translator for x and v axis
	ctx.recalculate(x_high, x_low, 1.0f, 0.0f);
 	ctv.recalculate(v_max, v_min, 1.0f, 0.0f);
 	



 	increment=(x_high-x_low)/(Array_Size/2);
 	temp_x=x_low;
 	
    for(int i=2, i_limit=(Array_Size-2); i<i_limit; i+=2){
        temp_x=temp_x+increment; 
		graph_array[i]=ctx.translate(temp_x);
		graph_array[i+1]=ctv.translate(Calculate_Volume(temp_x,length,width));
    }
    

	Graph_Array a;
	const GLfloat* graph_array;
	
	a.Generate(10, 60, 60);
	graph_array=a.get_vertices_array();
	
	// FOR DEBUGGING ONLY
	setfill(" ");
	for(int i=0; i<a.Array_Length(); i+=2){
		cout<<"graph_array ["<<i<<"]="<<setw(10)<<graph_array[i]
			<<", ["<<i+1<<"]="<<setw(1)<<graph_array[i+1]
			//<<", ["<<i+2<<"]="<<graph_array[i+2]
			<<endl;	
	}
*/


int mainc(){    
	GLfloat a[12]={0.0f}; // array to contain v0-v4 where each v has (x,y,z)
	vertices v;
	GLfloat n=11.0f;
	
	// by setting the array, i'm telling the object which array to work with
	v.Set_Array(a);
	
	v[0].Set3D_xyz(1.0f,2.0f,3.0f);
	
	v[1].Set_x(5.0f).Set_y(4.0f).Set_z(3.0f);
	/*
		above is same as writing the follwoing
		v[2].Set_x(5.0f);
		v[2].Set_y(4.0f);
		v[2].Set_z(3.0f);	
		since all Set_x,Set_y,Set_z function return a referance to the 'v' object using '*this'
		it is possible to daise chain the function all in above manner.
		also note that object v is not an array yet by overloading the operator []
		i've manage to make a interface so that i can simple pass the vertices number
		and the object figures out which elemnt of the array 'a' to access.
	*/
	
	v[2].Set_x(v[1].Get_x());
	
	v[2].Set_y(-1.0f).Set_z(-1.0f);
	
	v[3]=v[1].Get_Vertices();
	v[3]=v[1];
	/*
		i have overload the '=' operetor to make a copy interface. 
		above line tell the object to copy the x,y,z of vertices '1' 
		into vertices '3'
	*/
	

	/* notice thia i have left the v[0] unchanged, just to show that all the element of 'a' array were set to 0.0f */
	/* out put of the resulting array */	 
 	cout<<endl;
	for(int i=0; i<12; i++){
		cout<<"a["<<i<<"]="<<a[i]<<endl;	
	}
	cout<<endl;
	 return 0;

}
