#ifndef _MySecondGL_coordinate_translator_h_
#define _MySecondGL_coordinate_translator_h_
class coordinate_translator{
	public:
		coordinate_translator(){
			range_c=range_d=m_d_min=m_c_min=0.0f;
		}
		coordinate_translator(float c_max, float c_min){
			recalculate(c_max, c_min);	
		}
		float translate(float c_val){
			return m_d_min+(range_d*((c_val-m_c_min)/range_c));	
		}
		void recalculate(float c_max, float c_min, float d_max=1.0f, float d_min=-1.0f){
			range_c=c_max-c_min;
			range_d=d_max-d_min;
			m_d_min=d_min;
			m_c_min=c_min;
		}		
	private:
		float range_c;
		float range_d;
		float m_d_min;
		float m_c_min;

};
#endif
