#include <CtrlLib/CtrlLib.h>
#include <GLCtrl/GLCtrl.h>
#include "cube.h"
#include "box_calc.h"
#include "Sheet2D.h"







using namespace Upp;

class MyGL : public GLCtrl {
	public:
		MyGL(){
			
		};
		~MyGL(){
		
		}
		virtual void GLInit();
		virtual void GLPaint();
		virtual void GLDone();
		virtual void MouseMove(Point p, dword);
		void Setup_VBO();
	private:	
		// all these are initiazie in GLInt() and used in GLPaint()
		float x1,y1,z1, x2,y2,z2, rotqube; 
		cube myCube;
		Graph_Array xvGraph;
		Sheet2D objSheet2D;
};

void MyGL::Setup_VBO(){
	
}

void MyGL::GLDone(){
/*
	GLenum err = glewInit();
	if (GLEW_OK != err)
	{
	  //* Problem: glewInit failed, something is seriously wrong. 
	 // fprintf(stderr, "Error: %s\n", glewGetErrorString(err));
	 // ...
	}	
*/	
}


void MyGL::GLInit(){

	
	
	float w=700.0f, h=700.0f;

	
	glClearColor(0.85f, 0.85f, 0.85f, 0.0f);
		
    glViewport (0, 0, (GLsizei) w, (GLsizei) h);
    
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f, 700.0f / 700.0f, 1.0f, 500.0f);
	 
	//glOrtho(-10.0, 10.0, -10.0, 10.0, -10.0, 10.0);
//		glEnable(GL_DEPTH);	
//  	
  	glEnable(GL_DEPTH_TEST);
  	glDepthMask(GL_TRUE);
  	//glEnable(GL_CULL_FACE);
  	//glCullFace(GL_BACK);
  	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	
	glShadeModel(GL_SMOOTH);
	
	GLfloat mat_specular[]   = { 0.0f, 0.0f, 0.0f, 0.0f };
	GLfloat light_position[] = { 2.0f, -2.0f, 3.0f, 0.0f };
	GLfloat light_specular[] = { 0.6f, 0.6f, 0.6f, 0.0f };
	GLfloat light_ambient[]  = { 0.3f, 0.3f, 0.3f, 0.0f };
	//glClearColor (0.0, 0.0, 0.0, 0.0);
	
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
	
	glMaterialfv(GL_FRONT, GL_EMISSION, mat_specular);
	//glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);
	glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, light_specular);
	glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);
	
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	
	glEnable(GL_COLOR_MATERIAL);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	

	//glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
	
	myCube.set_coordinate(1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f);
	xvGraph.Generate(18, 60.0f, 60.0f);
	objSheet2D.Generate(60.0f, 60.0f, 10.0f);

	rotqube=0;

}























void MyGL::GLPaint(){
	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  	glLoadIdentity();
  	glTranslatef(0.0f, 0.0f, -5.00f);
	glPushMatrix();
	

	
	GLfloat colors[] = {1,1,1,  1,1,0,  1,0,0,  1,0,1,              // v0-v1-v2-v3
                    1,1,1,  1,0,1,  0,0,1,  0,1,1,              // v0-v3-v4-v5
                    1,1,1,  0,1,1,  0,1,0,  1,1,0,              // v0-v5-v6-v1
                    1,1,0,  0,1,0,  0,0,0,  1,0,0,              // v1-v6-v7-v2
                    0,0,0,  0,0,1,  1,0,1,  1,0,0,              // v7-v4-v3-v2
                    0,0,1,  0,0,0,  0,1,0,  0,1,1};             // v4-v7-v6-v5
                
	
	
	//glRotatef(rotqube, 1.0f, 1.0f, 1.0f);
	//glRotatef(rotqube, 1.0f, 0.0f, 0.0f);
	//glRotatef(rotqube, 0.0f, 1.0f, 0.0f);
	glTranslatef(-1.0f, 1.0f, 0.0f);
	glScalef(0.7f, 0.7f, 0.7f);	
	glRotatef(rotqube, 1.0f,1.0f,1.0f);
	objSheet2D.Draw_Step_Three();
	
	/* 
	// activate and specify pointer to vertex array
	glEnableClientState(GL_COLOR_ARRAY);
	glColorPointer(3, GL_FLOAT, 0, colors);
	
	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, myCube.get_vertices_array());
	
	// draw a cube
	glDrawElements(GL_QUADS, 24, GL_UNSIGNED_BYTE, myCube.get_indices_array());
	
	// deactivate vertex arrays after drawing
	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_VERTEX_ARRAY);	 
	*/	

	glPopMatrix();
	glPushMatrix();
  	glTranslatef(1.0f, 1.0f, 0.0f);
  	glScalef(0.7f, 0.7f, 0.7f);

	glBegin(GL_LINES); //Drawing The Axis
	  		glColor3f(1.0f,0.0f,0.0f);
	  		glVertex3f(1.0f, -1.0f, 0.0f);
	  		glVertex3f(-1.0f, -1.0f, 0.0f);
	  	
			glColor3f(0.0f,1.0f,0.0f);
	  		glVertex3f( -1.0f, 1.0f, 0.0f);
	  		glVertex3f( -1.0f, -1.0f, 0.0f);
			
	 //		glColor3f(0.3f,0.3f,1.0f);
	 // 	glVertex3f(-0.0f, -0.0f, 1.0f);
	 //	    glVertex3f(-0.0f, -0.0f, -1.0f);	  
	glEnd();


	// activate and specify pointer to vertex array
	//glEnableClientState(GL_COLOR_ARRAY);
	//glColorPointer(3, GL_FLOAT, 0, colors);
	

	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(2, GL_FLOAT, 0, xvGraph.get_vertices_array());
	glColor3f(1.0f,0.0f,1.0f);

	glDrawArrays(GL_LINE_STRIP, 0, xvGraph.Number_Of_Vertices());
	
	// deactivate vertex arrays after drawing
	//glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_VERTEX_ARRAY);	

	

	glPopMatrix();
	glPushMatrix();	
	
  	glTranslatef(-1.0f, -0.5f, 0.0f);
  	glScalef(0.7f, 0.7f, 0.7f);	
	objSheet2D.Draw_Setp_One();	

	glPopMatrix();
  	glTranslatef(1.0f, -0.5f, 0.0f);
  	glScalef(0.7f, 0.7f, 0.7f);	
// 	glRotatef(rotqube, 1.0f,1.0f,1.0f);
	objSheet2D.Draw_Step_Two_Immediate_Mode();	
    
/**  	
//	glEnableClientState(GL_COLOR_ARRAY);
//	glColorPointer(3, GL_FLOAT, 0, colors);
	glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
	
	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, objSheet2D.get_vertices_array());
	
	
	glColor3f(1.0f,0.0f,1.0f);
	// draw a cube
	glDrawElements(GL_QUADS, 20, GL_UNSIGNED_BYTE, objSheet2D.get_indices_array());
	
	// deactivate vertex arrays after drawing
//	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_VERTEX_ARRAY);	

	glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
*/	
	
	if(rotqube>361){rotqube=0;}else{rotqube+=1.0f;}

	glFlush();
	        
}

void MyGL::MouseMove(Point p, dword) {
        Refresh();
}


GUI_APP_MAIN{
    TopWindow win;
    MyGL gl;
    win.Add(gl.LeftPos(10, 700).TopPos(10, 700));
    win.Sizeable().Zoomable();
    win.Open();
    win.Run();
}

