#include "Sheet2D.h"

// DEFAULT CONSTRACTOR
Sheet2D::Sheet2D(){
/*    
	// Vertices Array
	vertices=new GLfloat[48];
	
    // Array of Indexs of Vertices array
	indices=new GLubyte[20];
*/  
	/////////////////////
	// STEP-1 DRAWING //
	///////////////////
	  
	// Outer rectangle
    u_indices[0]=0;
    u_indices[1]=1;
    u_indices[2]=3;
    u_indices[3]=3;
    u_indices[4]=1;
    u_indices[5]=2;

    
	// Top Left rectangle 'x' 
    u_indices[6]=0;
    u_indices[7]=4;
    u_indices[8]=6;
    u_indices[9]=6;
    u_indices[10]=4;
    u_indices[11]=5;

	// Top Right rectangle 'x' 
    u_indices[12]=7;
    u_indices[13]=1;
    u_indices[14]=9;
    u_indices[15]=9;
    u_indices[16]=1;
    u_indices[17]=8;
        
	// Bottom Right rectangle 'x' 
    u_indices[18]=10;
    u_indices[19]=11;
    u_indices[20]=12;
    u_indices[21]=12;
    u_indices[22]=11;
    u_indices[23]=2;
	
    // Bottom Left rectangle 'x' 
    u_indices[24]=13;
    u_indices[25]=14;
    u_indices[26]=3;
    u_indices[27]=3;    
    u_indices[28]=14;
    u_indices[29]=15;

	/////////////////////
	// STEP 2 DRAWING //
    ///////////////////
    
	// Outer rectangle
    u_indices[30]=6;
    u_indices[31]=5;
    u_indices[32]=13;
    u_indices[33]=13;
    u_indices[34]=5;
    u_indices[35]=14;

    
	// Top rectangle 'x' 
    u_indices[36]=4;
    u_indices[37]=7;
    u_indices[38]=5;
    u_indices[39]=5;
    u_indices[40]=7;
    u_indices[41]=9;

	// Right rectangle 'x' 
    u_indices[42]=9;
    u_indices[43]=8;
    u_indices[44]=10;
    u_indices[45]=10;
    u_indices[46]=8;
    u_indices[47]=11;
        
	// bottom rectangle 'x' 
    u_indices[48]=14;
    u_indices[49]=10;
    u_indices[50]=15;
    u_indices[51]=15;
    u_indices[52]=10;
    u_indices[53]=12;
	
    // left Left rectangle 'x' 
    u_indices[54]=5;
    u_indices[55]=9;
    u_indices[56]=14;
    u_indices[57]=14;    
    u_indices[58]=9;
    u_indices[59]=10;

	/////////////////////
	// STEP 3 DRAWING //
    ///////////////////
    
	// Top rectangle 'x' 
    u_indices[60]=16;
    u_indices[61]=17;
    u_indices[62]=20;
    u_indices[63]=20;
    u_indices[64]=17;
    u_indices[65]=21;

	// Right rectangle 'x' 
    u_indices[66]=21;
    u_indices[67]=17;
    u_indices[68]=18;
    u_indices[69]=18;
    u_indices[70]=22;
    u_indices[71]=21;
        
	// Bottom rectangle 'x' 
    u_indices[72]=22;
    u_indices[73]=23;
    u_indices[74]=18;
    u_indices[75]=18;
    u_indices[76]=23;
    u_indices[77]=19;
	
    // Bottom Left rectangle 'x' 
    u_indices[78]=19;
    u_indices[79]=16;
    u_indices[80]=20;
    u_indices[81]=20;    
    u_indices[82]=23;
    u_indices[83]=19;    
    
	// Outer rectangle
    u_indices[84]=19;
    u_indices[85]=16;
    u_indices[86]=17;
    u_indices[87]=17;
    u_indices[88]=18;
    u_indices[89]=19;    
    
    
    
    
    
        
	v.Set_Array(v_array);
	u.Set_Array(u_array);
	
    paper.Set_Color(0.55f, 0.45f, 0.35f);
	paper_border.Set_Color(0.35, 0.25, 0.15);
	xSquare.Set_Color(0.5f,0.45f, 0.40f);
	xSquare_border.Set_Color(0.8f,0.75f, 0.60f);    

}

// SET CONSTRACTOR
Sheet2D::Sheet2D(GLfloat Side_A_Length, GLfloat Side_B_Length, GLfloat X_Length){
    Sheet2D();
    Generate(Side_A_Length, Side_B_Length, X_Length);
}


/*****************************************************
This function is a sub function of Generate() it sets
the translated coordinate of the long and short side
into given x1, x2, x3, x4 and y1, y2, y3, y4

Side_A_Length<Side_B_Length or Side_A_Length>Side_B_Length
vertices calculation code are same only the only the x & y
coordinates gets swaped. 
*****************************************************/


void Sheet2D::set_coord_calc(coordinate_translator& ct, GLfloat& offset, GLfloat& X_Length,
							 GLfloat& a1, GLfloat& a2, GLfloat& a3, GLfloat& a4,
							 GLfloat& b1, GLfloat& b2, GLfloat& b3, GLfloat& b4){
	/*** FUNCTION BODY ***/		
		
	a1=1.0f; // as ct.translate(0) will return -1.0 no point wasting cpu cycle calculating that;
	a2=-1.0f; // again ct.translate(Long_Side_Length) return 1 no point wasting cpu cycle calculating that;
	
	b1=ct.translate(offset);
	b2=a2*b1; //ct.translate(Short_Side_Length+offset); 
	
	b3=ct.translate(X_Length+offset);
	b4=a2*b3; //ct.translate(Short_Side_Length+offset-X_Length);
	
	a4=ct.translate(X_Length);		
	a3=a2*a4; //ct.translate(Long_Side_Length-X_Length);	
	
	
}


// FUNCTION TO SET THE VERTICES USING Side_A_Length AND Side_B_Length AND X_Length
Sheet2D& Sheet2D::Generate(GLfloat Side_A_Length, GLfloat Side_B_Length, GLfloat X_Length){
	
	// Coordinate Translator Object
	coordinate_translator ct;
	// Temp veriable to (keep Long_Side_Length - Short_Side_Length)
	GLfloat offset=0.0f;

	// here we have created x1, x2, x3, x4, y1, y2, y3, y4, z1 as referance 
	// veriables which are actually pointing to the specific cells in
	// vertices array where the x1, x2, x3, x4, y1, y2, y3, y4 occures for
	// the first time. instead of copying the values to those cells,
	// the values are stored directly into the cell at the frist place.
	GLfloat x1=0.0f; 
	GLfloat x2=0.0f;
	GLfloat x3=0.0f;
	GLfloat x4=0.0f;
	GLfloat y1=0.0f;
	GLfloat y2=0.0f;
	GLfloat y3=0.0f;
	GLfloat y4=0.0f;
	GLfloat z1=0.0f;
	z2=0.0f;
	z3=0.0f;
	
	// initialize to 0.0
	//x1=x2=x3=x4=y1=y2=y3=y4=0.0f;
	
	
	if(Side_A_Length<Side_B_Length){
		// if Side A is longer then Side B
		offset=(Side_B_Length-Side_A_Length)/2.0f;
		ct.recalculate(Side_B_Length,0);
		set_coord_calc(ct, offset, X_Length, x1, x2, x3, x4, y1, y2, y3, y4);
		

	
	}else if(Side_A_Length>Side_B_Length){
		// if Side B is longer then Side A
		offset=(Side_A_Length-Side_B_Length)/2.0f;
		ct.recalculate(Side_A_Length,0);
		set_coord_calc(ct, offset, X_Length, y1, y2, y3, y4, x1, x2, x3, x4);
		

		
	}else{
		// if Side A and Side B are same length
		
		ct.recalculate(Side_A_Length,0);
		x1=-1.0f; // as ct.translate(0) will return -1.0 no point wasting cpu cycle calculating that;
		x2=1.0f; // again ct.translate(Side_B_Length) return 1 no point wasting cpu cycle calculating that;		
		y1=1.0f; // as ct.translate(0) will return -1.0 no point wasting cpu cycle calculating that;
		y2=-1.0f; // again ct.translate(Side_A_Length) return 1 no point wasting cpu cycle calculating that;	
		
		x3=y4=ct.translate(X_Length);
		x4=y3=(x1*x3);
	}
	z2=(x3-x1)/2;
	// make z2 +ve and z3 -ve to keep the boxes open face towards the camera
	if(z2<0){
		z3=z2; z2=-1.0*z3;
	}else{
		z3=-1.0*z2;
	}	
	
	
	
	

	v[0].Set3D_xyz(x1,y1,z1);
	v[1].Set3D_xyz(x2,y1,z1);
	v[2].Set3D_xyz(x2,y2,z1);
	v[3].Set3D_xyz(x1,y2,z1);
	
	v[4]=v[0].Get_Vertices();
	v[5].Set3D_xyz(x3,y1,z1);
	v[6].Set3D_xyz(x3,y3,z1);
	v[7].Set3D_xyz(x1,y3,z1);
	
	v[8].Set3D_xyz(x4,y1,z1);
	v[9]=v[1].Get_Vertices();
	v[10].Set3D_xyz(x2,y3,z1);
	v[11].Set3D_xyz(x4,y3,z1);
	
	v[12].Set3D_xyz(x4,y4,z1);
	v[13].Set3D_xyz(x2,y4,z1);
	v[14]=v[2].Get_Vertices();	
	v[15].Set3D_xyz(x4,y2,z1);
	
	v[16].Set3D_xyz(x1,y4,z1);
	v[17].Set3D_xyz(x3,y4,z1);
	v[18].Set3D_xyz(x3,y2,z1);	
	v[19]=v[3].Get_Vertices();

	///////////////////////////////
		
	u[0].Set3D_xyz(x1,y1,z1);
	u[1].Set3D_xyz(x2,y1,z1);
	u[2].Set3D_xyz(x2,y2,z1);
	u[3].Set3D_xyz(x1,y2,z1);		

	u[4].Set3D_xyz(x3,y1,z1);
	u[5].Set3D_xyz(x3,y3,z1);
	u[6].Set3D_xyz(x1,y3,z1);

	u[7].Set3D_xyz(x4,y1,z1);
	u[8].Set3D_xyz(x2,y3,z1);
	u[9].Set3D_xyz(x4,y3,z1);	
	
	u[10].Set3D_xyz(x4,y4,z1);
	u[11].Set3D_xyz(x2,y4,z1);
	u[12].Set3D_xyz(x4,y2,z1);
	
	u[13].Set3D_xyz(x1,y4,z1);
	u[14].Set3D_xyz(x3,y4,z1);
	u[15].Set3D_xyz(x3,y2,z1);		
    
    u[16].Set3D_xyz(x3,y3,z3);
	u[17].Set3D_xyz(x4,y3,z3);
	u[18].Set3D_xyz(x4,y4,z3);
	u[19].Set3D_xyz(x3,y4,z3);

    u[20].Set3D_xyz(x3,y3,z2);
	u[21].Set3D_xyz(x4,y3,z2);
	u[22].Set3D_xyz(x4,y4,z2);
	u[23].Set3D_xyz(x3,y4,z2);
			
    return *this;

}

void Sheet2D::Draw_Step_Three(){
/*
	// drawing borders
	glLineWidth(2.0);
	glColor3fv(xSquare_border.Get_Array());
		glBegin(GL_LINE_LOOP);
			glNormal3f(0.0f,0.0f,-1.0f);
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z3);
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z3);
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z3);
		glEnd();
		
		glBegin(GL_LINE_LOOP);
			glNormal3f(0.0,1.0f,0.0f);
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z3);
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z3);
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z2);
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z2);
		glEnd();	
	
		glBegin(GL_LINE_LOOP);
			glNormal3f(0.0,1.0f,0.0f);	
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z2);
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z2);
		glEnd();	
	
		glBegin(GL_LINE_LOOP);
			glNormal3f(-1.0,0.0f,0.0f);	
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z2);
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z2);
		glEnd();		
			
		glBegin(GL_LINE_LOOP);
			glNormal3f(-1.0,0.0f,0.0f);
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z3);
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z3);
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z2);
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z2);		
		glEnd();		
	glLineWidth(1.0);			
*/
	// drawing the rects
	glBegin(GL_QUADS);
		glColor3fv(paper.Get_Array());
		//glColor3fv(xSquare_border.Get_Array());
			glNormal3f(0.0f,0.0f,-1.0f);		
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z3);
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z3);
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z3);
		
		//glColor3fv(paper.Get_Array());
			glNormal3f(0.0,-1.0f,0.0f);			
			//glColor3fv(xSquare_border.Get_Array());
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z3);
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z3);
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z2);
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z2);
		
			glNormal3f(0.0,1.0f,0.0f);	
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z2);
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z2);
			
			glNormal3f(-1.0,0.0f,0.0f);		
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z3);
			glVertex3f(v[17].Get_x(),v[17].Get_y(),z2);
			glVertex3f(v[6].Get_x(),v[6].Get_y(),z2);
			
			glNormal3f(-1.0,0.0f,0.0f);					
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z3);
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z3);
			glVertex3f(v[12].Get_x(),v[12].Get_y(),z2);
			glVertex3f(v[11].Get_x(),v[11].Get_y(),z2);	
	
	glEnd();
	
	
}


void Sheet2D::Draw_Step_Two_Immediate_Mode(){

	glLineStipple(1, 0x00FF);
	glEnable(GL_LINE_STIPPLE);
		glColor3fv(paper_border.Get_Array());
		glBegin(GL_LINE_LOOP);
			glNormal3f(0.0,0.0f,-1.0f);	
			glVertex3fv(v[5].Get_Vertices());
			glVertex3fv(v[8].Get_Vertices());
			glVertex3fv(v[15].Get_Vertices());
			glVertex3fv(v[18].Get_Vertices());
		glEnd();
		glBegin(GL_LINE_LOOP);	
			glNormal3f(0.0,0.0f,-1.0f);	
			glVertex3fv(v[7].Get_Vertices());
			glVertex3fv(v[10].Get_Vertices());
			glVertex3fv(v[13].Get_Vertices());
			glVertex3fv(v[16].Get_Vertices());
		glEnd();
	glDisable(GL_LINE_STIPPLE);
	
	glBegin(GL_QUADS);
		glColor3fv(paper.Get_Array());
		
		glNormal3f(0.0,0.0f,-1.0f);	
		glVertex3fv(v[5].Get_Vertices());
		glVertex3fv(v[8].Get_Vertices());
		glVertex3fv(v[15].Get_Vertices());
		glVertex3fv(v[18].Get_Vertices());
		
		glNormal3f(0.0,0.0f,-1.0f);	
		glVertex3fv(v[7].Get_Vertices());
		glVertex3fv(v[10].Get_Vertices());
		glVertex3fv(v[13].Get_Vertices());
		glVertex3fv(v[16].Get_Vertices());
	glEnd();	

}

void Sheet2D::Draw_Step_Two_Array_Mode(){

	glEnableClientState(GL_VERTEX_ARRAY);
	//glVertexPointer(2, GL_FLOAT, (sizeof(GLfloat)*3), u_array);
	glVertexPointer(3, GL_FLOAT, 0, u_array);
	glColor3fv(paper.Get_Array());
	
	glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
	
	glDrawElements(GL_TRIANGLES, 90, GL_UNSIGNED_BYTE, u_indices);
	
	glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
	
	glDisableClientState(GL_VERTEX_ARRAY);		
}

//glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
//glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);

void Sheet2D::Draw_Setp_One(){

	// DRAWING THE DOTTED BORDERS OF 5 RECTS
	glColor3fv(xSquare_border.Get_Array());
	glLineStipple(1, 0x00FF);	
	glEnable(GL_LINE_STIPPLE);		
		glBegin(GL_LINE_LOOP);
			glNormal3f(0.0,0.0f,-1.0f);				
			for(int i=4;i<8;i++){ 
				glVertex3fv(v[i].Get_Vertices()); 
			}		
		glEnd();		
		
		glBegin(GL_LINE_LOOP);
			glNormal3f(0.0,0.0f,-1.0f);				
			for(int i=8;i<12;i++){ 
				glVertex3fv(v[i].Get_Vertices()); 
			}		
		glEnd();
		
		glBegin(GL_LINE_LOOP);
			glNormal3f(0.0,0.0f,-1.0f);				
			for(int i=12;i<16;i++){ 
				glVertex3fv(v[i].Get_Vertices()); 
			}		
		glEnd();		
		
		glBegin(GL_LINE_LOOP);
			glNormal3f(0.0,0.0f,-1.0f);				
			for(int i=16;i<20;i++){ 
				glVertex3fv(v[i].Get_Vertices()); 
			}		
		glEnd();				
	glDisable(GL_LINE_STIPPLE);			
	
	glColor3fv(paper_border.Get_Array());
	glBegin(GL_LINE_LOOP);
		glNormal3f(0.0,0.0f,-1.0f);				
		for(int i=0;i<4;i++){ 
			glVertex3fv(v[i].Get_Vertices()); 
		}		
	glEnd();

		


	
	// DRAWING THE FILL OF THE 5 RECT
	glBegin(GL_QUADS);
		glNormal3f(0.0,0.0f,-1.0f);				
		glColor3fv(xSquare.Get_Array());
		for(int i=4;i<20;i++){
			glVertex3fv(v[i].Get_Vertices());
		}		
		
		glNormal3f(0.0,0.0f,-1.0f);				
		glColor3fv(paper.Get_Array());
		for(int i=0;i<4;i++){
			glVertex3fv(v[i].Get_Vertices());
		}		
		
	glEnd();

}
// DISTRCTOR
Sheet2D::~Sheet2D(){
//    delete[] indices;
//    delete[] vertices;  
    
}
