#ifndef _MySecondGL_Sheet2D_h_
#define _MySecondGL_Sheet2D_h_

#include "coordinate_translator.h"
#include "box_calc.h"
#include "My_OGL_Obj_Lib.h"

class GL_Color{
	public:
		// Default and Set Value Constractor
		GL_Color(){ c[0]=c[1]=c[2]=1.0f; }
		GL_Color(GLfloat r, GLfloat g, GLfloat b){c[0]=r; c[1]=g; c[2]=b;}
		
		// Value Setting Functions		
		GL_Color& Set_Color(GLfloat r, GLfloat g, GLfloat b){c[0]=r; c[1]=g; c[2]=b; return *this;}
		GL_Color& Set_R(GLfloat r){c[0]=r; return *this;}
		GL_Color& Set_G(GLfloat g){c[1]=g; return *this;}
		GL_Color& Set_B(GLfloat b){c[2]=b; return *this;}		
		
		// Value Retriving Functions		
		GLfloat Get_R() const { return c[0];}
		GLfloat Get_G() const { return c[1];}
		GLfloat Get_B() const { return c[2];}		
		
		// Array Retriving Functions
		const GLfloat* Get_Array() const { return c; }
		
	private:
		// Data Storage
		GLfloat c[3];
};

/*
class GL_Vertices{
	public:
		// Default and Set Value Constractor
		GL_Vertices(){ v[0]=v[1]=v[2]=0.0f; }
		GL_Vertices(GLfloat x, GLfloat y, GLfloat z){v[0]=x; v[1]=y; v[2]=z;}
		
		// Value Setting Functions
		GL_Vertices& Set_Coord(GLfloat x, GLfloat y, GLfloat z){v[0]=x; v[1]=y; v[2]=z; return *this;}
		GL_Vertices& Set_X(GLfloat x){v[0]=x; return *this;}
		GL_Vertices& Set_Y(GLfloat y){v[1]=y; return *this;}
		GL_Vertices& Set_Z(GLfloat z){v[2]=z; return *this;}
		
		// Value Retriving Functions
		GLfloat Get_X() const { return v[0];}
		GLfloat Get_Y() const { return v[1];}
		GLfloat Get_Z() const { return v[2];}		
		
		// Address Retriving Functions
		GLfloat* Get_X_Address(){ return &v[0];}
		GLfloat* Get_Y_Address(){ return &v[1];}
		GLfloat* Get_Z_Address(){ return &v[2];}
		
		// Array Retriving Functions
		const GLfloat* Get_Array() const { return v; }		
		
		// Overloaded Operators Functions
		GL_Vertices& operator=(const GL_Vertices& rhs){ v[0]=rhs.Get_X(); v[1]=rhs.Get_Y(); v[2]=rhs.Get_Z(); return *this;}
		
	private:
		// Data Storage
		GLfloat v[3];
};
*/

class Sheet2D{
    public:
        Sheet2D();
        Sheet2D(GLfloat Side_A_Length, GLfloat Side_B_Length, GLfloat X_Length);
				
        Sheet2D& Generate(GLfloat Side_A_Length, GLfloat Side_B_Length, GLfloat X_Length);
//        const GLubyte* get_indices_array() const { return indices;};
//       const GLfloat* get_vertices_array() const { return vertices; }
//        int get_indices_array_size(){ return 16; }
//        int get_vertices_array_size(){ return 48; }
        void Draw_Setp_One();
        void Draw_Step_Two_Immediate_Mode();
        void Draw_Step_Three();
        void Draw_Step_Two_Array_Mode();
        ~Sheet2D();
    private:
    	// set_coord_calc is not exposed to the end user as its only be used by the Generate() function
    	void set_coord_calc(coordinate_translator&, GLfloat&, GLfloat&, GLfloat&, GLfloat&, GLfloat&, GLfloat&,	GLfloat&, GLfloat&, GLfloat&, GLfloat&);
        GLfloat v_array[60];
        GLfloat u_array[72];
        GLubyte u_indices[90];
        vertices u;
        vertices v;
		GL_Color paper;
		GL_Color paper_border;
		GL_Color xSquare;
		GL_Color xSquare_border;  
		GLfloat z2;
		GLfloat z3;
};




#endif
