#include "cube.h"

// DEFAULT CONSTRACTOR
cube::cube(){
    vertices=new GLfloat[24];
    indices=new GLubyte[24];
    
    indices[0]=0;
    indices[1]=1;
    indices[2]=2;  
    indices[3]=3;
    
    indices[4]=0;
    indices[5]=3;  
    indices[6]=4;
    indices[7]=5;

    indices[8]=0;    
    indices[9]=5;
    indices[10]=6;
    indices[11]=1;
    
    indices[12]=1;
    indices[13]=6;
    indices[14]=7;    
    indices[15]=2;
    
    indices[16]=7;
    indices[17]=4;
    indices[18]=3;
    indices[19]=2;
    
    indices[20]=4;    
    indices[21]=7;
    indices[22]=6;
    indices[23]=5;
}

// SET CONSTRACTOR
cube::cube(float x1, float y1, float z1, float x2, float y2, float z2){
    cube();
    set_coordinate(x1, y1, z1, x2, y2, z2);
}

// FUNCTION TO SET THE VERTICES USING COORDINATE-1 AND COORDINATE-2
cube& cube::set_coordinate(float x1, float y1, float z1, float x2, float y2, float z2){

    vertices[0]=x2;  vertices[1]=y1;  vertices[2]=z1;  //V0
    vertices[3]=x1;  vertices[4]=y1;  vertices[5]=z1;  //V1
    vertices[6]=x1;  vertices[7]=y2;  vertices[8]=z1;  //V2
    vertices[9]=x2;  vertices[10]=y2; vertices[11]=z1; //V3
    vertices[12]=x2; vertices[13]=y2; vertices[14]=z2; //V4
    vertices[15]=x2; vertices[16]=y1; vertices[17]=z2; //V5
    vertices[18]=x1; vertices[19]=y1; vertices[20]=z2; //V6
    vertices[21]=x1; vertices[22]=y2; vertices[23]=z2; //V7
    
    return *this;

}

// DISTRCTOR
cube::~cube(){
    delete[] indices;
    delete[] vertices;  
    
}
