#include <MySql/MySql.h>

using namespace Upp;

#define SCHEMADIALECT <MySql/MySqlSchema.h>
#define MODEL <SQL_MySql/schema.sch>
#include <Sql/sch_header.h>
#include <Sql/sch_source.h>
#include <Sql/sch_schema.h>

CONSOLE_APP_MAIN
{
	MySqlSession session;
	// edit the connection parameters if necessary
	if(!session.Connect("root", "password", "test")) {
		LOG("ERROR: Unable to connect to database\n");
		SetExitCode(1);
		return;
	}

	LOG("Connected\n");
	SQL = session;

	SqlSchema sch(MY_SQL);
	All_Tables(sch);
	// create the table if necessary
	SqlPerformScript(sch.Upgrade());
	SqlPerformScript(sch.Attributes());
	SQL.ClearError();

	LOG("Inserting values:");
	SQL * Insert(WORKER)(ID, 0)(NAME, "Joe")(LASTNAME, "Smith")(PLANT_ID, 0);
	LOG(SQL.ToString());
	SQL * Insert(WORKER)(ID, 1)(NAME, "Mike")(LASTNAME, "Smith")(PLANT_ID, 0);
	LOG(SQL.ToString());
	SQL * Insert(WORKER)(ID, 2)(NAME, "Jon")(LASTNAME, "Goober")(PLANT_ID, 1);
	LOG(SQL.ToString());

	SQL * Insert(PLANT)(ID, 0)(NAME, "First Plant")(ADDRESS, "First st.");
	LOG(SQL.ToString());
	SQL * Insert(PLANT)(ID, 1)(NAME, "Second Plant")(ADDRESS, "Second st.");
	LOG(SQL.ToString());

	LOG("Selecting values:");
	SQLID(PLANT_NAME);
	SQL * Select(WORKER(NAME, LASTNAME), PLANT(NAME).As(PLANT_NAME), PLANT(ADDRESS)).From(WORKER).LeftJoin(PLANT).On(WORKER(PLANT_ID) == PLANT(ID));
	LOG(SQL.ToString());
	while (SQL.Fetch()) {
		LOG("-----");
		DUMP(SQL[NAME]); DUMP(SQL[LASTNAME]);
		DUMP(SQL[PLANT_NAME]); DUMP(SQL[ADDRESS]);
	}

	SQL * Select(WORKER(NAME, LASTNAME), PLANT(NAME, ADDRESS)).From(WORKER).LeftJoin(PLANT).On(WORKER(PLANT_ID) == PLANT(ID));
	LOG(SQL.ToString());
	while (SQL.Fetch()) {
		LOG("-----");
		DUMP(SQL[NAME]); DUMP(SQL[LASTNAME]);
		DUMP(SQL[2]); DUMP(SQL[ADDRESS]);
	}
}
