#ifndef _SqlSetIndex_SqlSetIndex_h_
#define _SqlSetIndex_SqlSetIndex_h_

NAMESPACE_UPP

template<> String AsString(const SqlSet& set) {
	StringBuffer text;
	const char *s = ~set;
	
	for(;;) {
		const char *b = s;

		while((byte)*s >= 32)
			s++;

		text.Cat(b, s);
		int c = *s;
		
		if (c == SQLC_AS) {
			text << ' ';
		}
		else
		if (c == SQLC_OF)
			text << '.';
		else
		if (c == SQLC_COMMA)
			text << ", ";

		s++;

		if (c == '\0' || c == SQLC_ID)
			break;
	}

	return text;
}

class SqlSetIndex {
private:
	VectorMap<String, int> list;
	inline void Parse(const SqlSet& set);
public:
	SqlSetIndex(const SqlSet& set)            { Parse(set); }
	void Clear()                              { list.Clear(); }
	int operator[](const SqlId& id) const     { return list.Get(~id); }
	int operator[](const String& id) const    { return list.Get(id); }
	SqlSetIndex& operator=(const SqlSet& set) { list.Clear(); Parse(set); return *this; }
	const VectorMap<String, int>& operator~() { return list; }
};

void SqlSetIndex::Parse(const SqlSet& set)
{
	int index = 0;
	StringBuffer text;
	bool isNext = true, isAs = false;
	const char *s = ~set;

	for(;;) {
		const char *b = s;

		while((byte)*s > 32 && (byte)*s != ',')
			s++;

		text.Cat(b, s);
		int c = *s;

		if (c == SQLC_OF) { // '.'
			text << *s;
			isNext = false;
		}
		else
		if (c == ' ')
			isNext = false;
		else
		if (c == SQLC_AS)
			isAs = true;

		if (isNext) {
			if (!isAs)
				list.GetAdd(text, index++);
			else {
				list.GetAdd(text, index);
				isAs = false;
			}

			text.Clear();
		}
		else
			isNext = true;

		s++;

		if (c == '\0' || c == SQLC_ID)
			break;
	}
}

END_UPP_NAMESPACE

#endif
