#include "App.h"

#ifdef _DEBUG
#include <Sql/sch_schema.h>
#endif

#include <Sql/sch_source.h>

SQLID(PLANT_NAME);

CONSOLE_APP_MAIN
{
#ifdef _DEBUG
	LOG("Debug mode!");
#endif

	Sqlite3Session sqlite3;
	sqlite3.LogErrors(true);
	if (!sqlite3.Open(ConfigFile(GetExeTitle() + ".db"))) {
		LOG("Can't create or open database file\n");
		return;
	}

	SQL = sqlite3;

	// Update the schema to match the schema described in "Database.sch"
#ifdef _DEBUG
	SqlSchema sch(SQLITE3);
	StdStatementExecutor se(sqlite3);
	All_Tables(sch);
	if(sch.ScriptChanged(SqlSchema::UPGRADE))
		Sqlite3PerformScript(sch.Upgrade(),se);
	if(sch.ScriptChanged(SqlSchema::ATTRIBUTES)) {
		Sqlite3PerformScript(sch.Attributes(),se);
	}
	if(sch.ScriptChanged(SqlSchema::CONFIG)) {
		Sqlite3PerformScript(sch.ConfigDrop(),se);
		Sqlite3PerformScript(sch.Config(),se);
	}
	sch.SaveNormal();
#endif
	// Get the list of tables
	Vector<String> table_list = sqlite3.EnumTables("");
	LOG(Format("Tables: (%d)",table_list.GetCount()));
	for (int i = 0; i < table_list.GetCount(); ++i)
		LOG(Format("  #%d: %s",i+1,table_list[i]));

	LOG("Inserting values:");
	SQL * Insert(WORKER)(ID, 0)(NAME, "Joe")(LASTNAME, "Smith")(PLANT_ID, 0);
	LOG(SQL.ToString());
	SQL * Insert(WORKER)(ID, 1)(NAME, "Mike")(LASTNAME, "Smith")(PLANT_ID, 0);
	LOG(SQL.ToString());
	SQL * Insert(WORKER)(ID, 2)(NAME, "Jon")(LASTNAME, "Goober")(PLANT_ID, 1);
	LOG(SQL.ToString());

	SQL * Insert(PLANT)(ID, 0)(NAME, "First Plant")(ADDRESS, "First st.");
	LOG(SQL.ToString());
	SQL * Insert(PLANT)(ID, 1)(NAME, "Second Plant")(ADDRESS, "Second st.");
	LOG(SQL.ToString());

	LOG('\n' << "Testing SqlSetIndex:");
	SqlSet testing_set(WORKER(ID, NAME), ID.Of(WORKER), PLANT(NAME).As(PLANT_NAME), PLANT(ID, NAME, ADDRESS));
	DUMP(testing_set);
	SqlSetIndex testing_list(testing_set);
	DUMPM(~testing_list);

	LOG('\n' << "Selecting values:");
	SqlSet set(WORKER(NAME, LASTNAME), PLANT(NAME).As(PLANT_NAME), PLANT(ADDRESS));
	SqlSetIndex list(set);

	SQL * Select(set).From(WORKER).LeftJoin(PLANT).On(WORKER(PLANT_ID) == PLANT(ID));
	LOG(SQL.ToString());
	while (SQL.Fetch()) {
		LOG("-----");
		DUMP(SQL[list[WORKER(NAME)]]);
		DUMP(SQL[list[WORKER(LASTNAME)]]);
		DUMP(SQL[list[PLANT(NAME)]]);
		//DUMP(SQL[list[PLANT_NAME]]); // The same as previous value
		DUMP(SQL[list[PLANT(ADDRESS)]]);
	}
}
