#ifndef _APopupTest_Popup_h_
#define _APopupTest_Popup_h_

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

class popDlg : public TopWindow {
	typedef popDlg CLASSNAME;

public:
	popDlg()
	{
		Add(localEdit);
		Add(list);		
		localEdit.WhenEnter = THISBACK(LocalEditEnter);
		localEdit <<= THISBACK(LocalEdit);
	}
	
	EditString localEdit;
	ArrayCtrl list;
	
	bool ok;
	
	void Popup(EditField& edit)
	{
		Rect r = edit.GetScreenRect();
		int l, h;
		edit.GetSelection(l,h);
		
		ResizeCtrls(r);
		
		localEdit.SetText(edit.GetText());
		
		list.AddColumn("");
		list.AddColumn("");
		
		ReloadData();
		
		ok = false;

		PopUp();
		
		localEdit.SetFocus();
		
		localEdit.SetSelection(l, h);

		while(IsOpen())
		{
			ProcessEvents();
			GuiSleep(10);
		}
			
		if (ok)
		{
			edit.SetText(localEdit.GetText());
		}
	}
	
	void ResizeCtrls(Rect& r)
	{
		Size sz = GetScreenSize();
		
		int w = 500;
		int h = 500;
		
		if(r.left < sz.cx/2)
		{
			if (r.top<sz.cy/2) 
			{
				list.HSizePosZ(4, 4).VSizePosZ(20, 4);
				localEdit.LeftPosZ(0, r.Width()).TopPosZ(0, 19);
				SetRect(r.left, r.top, w, h);
			}
			else
			{
				list.HSizePosZ(4, 4).VSizePosZ(4, 20);
				localEdit.LeftPosZ(0, r.Width()).BottomPosZ(0, 19);
				SetRect(r.left , r.top - h + r.Height(), w, h);
			}
		}
		else
		{
			if (r.top<sz.cy/2) 
			{
				list.HSizePosZ(4, 4).VSizePosZ(20, 4);
				localEdit.LeftPosZ(w - r.Width(), r.Width()).TopPosZ(0, 19);
				SetRect(r.left - w + r.Width(), r.top, w, h);
			}
			else
			{
				list.HSizePosZ(4, 4).VSizePosZ(4, 20);
				localEdit.LeftPosZ(w - r.Width(), r.Width()).BottomPosZ(0, 19);
				SetRect(r.left - w + r.Width(), r.top - h + r.Height(), w, h);
			}
		}
	}
	
	void LocalEditEnter()
	{
		ok = true;
		Close();
	}
	
	virtual void Deactivate()
	{
		Close();
	}
	
	void LocalEdit(){ReloadData();}
	
	void ReloadData()
	{
		list.Clear();
		for(int i = 0; i < 1000; i++)
		{
			String str = Format("item %04n", i);
			String find = localEdit.GetText().ToString();
			if (str.Find(find)>=0)
				list.Add(i, str);
		}
	}
};


#endif
