#include <CtrlLib/CtrlLib.h>

#include <PopEasy/PopEasy.h>

using namespace Upp;

class CustomerPopUp : public TreeListPopUp
{
public:
	CustomerPopUp()
	{
		SetViewStyle(VS_ListOnly);
		list.AddColumn("id", 0);
		list.AddColumn(t_("CustomerNo"), 20).SortDefault();
		list.AddColumn(t_("Name"),40).SortDefault();
		SetAutoSelect(true);
		SetAutoPopUp(true);
	}
	
	virtual int PrepareData(const PopUpHint& hint);
	virtual void GetSizes(Size& preferred, Size& minimum);

private:
	//String cur_text;
};

typedef WithPopUp<EditString> EditCust;

#define LAYOUTFILE <PopEasyTest/test.lay>
#include <CtrlCore/lay.h>

struct CustConv : public Convert
{
	virtual Value  Format(const Value& q) const;
	virtual Value  Scan(const Value& text) const;
};

struct MyApp: WithTestLayout<TopWindow>
{
	MyApp(){ 
		CtrlLayout(*this, "Test Pop Up"); 
		billto.SetIPopUp(&pop);
		billto.SetConvert(cust_conv);
		soldto.SetIPopUp(&pop);
		soldto.SetConvert(cust_conv);
		shipto.SetIPopUp(&pop);
		shipto.SetConvert(cust_conv);
		
		prompt.SetQTF("[ [ PopEasy attempts to provide an easy to use framework for certain type of pop up window.&]"
		"[ &][ The libary widgets DropChoice/DropTree/DropGrid etc all share a similar approach, the pop up owns"
		" keyboard focus, and it will be un`-poped as soon as focus is shifted. Sometimes we don`'t want it to be like that."
		" For example, in many cases we wanted to be able to be typing while having the convenience of context "
		"sensitive pop up prompt.&][ &][ This example demonstrates some capabilities of this framework. The "
		"interface is not stable yet. I expect to change it possibly significantly. Test only, not supposed to"
		" be used in any serious code.]"
		);
	}

	CustomerPopUp pop;
	CustConv      cust_conv;
};

void InitCustomers();

GUI_APP_MAIN
{
	InitCustomers();
	MyApp().Sizeable().MaximizeBox().Run();
}

// in an actual application, the data will be retrieved from a database table or some tables
// here we use vector of struct
//
struct Customer
{
	int id;
	const char* name;
	
	String number()const{ return String().Cat()<<5000+id; }
};


// 597 company names from Wiki
//
Customer customers[]=
{
	{0,"Babcock & Wilcox"},
	{0,"Bain & Company"},
	{0,"Bain Capital"},
	{0,"Baker Hughes"},
	{0,"Baldor Electric Company"},
	{0,"Ball Corp."},
	{0,"Bank of America"},
	{0,"Bank of New York Mellon"},
	{0,"Barnes & Noble"},
	{0,"Bath & Body Works"},
	{0,"Baxter International"},
	{0,"Bebo"},
	{0,"BB&T Corporation"},
	{0,"BE Aerospace"},
	{0,"Bealls"},
	{0,"BearingPoint"},
	{0,"Beazer Homes USA"},
	{0,"Bechtel"},
	{0,"Beckman Coulter"},
	{0,"Becton Dickinson"},
	{0,"Bed Bath & Beyond"},
	{0,"Belk"},
	{0,"Belkin"},
	{0,"Bellwether Technology Corporation"},
	{0,"Bemis Manufacturing Company"},
	{0,"Benchmark Electronics"},
	{0,"W. R. Berkley"},
	{0,"Berkshire Hathaway"},
	{0,"Berry Plastics"},
	{0,"Best Buy"},
	{0,"BFG Technologies"},
	{0,"Big Lots"},
	{0,"Biggby Coffee"},
	{0,"Bio-Rad Laboratories"},
	{0,"Biomet"},
	{0,"Birdwell"},
	{0,"BJ Services Company"},
	{0,"BJ's Wholesale Club"},
	{0,"Black & Decker"},
	{0,"BlackRock"},
	{0,"Blockbuster LLC"},
	{0,"BlueLinx Holdings"},
	{0,"Blyth, Inc."},
	{0,"BMC Software"},
	{0,"BNSF Railway"},
	{0,"Bob Evans Restaurants"},
	{0,"Boeing"},
	{0,"Boise Cascade"},
	{0,"Borders Group"},
	{0,"BorgWarner"},
	{0,"Bosch Brewing Company"},
	{0,"Bose Corporation"},
	{0,"Boston Acoustics"},
	{0,"Boston Scientific"},
	{0,"Boyd Gaming"},
	{0,"Bradley Pharmaceuticals"},
	{0,"Briggs & Stratton"},
	{0,"Brightpoint"},
	{0,"Brinker International"},
	{0,"Brink's"},
	{0,"Bristol-Myers Squibb"},
	{0,"Broadcom"},
	{0,"Brookdale Senior Living"},
	{0,"Brown-Forman"},
	{0,"Brunswick Corporation"},
	{0,"Bucyrus International"},
	{0,"Burger King Holdings"},
	{0,"Burlington Coat Factory"},
	{0,"Bushmaster Firearms InternationalCA Technologies"},
	{0,"Calista Corporation"},
	{0,"Calpine"},
	{0,"Capital One"},
	{0,"Carnival Corporation & plc"},
	{0,"Carnival Cruise Lines"},
	{0,"Cartoon Network Studios"},
	{0,"Casco Bay Lines"},
	{0,"Caterpillar Inc."},
	{0,"CBS Corporation"},
	{0,"CDI Corporation"},
	{0,"Cerner"},
	{0,"C. H. Robinson Worldwide"},
	{0,"Chem-Dry"},
	{0,"Chevron Corporation"},
	{0,"ChexSystems"},
	{0,"Chicago Bridge & Iron Company"},
	{0,"Chugach Alaska Corporation"},
	{0,"Chrysler"},
	{0,"CIGNA"},
	{0,"Cisco Systems"},
	{0,"Citigroup"},
	{0,"Citrix Systems"},
	{0,"CKE Restaurants"},
	{0,"Clear Channel Communications"},
	{0,"CNA Financial"},
	{0,"CNET"},
	{0,"The Coca-Cola Company"},
	{0,"Cogent Communications"},
	{0,"Cognizant Technology Solutions"},
	{0,"Cole Haan"},
	{0,"Colgate-Palmolive"},
	{0,"Colt Defense"},
	{0,"Colt's Manufacturing Company"},
	{0,"Columbia Pictures"},
	{0,"Columbia Sussex"},
	{0,"Comcast"},
	{0,"Comodo"},
	{0,"ConocoPhillips"},
	{0,"Conseco"},
	{0,"Control Data Corporation (CDC)"},
	{0,"Convergys"},
	{0,"Converse"},
	{0,"CoolTouch Monitors"},
	{0,"Copeland's"},
	{0,"Corning Inc."},
	{0,"Corsair Memory"},
	{0,"Costco"},
	{0,"Coventry Health Care"},
	{0,"Cray"},
	{0,"Crazy Eddie"},
	{0,"Crowley Maritime"},
	{0,"CVS PharmacyDanaher"},
	{0,"Darden Restaurants"},
	{0,"DaVita"},
	{0,"DC Comics"},
	{0,"DC Shoes"},
	{0,"Dean Foods"},
	{0,"Deere & Company"},
	{0,"Del Monte Foods"},
	{0,"Dell"},
	{0,"Delphi"},
	{0,"Delta Air Lines"},
	{0,"Devon Energy"},
	{0,"DEX One"},
	{0,"Dick's Sporting Goods"},
	{0,"DiC Entertainment"},
	{0,"Diebold"},
	{0,"Digi-Key"},
	{0,"Dillard's"},
	{0,"DineEquity"},
	{0,"Dippin' Dots"},
	{0,"DirecTV"},
	{0,"Discover Financial"},
	{0,"Discovery Communications"},
	{0,"Dish Network"},
	{0,"The Walt Disney Company"},
	{0,"DivX, Inc."},
	{0,"Djarum"},
	{0,"Doculabs"},
	{0,"Dole Food Company"},
	{0,"Dollar General"},
	{0,"Dollar Tree"},
	{0,"Dominion Resources"},
	{0,"Domtar"},
	{0,"Dover Corporation"},
	{0,"Dow Chemical Company"},
	{0,"Dow Jones & Company"},
	{0,"Dr Pepper Snapple Group"},
	{0,"Dresser Industries"},
	{0,"DRS Technologies"},
	{0,"DST Systems"},
	{0,"DTE Energy"},
	{0,"Duke Energy"},
	{0,"Dun & Bradstreet"},
	{0,"DuPont (E.I. du Pont de Nemours)"},
	{0,"DynCorp"},
	{0,"DynegyEastman Chemical Company"},
	{0,"Eastman Kodak"},
	{0,"eBay"},
	{0,"Ecolab"},
	{0,"Eddie Bauer"},
	{0,"El Paso Corp."},
	{0,"Electronic Arts"},
	{0,"Electronic Data Systems"},
	{0,"Eli Lilly and Company"},
	{0,"Elizabeth Arden"},
	{0,"EMC Corporation"},
	{0,"Emcor"},
	{0,"Emerson Electric Company"},
	{0,"Emerson Radio"},
	{0,"Energizer Holdings"},
	{0,"Enterasys Networks"},
	{0,"Entergy"},
	{0,"Enterprise GP Holdings"},
	{0,"Equifax"},
	{0,"Erie Insurance Group"},
	{0,"Esselte"},
	{0,"Estée Lauder Companies"},
	{0,"Eureka"},
	{0,"Exelon"},
	{0,"Expeditors International"},
	{0,"Express Scripts"},
	{0,"ExxonMobilFabrik Inc."},
	{0,"Facebook"},
	{0,"Fairchild Semiconductor"},
	{0,"Fannie Mae (Federal National Mortgage Association)"},
	{0,"FedEx"},
	{0,"Fender Musical Instruments Corporation"},
	{0,"Fidelity Investments"},
	{0,"FileMaker Inc., formerly Claris Corp."},
	{0,"Firestone Tire and Rubber Company"},
	{0,"First Hawaiian Bank"},
	{0,"Fiserv"},
	{0,"Fisher Electronics"},
	{0,"Fisker Automotive"},
	{0,"Fluor Corporation"},
	{0,"Ford Motor Company"},
	{0,"Forum Communications"},
	{0,"Fox Entertainment Group"},
	{0,"Frasca International"},
	{0,"Fred Meyer"},
	{0,"Freddie Mac (Federal Home Loan Mortgage Corporation)"},
	{0,"FreeWave Technologies"},
	{0,"Fresh & Easy"},
	{0,"Frontier Airlines"},
	{0,"Fruit of the LoomGap"},
	{0,"Garmin"},
	{0,"Gartner"},
	{0,"Gateway, Inc."},
	{0,"Gatorade"},
	{0,"GCI"},
	{0,"GEICO"},
	{0,"Gemini Sound Products"},
	{0,"Generac Power Systems"},
	{0,"General Dynamics"},
	{0,"General Dynamics Electric Boat"},
	{0,"General Electric"},
	{0,"GE Consumer & Industrial"},
	{0,"General Mills"},
	{0,"General Motors"},
	{0,"Gentiva Health Services"},
	{0,"Georgia-Pacific"},
	{0,"GHD Group"},
	{0,"Giant Food"},
	{0,"Gibson Guitar Corporation"},
	{0,"Gillette"},
	{0,"Global Insight"},
	{0,"Go Daddy"},
	{0,"Goldman Sachs"},
	{0,"Goodrich Corporation"},
	{0,"Goodyear Tire and Rubber Company"},
	{0,"Google"},
	{0,"Ground Round"},
	{0,"Group O"},
	{0,"Growmark"},
	{0,"GTECHH&R Block"},
	{0,"Hallmark Cards"},
	{0,"Halliburton"},
	{0,"Hardee's"},
	{0,"Harley-Davidson"},
	{0,"Harman International Industries"},
	{0,"Hasbro"},
	{0,"Hastings Entertainment"},
	{0,"Hawaiian Airlines"},
	{0,"H-E-B"},
	{0,"The Hertz Corporation"},
	{0,"Hewlett-Packard"},
	{0,"Hi-Point Firearms"},
	{0,"Hilton Worldwide"},
	{0,"H. J. Heinz Company"},
	{0,"Home City Ice"},
	{0,"The Home Depot"},
	{0,"Honeywell"},
	{0,"Hornbeck Offshore Services"},
	{0,"Hot Topic"},
	{0,"Houchens Industries"},
	{0,"Houghton Mifflin Harcourt Learning Technology"},
	{0,"Houlihan's"},
	{0,"House of Deréon"},
	{0,"Human Kinetics"},
	{0,"Hunt Petroleum"},
	{0,"Hyland SoftwareIberdrola USA"},
	{0,"IBM"},
	{0,"Ideal Industries"},
	{0,"Imation"},
	{0,"Infor Global Solutions"},
	{0,"Intel"},
	{0,"Intercontinental Manufacturing Company"},
	{0,"International Game Technology (IGT)"},
	{0,"International Paper"},
	{0,"Interplay Entertainment"},
	{0,"Interstate Batteries"},
	{0,"Intuit"},
	{0,"ION Media Networks"},
	{0,"iRobot"},
	{0,"Iron Mountain Incorporated"},
	{0,"Jack in the Box"},
	{0,"Jarden"},
	{0,"J. C. Penney"},
	{0,"JetBlue Airways"},
	{0,"Jimmy John's"},
	{0,"JL Audio"},
	{0,"JN-International Medical Corporation"},
	{0,"Jones Soda"},
	{0,"Johnson & Johnson"},
	{0,"Johnson Controls"},
	{0,"Journal Communications"},
	{0,"JPMorgan ChaseKBR"},
	{0,"KFC"},
	{0,"Kellogg Company"},
	{0,"Kenexa"},
	{0,"Kenworth"},
	{0,"Kerr-McGee"},
	{0,"Kimberly-Clark"},
	{0,"Kingston Technology"},
	{0,"Klipsch Audio Technologies"},
	{0,"Kmart"},
	{0,"Koch Industries"},
	{0,"Kohler Company"},
	{0,"KPMG"},
	{0,"Kraft Foods"},
	{0,"Kroger"},
	{0,"Kurzweil Educational SystemsLaserfiche"},
	{0,"LeapFrog Enterprises"},
	{0,"Lennox International"},
	{0,"Lexmark"},
	{0,"The Liberty Corporation"},
	{0,"Liberty Mutual"},
	{0,"Limited Brands"},
	{0,"LinkedIn"},
	{0,"Liz Claiborne"},
	{0,"Lowe's"},
	{0,"L.L.Bean"},
	{0,"L&L Hawaiian Barbecue"},
	{0,"Local Matters"},
	{0,"Lockheed Martin"},
	{0,"Louisiana-Pacific"},
	{0,"Lucas Oil"},
	{0,"Lucasfilm"},
	{0,"LumencraftMagnavox"},
	{0,"Marantz"},
	{0,"Marathon Oil"},
	{0,"Marriott Corporation"},
	{0,"Mars, Incorporated"},
	{0,"Marsh & McLennan Companies"},
	{0,"Marshall Pottery"},
	{0,"Martha Stewart Living Omnimedia"},
	{0,"Martin Marietta Materials"},
	{0,"MasterCard"},
	{0,"Mattel"},
	{0,"Mauna Loa Macadamia Nut Corporation"},
	{0,"Maxtor"},
	{0,"McCormick & Company"},
	{0,"McDonald's"},
	{0,"MCI Inc."},
	{0,"McIlhenny Company"},
	{0,"Medimix International"},
	{0,"Meijer"},
	{0,"Memorex"},
	{0,"Merck & Co."},
	{0,"Mercury Marine"},
	{0,"Meritor"},
	{0,"Microsoft"},
	{0,"Midway Games"},
	{0,"Midwest Communications"},
	{0,"MIG, Inc."},
	{0,"Miller Brewing Company"},
	{0,"Miro Technologies"},
	{0,"Monsanto"},
	{0,"Morgan Stanley"},
	{0,"Motorola"},
	{0,"Mozilla Foundation"},
	{0,"MTX Audio"},
	{0,"Musco Lighting"},
	{0,"Mutual of Omaha"},
	{0,"MyspaceNabisco"},
	{0,"Nalge Nunc International"},
	{0,"National Railway Equipment Company"},
	{0,"Nationwide Mutual Insurance Company"},
	{0,"NBCUniversal"},
	{0,"NCR Corporation"},
	{0,"NetApp"},
	{0,"Netcordia"},
	{0,"NetDNA"},
	{0,"Netflix"},
	{0,"Netgear"},
	{0,"NetZero"},
	{0,"New Balance"},
	{0,"New Era Tickets"},
	{0,"News Corporation"},
	{0,"Nike, Inc."},
	{0,"Nordstrom"},
	{0,"Northrop Grumman"},
	{0,"Northwest Airlines"},
	{0,"Novell"},
	{0,"Novellus Systems"},
	{0,"Numark Industries"},
	{0,"NvidiaOberweis Dairy"},
	{0,"Ocean Spray"},
	{0,"OCZ Technology"},
	{0,"Office Depot"},
	{0,"OfficeMax"},
	{0,"Olan Mills"},
	{0,"The Omni Group"},
	{0,"Omnicare"},
	{0,"ONEOK"},
	{0,"Onvia"},
	{0,"Open Interface North America"},
	{0,"OpenMarket Inc."},
	{0,"Opower"},
	{0,"Oracle Corporation"},
	{0,"Oracle Financial Services Software"},
	{0,"Oreck Corporation"},
	{0,"O'Reilly Auto Parts"},
	{0,"OSI Restaurant Partners"},
	{0,"Overcast Media"},
	{0,"Owens Corning"},
	{0,"Owens-IllinoisPACCAR"},
	{0,"Pacific Gas and Electric Company (PG&E)"},
	{0,"Pantone"},
	{0,"Papa John's Pizza"},
	{0,"Paramount Pictures"},
	{0,"Paxton Media Group"},
	{0,"Payless ShoeSource"},
	{0,"PC Power and Cooling"},
	{0,"PepsiCo"},
	{0,"Perdue Farms"},
	{0,"Peterbilt"},
	{0,"Pier 1 Imports"},
	{0,"Pilgrim's Pride"},
	{0,"Pinnacle Systems"},
	{0,"Pizza Hut"},
	{0,"Pfizer"},
	{0,"Plochman's"},
	{0,"Polaroid Corporation"},
	{0,"Polaris Industries"},
	{0,"Popeyes Chicken & Biscuits"},
	{0,"Precision Castparts Corp."},
	{0,"PricewaterhouseCoopers"},
	{0,"Principal Financial Group"},
	{0,"Procter & Gamble"},
	{0,"Progressive Corporation"},
	{0,"PublixQCR Holdings"},
	{0,"Qpass"},
	{0,"Qualcomm"},
	{0,"Quanta Services"},
	{0,"Quantrix"},
	{0,"Quest Software"},
	{0,"Quincy Newspapers"},
	{0,"QVC"},
	{0,"Qwest"},
	{0,"Quiznos"},
	{0,"RadioShack"},
	{0,"Raytheon"},
	{0,"Rayovac"},
	{0,"RCA"},
	{0,"Red Hat"},
	{0,"Red River Broadcasting"},
	{0,"Rent-a-Wreck"},
	{0,"Renys"},
	{0,"Regis Corporation"},
	{0,"Respironics"},
	{0,"Rite Aid"},
	{0,"Rockford Fosgate"},
	{0,"Rockstar Games"},
	{0,"Rockwell Automation"},
	{0,"Rockwell Collins"},
	{0,"Rollins Inc."},
	{0,"Royal Caribbean International"},
	{0,"RR Donnelley"},
	{0,"Russell Investments"},
	{0,"Russell Stover Candies"},
	{0,"RyderS3 Graphics"},
	{0,"Safeco"},
	{0,"Safeway Inc."},
	{0,"Salem Communications"},
	{0,"SanDisk"},
	{0,"Sauer-Danfoss"},
	{0,"Schoep's Ice Cream"},
	{0,"SAIC"},
	{0,"Seagate Technology"},
	{0,"Sears"},
	{0,"Seattle's Best Coffee"},
	{0,"Service Corporation International (SCI)"},
	{0,"Sequoia Voting Systems"},
	{0,"SFN Group"},
	{0,"Shirokiya"},
	{0,"Shure"},
	{0,"Six Flags"},
	{0,"Silicon Graphics"},
	{0,"Silicon Image"},
	{0,"SkyWest Airlines"},
	{0,"Snap-on"},
	{0,"Sonic Solutions"},
	{0,"Sony Pictures Entertainment"},
	{0,"Southern California Edison"},
	{0,"Southwest Airlines"},
	{0,"Soyo Group"},
	{0,"Spanx"},
	{0,"Springfield Armory, Inc."},
	{0,"Sprint Nextel"},
	{0,"Spectrum Brands"},
	{0,"Staples Inc."},
	{0,"Starbucks"},
	{0,"Starz"},
	{0,"State Street Corporation"},
	{0,"Steinway & Sons"},
	{0,"Sterling Ledet & Associates"},
	{0,"Stewart-Warner"},
	{0,"Storage Technology Corporation"},
	{0,"STX"},
	{0,"Subway"},
	{0,"Sunny Delight Beverages"},
	{0,"Sunoco"},
	{0,"SuperValu"},
	{0,"Sur La Table"},
	{0,"Syntel"},
	{0,"SymantecTake-Two Interactive"},
	{0,"Tanadgusix Corporation"},
	{0,"Target Corporation"},
	{0,"Tempur-Pedic"},
	{0,"Tesla Motors"},
	{0,"Tesoro"},
	{0,"Testor Corporation"},
	{0,"Texas Instruments"},
	{0,"Textron"},
	{0,"The Library Corporation (TLC)"},
	{0,"THQ"},
	{0,"Time Warner Cable"},
	{0,"Towers Perrin"},
	{0,"TransDigm Group"},
	{0,"Trinity Industries"},
	{0,"Tropicana Products"},
	{0,"Trianz"},
	{0,"Triumph Group"},
	{0,"Tully's Coffee"},
	{0,"Tupperware Brands"},
	{0,"TwitterUbu Productions"},
	{0,"Ultimate Software"},
	{0,"Under Armour"},
	{0,"Union Pacific Railroad"},
	{0,"Unisys"},
	{0,"United Airlines"},
	{0,"United Parcel Service (UPS)"},
	{0,"United Technologies Corporation"},
	{0,"Universal Studios"},
	{0,"US Airways"},
	{0,"USAA (United Services Automobile Association)"},
	{0,"USRobotics"},
	{0,"U.S. Cellular"},
	{0,"U.S. Steel"},
	{0,"UTStarcom"},
	{0,"UwajimayaValero Energy Corporation"},
	{0,"Vantec"},
	{0,"The Vanguard Group"},
	{0,"Vaughan & Bushnell Manufacturing"},
	{0,"VECO Corporation"},
	{0,"VF Corporation"},
	{0,"Lee"},
	{0,"Venus Swimwear"},
	{0,"Verbatim Corporation"},
	{0,"Vertex Pharmaceuticals"},
	{0,"Victoria's Secret"},
	{0,"ViewSonic"},
	{0,"VIZ Media"},
	{0,"Vizio"},
	{0,"Vectren"},
	{0,"Verizon Communications"},
	{0,"Verizon Wireless"},
	{0,"Viacom"},
	{0,"Visa Inc."},
	{0,"Vivitar"},
	{0,"VMware"},
	{0,"Vocera Communications"},
	{0,"Vulcan CorporationWahl Clipper"},
	{0,"Walgreens"},
	{0,"Walmart"},
	{0,"The Walt Disney Company"},
	{0,"Warner Bros."},
	{0,"Washburn Guitars"},
	{0,"Watco Companies"},
	{0,"W. C. Bradley Co."},
	{0,"The Weinstein Company"},
	{0,"Welch's"},
	{0,"WellPoint"},
	{0,"Wells Fargo"},
	{0,"Wendy's Company"},
	{0,"Werner Enterprises"},
	{0,"Westat"},
	{0,"West Liberty Foods"},
	{0,"Western Digital"},
	{0,"Westinghouse Digital LLC"},
	{0,"Whataburger"},
	{0,"Wheeling-Pittsburgh Steel"},
	{0,"Whirlpool Corporation"},
	{0,"Whole Foods Market"},
	{0,"Winnebago Industries"},
	{0,"Wizards of the Coast"},
	{0,"W. L. Gore and Associates"},
	{0,"World Airways"},
	{0,"World Financial Group"},
	{0,"W. R. Grace and Company"},
	{0,"WWE"},
	{0,"Wynn ResortsXerox"},
	{0,"Xilinx"},
	{0,"XIM, Inc."},
	{0,"XPAC"},
	{0,"XPLANE"}
};

const int cust_cnt=sizeof(customers)/sizeof(customers[0]);

bool TestCustomer(int i, const String& text);
// here we only make use of the text part of the hint
// we further assume that query candidates items take long time,
// as if we are querying from a remote database 
//
//
int CustomerPopUp::PrepareData(const PopUpHint& hint)
{
	int cnt=0;
	list.Clear();
	for(int i=0; i<cust_cnt; ++i)
	{
		if(TestCustomer(i, hint.text))
		{
			list.Add(customers[i].id, customers[i].number(), customers[i].name);
			++cnt;
		}
		if(i%150==0)
		{
			Sleep(100); // fake a slow process.
			Ctrl::ProcessEvent();
			if(IsCurHintObselete())
				return cnt;
		}
	}
	if(cnt>0 && !list.IsCursor())
		list.SetCursor(0);
	return cnt;
}


bool TestCustomer(int i, const String& text)
{
	return strnicmp(customers[i].number(), text, text.GetLength())==0 ||
	 	String(customers[i].name).Find(text)!=-1;
}

void CustomerPopUp::GetSizes(Size& preferred, Size& minimum)
{
	preferred.cx=800;
	preferred.cy=600;
	
	minimum.cx=300;
	minimum.cy=200;
}


void InitCustomers()
{
	for(int i=0; i<cust_cnt; ++i)
	{
		Customer& c=customers[i];
		c.id=i+1;
	}
}

Value CustConv::Format(const Value& q) const
{
	//LOG(String().Cat()<<"Format() with q="<<q);
	if(IsNull(q) || !q.Is<int>())
		return String();
	int i=q;
	--i;
	if(i<0 || i>=cust_cnt)
		return String();
	Customer& c=customers[i];
	return String().Cat()<<'['<<c.number()<<"] "<<c.name;
}

Value CustConv::Scan(const Value& text) const
{
	LOG(String().Cat()<<"Scan() with text="<<text);
	String s=text;
	if(s.GetCount()<3 || s[0]!='[')
		return -1;
	int j=s.Find("]",2);
	if(j<0)
		return -1;
	--j;
	j=atoi(s.Mid(1,j))-5000;
	return j>0 && j<=cust_cnt ? j : -1;

}
