#include "PopEasy.h"

NAMESPACE_UPP

#ifdef COMPACT_WITHPOPUP
namespace{
// return 0 - key processed, no further action required
//        1 - forword to parent
//        2 - to Pop;
//        3 - to Unpop;
int K(Ex& ex, dword key, int count)
{
	switch(key)
	{
	case K_ALT_DOWN:
	case K_ALT_UP:
		return ex.open? 3: 2;
	// forward interested keys to the PopUp
	// if it's open
	case K_UP:		case K_DOWN:
	case K_PAGEUP:	case K_PAGEDOWN:
	case K_ENTER:	case K_ESCAPE:	
	case K_TAB:
		if(ex.open && ex.ipop->DoKey(key, count))
			return 0;
	}
	return 1;
}

}

#endif

// a default implementation
void PopMan::GetSizes(Size& preferred, Size& minimum)
{
	preferred=GetScreenSize()/2;
	minimum=preferred/4;
}

// Pop up or repop up.
//
void PopMan::PopUp(Rect& r)
{
	Ctrl& c=*GetCtrl();
	c.SetRect(r);
	if(!c.IsOpen())
		c.PopUp(main, true, false, true, true);
}

void PopMan::AddHint(const PopUpHint& hint)
{
//	LOG(String().Cat()<<"Before AddHint(), Hint Count:"<<(int)hint_count<<", cur index"<<cur_hint_index
//	    <<"hints[0]={"<<hints[0].reason<<","<<hints[0].text<<"},hints[1]={"
//	    <<hints[1].reason<<","<<hints[1].text<<"}"
//	); 
	
	switch(hint_count)
	{
	case 0:
		hints[0]=hint;
		cur_hint_index=0;
		++hint_count;
		// not currently working on any hints, so start it
		//
		PostCallback(THISBACK(ProcessHint));
		break;
	case 1:
		++hint_count;
		// deliberate fall-through		
	case 2:
		hints[cur_hint_index==0?1:0]=hint;
		break;
	}
}

// single thread approach
// supplied PrepareData() should call Ctrl::ProcessEvents periodically to accept subsequent user inputs
//
// must guarantee only one instance of ProcessHint will actually be running.
// at its finish, if it detects there are more hint(s) waiting to be processed, it should call 
// PostCallback with itself as callback so that another round of ProcessHint will start after the
// current exits.
// 
void PopMan::ProcessHint()
{
	ASSERT( unsigned(cur_hint_index)<2 && unsigned(hint_count-1)<2);
	PopUpHint& hint=hints[cur_hint_index];
	
	if(hint.reason!=HR_SHOW && !IsOpen() && !GetAutoPopUp()) // add auto_popup in future.
	{
		Ctrl::ProcessEvent(); // AddHint() may be called because of this line.
		if(--hint_count==1)
		{
			cur_hint_index=cur_hint_index==1?0:1;// next hint to be processed
			PostCallback(THISBACK(ProcessHint));
		}
		return;
	}

	int rcnt=PrepareData(hints[cur_hint_index]);
	
	Ctrl::ProcessEvent();
	
	if(--hint_count==1) // means the current one has been cancelled.
	{
		//--hint_count;
		cur_hint_index=cur_hint_index==1?0:1;
		PostCallback(THISBACK(ProcessHint));
	}else{
#ifdef _DEBUG
		if(hint_count!=0)
		{
			LOG("Error: PopMan::ProcessHint()-hint_count expected to be 0 but not");
		}
#endif
		
		switch(rcnt)
		{
		case 0:
			GetCtrl()->Close();
			return;
		case 1:
			DUMP(GetAutoSelect());
			if(GetAutoSelect())
			{
				Select();
				return;
			}
			
		}
		// data preparation is ready.
		// now negotiation location.
		Rect rt;
		if(WhenSizeNegotiate)
			WhenSizeNegotiate(rt);
		else{
			
			Size prefer, min, screen_size;
			GetSizes(prefer, min);
			screen_size=GetScreenSize();
			Rect outer=RectC(0,0,screen_size.cx, screen_size.cy);
			Rect inner=main->GetScreenRect();
			// test if bottom can accomodate the popup at its preferred size
			if(outer.bottom-inner.bottom>=prefer.cy )
			{
				rt.left=inner.left;
				rt.right=rt.left+prefer.cx;
				rt.top=inner.bottom;
				rt.bottom=rt.top+prefer.cy;
				if(rt.right>outer.right)
				{
					rt.right=outer.right;
					rt.left=rt.right-prefer.cx;
					if(rt.left<outer.left)
						rt.left=outer.left;
				}
			}else if(inner.top-outer.top>=prefer.cy)
			{
				rt.left=inner.left;
				rt.right=rt.left+prefer.cx;
				rt.bottom=inner.top;
				rt.top=rt.bottom-prefer.cy;
				if(rt.right>outer.right)
				{
					rt.right=outer.right;
					rt.left=rt.right-prefer.cx;
					if(rt.left<outer.left)
						rt.left=outer.left;
				}
			}else if(outer.right-inner.right>=prefer.cx)
			{
				rt.left=inner.right;
				rt.right=rt.left+prefer.cx;
				rt.top=inner.top;
				rt.bottom=rt.top+prefer.cy;
				if(rt.bottom>outer.bottom)
				{
					rt.bottom=outer.bottom;
					rt.top=rt.bottom-prefer.cy;
					if(rt.top<outer.top)
						rt.top=outer.top;
				}
			}else if(inner.left-outer.left>=prefer.cx)
			{
				rt.right=inner.left;
				rt.left=rt.right-prefer.cx;
				rt.top=inner.top;
				rt.bottom=rt.top+prefer.cy;
				if(rt.bottom>outer.bottom)
				{
					rt.bottom=outer.bottom;
					rt.top=rt.bottom-prefer.cy;
					if(rt.top<outer.top)
						rt.top=outer.top;
				}
			}else{ // take top or bottom whichever has larger area.
				if(inner.top-outer.top>outer.bottom-inner.bottom)
				{
					rt.top=outer.top;
					rt.bottom=inner.top;
				}else{
					rt.top=inner.bottom;
					rt.bottom=outer.bottom;
				}
				rt.left=inner.left;
				rt.right=rt.left+prefer.cx;
				if(rt.right>outer.right)
				{
					rt.right=outer.right;
					rt.left=rt.right-prefer.cx;
					if(rt.left<outer.left)
						rt.left=outer.left;
				}
				
			}
		}
		this->PopUp(rt);
	}
}

TreeListPopUp::TreeListPopUp()
	:fake_focus_ctrl(&list)
{
	Horz(tree, list);
	tree.NoWantFocus();
	list.NoWantFocus();
	
	RefreshTree();
	
	list.EvenRowColor();
	list.WhenLeftDouble=THISBACK(ListLeftDouble);
	list.WhenLeftClick=THISBACK(ListWhenLeft);
	
	tree.WhenLeftClick=THISBACK(TreeWhenLeft);
	
	SetViewStyle(VS_TreeList);
}

TreeListPopUp& TreeListPopUp::SetViewStyle(TreeListPopUp::ViewStyle style)
{
	view_style=style;
	fake_focus_ctrl=&list;
	switch(style)
	{
	case VS_TreeOnly:
		Zoom(0);
		fake_focus_ctrl=&tree;
		break;
	case VS_ListOnly:
		Zoom(1);
		break;
	default:
		Zoom(-1);
		SetPos(3000);
	}
	return *this;
}


bool TreeListPopUp::DoKey(dword key, int repcount)
{
	switch(key)
	{
	case K_TAB: // switch which children is getting fake focus.
		if(view_style==VS_TreeList)
		{
			FakeShiftFocus();
			return true;
		}
		return false;
		//break;
	case K_ENTER:
		if(list.GetCursor()>=0)
		{
			if(Select())
				GetCtrl()->Close();
		}
		return true; // eat Enter key even if no selection is made
	case K_ESCAPE:
		if(main)
			main->SetData(Null);
		return true;
	case K_UP:
	case K_DOWN:
	case K_PAGEUP:
	case K_PAGEDOWN:
		if(fake_focus_ctrl==&list && list.GetCursor()<0)
		{
			list.SetCursor(key==K_UP||key==K_PAGEUP?list.GetCount()-1:0);
			if(key!=K_PAGEUP && key!=K_PAGEDOWN)
				return true;			
		}
		if(fake_focus_ctrl->Key(key, repcount))
			return true;
		break;
	}
		
	return false;
}

void TreeListPopUp::FakeShiftFocus()
{
	// here we do it the easier way cause there are only two children
	fake_focus_ctrl= fake_focus_ctrl==&tree?(Ctrl*)&list:(Ctrl*)&tree;
}

void TreeListPopUp::TreeWhenLeft()
{
	fake_focus_ctrl=&tree;
}

void TreeListPopUp::ListWhenLeft()
{
	fake_focus_ctrl=&list;
}

void TreeListPopUp::ListLeftDouble()
{
	fake_focus_ctrl=&list;
	DoKey(K_ENTER, 1);
}


END_UPP_NAMESPACE
