#ifndef _PopEasy_PopEasy_h_
#define _PopEasy_PopEasy_h_

#include <CtrlLib/CtrlLib.h>

NAMESPACE_UPP


// user or main ask to popup, eg by keyboard/mouse/pseudoKey;
//
// content negotiation
// main communicates its content, caret location, selection etc to PopMan (how?)
// PopMan prepare content to be shown accordingly. Many interesting things can happen here
// for example, if there are nothing to be shown, it may asked not to be PopUp'd; if there's
// only one candidate, it may do the auto selection; etc
//
// if both agrees to the PopUP action, then size/location negotiation starts
// 
// PopMan propose a location and size and communicated to main;
// main authorize or modify the proposal and give it back to popup
// PopMan do the popup.
//
// or both can be combined?
//
// interface that a PopUp is expected to implement/provide
//


struct PopMan
{
	enum HintReason
	{
		HR_SHOW,
		HR_CLOSE,
		HR_CHANGED		
	};
	
	struct PopUpHint
	{
		int reason;  // 1: explicit request to show; 2: explicit request to close
		             // 3: text/cursor location, etc, changed.
		String text;
		int     sel_start; // if sel_start==sel_end, that's the caret position.
		int     sel_end;
		// mouse location omitted for now
	};
	
	

	virtual bool DoKey(dword key, int repcount){ return false;}
	
	virtual int PrepareData(const PopUpHint& hint){ return 0; }
	virtual void GetSizes(Size& preferred, Size& minimum);
	virtual bool Select(){ return true; }
	
	virtual void SetAutoPopUp(bool popup=true){ autopopup=popup;}
	virtual bool GetAutoPopUp()const{ return autopopup; }
	virtual void SetAutoComplete(bool v=true){ autocomplete=v;}
	virtual bool GetAutoComplete()const{ return autocomplete; }
	virtual void SetAutoSelect(bool v=true){ autoselect=v;}
	virtual bool GetAutoSelect()const{ return autoselect; }
	
	PopMan():main(NULL), _dummy(0){}

	Ctrl* GetCtrl(){
		struct _P: PopMan, Ctrl
		{
		};
		return static_cast<Ctrl*>(reinterpret_cast<_P*>(this)); 
	}
	const   Ctrl* GetCtrl()const{ 
		return const_cast<const Ctrl*>(
			const_cast<PopMan&>(*this).GetCtrl()
		);
	}
	void SetMainCtrl(Ctrl* _main){ main=_main; }
	Ctrl* GetMainCtrl(){ return main; }
	const Ctrl* GetMainCtrl()const{ return main; }
	bool IsOpen()const{ return GetCtrl()->IsOpen(); }
	

	void PopUp(Rect& r);

	void AddHint(const PopUpHint& hint);
	void ProcessHint();

	bool IsCurHintObselete()const{ return hint_count>1; }
protected:
	Ctrl* main;
	Callback1<Rect&> WhenSizeNegotiate;
	PopUpHint hints[2];
	union{
		struct{
			bool  autopopup:1;
			bool  autocomplete:1;
			bool  autoselect:1;
			int8  cur_hint_index;
			volatile int8  hint_count;
		};
		int32 _dummy;
	};
	typedef PopMan CLASSNAME;
	
};

class TreeListPopUp: public PopMan, public Splitter
{
public:
	enum ViewStyle{VS_TreeOnly, VS_ListOnly, VS_TreeList};

	TreeListPopUp();
	
	TreeListPopUp& SetViewStyle(ViewStyle style);	

	virtual bool DoKey(dword key, int repcount);
	virtual bool Select(){ 
		if(main && list.IsCursor())
		{
			main->SetData(list.Get(0));
			return true;
		}
		return false;
	}
	virtual void RefreshTree(){} // newly added
	virtual void RefreshList(){} // newly added

	typedef TreeListPopUp CLASSNAME;
protected:
	ArrayCtrl  list;
	TreeCtrl   tree;
	Ctrl*      fake_focus_ctrl;
	String     hint_text;
	ViewStyle  view_style; 
	
	
	void FakeShiftFocus();
	
	void TreeWhenLeft();
	void ListLeftDouble();
	void ListWhenLeft();
};

//
//namespace {
//
//struct Ex{
//	PopMan * ipop;
//	int      inpopup;
//	bool     open;
//	Ex():ipop(NULL), inpopup(false),open(false){}
//};
//	
////int K(Ex& ex, dword key, int count);
//	
//}//eons

//#define COMPACT_WITHPOPUP
//#ifndef COMPACT_WITHPOPUP

template <class T>class WithPopUp : public T//, protected Ex
{
public:
	typedef WithPopUp<T> _Self;
	typedef T			 _Parent;
	
	WithPopUp():ipop(NULL){		
	}
	

	virtual bool Key(dword key, int count);
	
	virtual void SetData(const Value& v);
	virtual void GetPopupHint(PopMan::PopUpHint& hint);

	PopMan* SetIPopUp(PopMan* _new);
	
	bool IsPopUpOpen(){ return ipop && ipop->GetCtrl()->IsOpen(); }
protected:
	void Unpop()
	{
		if(ipop)
			ipop->GetCtrl()->Close();
	}		
		
	virtual void LostFocus(){
	 	Unpop();
	 	this->_Parent::LostFocus(); 
	 }	
	 
	 virtual void State(int reason)
	 {
	     if(reason==Ctrl::StateReason::POSITION)//consider to relocate popup instead!
	         Unpop();
	     else if(!this->IsVisible())
	         Unpop();
	     this->_Parent::State(reason);
	 }
	
	//void PopWhenClose(Value v);
protected:
	PopMan * ipop;
		
	typedef WithPopUp<T> CLASSNAME;
};

template <class T>
bool WithPopUp<T>::Key(dword key, int count)
{
	if(ipop)
	{
		PopMan::PopUpHint hint;
		switch(key)
		{
		case K_ALT_DOWN:
		case K_ALT_UP:
			if(IsPopUpOpen())
			{
				Unpop();

			}else
			{
				hint.reason=PopMan::HR_SHOW;
				this->GetPopupHint(hint);
				ipop->AddHint(hint);
				ipop->SetMainCtrl(this);
				return true;
			}
			break;
		// forward interested keys to the PopUp
		// if it's open
		case K_UP:		case K_DOWN:
		case K_PAGEUP:	case K_PAGEDOWN:
		case K_ENTER:	case K_ESCAPE:	
		case K_TAB:
			if( IsPopUpOpen() && ipop->DoKey(key, count))
				return true;
			//break;
		}
		if(this->T::Key(key, count))
		{
			hint.reason=PopMan::HR_CHANGED;
			GetPopupHint(hint);
			if(IsPopUpOpen() || ipop->GetAutoPopUp())
			{
				ipop->AddHint(hint);
				ipop->SetMainCtrl(this);
			}
			return true;
		}
		return false;
	}else
		return this->T::Key(key, count);
}



template <class T>
PopMan* WithPopUp<T>::SetIPopUp(PopMan* _new)
{
	PopMan *old=ipop;
	if(old)
	{
		old->SetMainCtrl(NULL);
		Unpop();
	}
	ipop=_new;
	ipop->SetMainCtrl(this);
	//_new->WhenClose=THISBACK(PopWhenClose);
	return old;
}

template <class T>
void WithPopUp<T>::SetData(const Value& v)
{
	if( IsPopUpOpen() )
	{
		if(!IsNull(v))
			this->_Parent::SetData(v);
		Unpop();			
	}else{
		this->_Parent::SetData(v);
	}
	
}

template <class T>
void WithPopUp<T>::GetPopupHint(PopMan::PopUpHint& hint)
{
	hint.text.Clear();
	EditField* e=dynamic_cast<EditField*>(this);
	if(e)
	{
		hint.text<<e->GetText();
	}
}

END_UPP_NAMESPACE

#endif
