#include "PopEasy.h"

NAMESPACE_UPP

//#ifdef COMPACT_WITHPOPUP
//namespace{
//// return 0 - key processed, no further action required
////        1 - forword to parent
////        2 - to Pop;
////        3 - to Unpop;
//int K(Ex& ex, dword key, int count)
//{
//	switch(key)
//	{
//	case K_ALT_DOWN:
//	case K_ALT_UP:
//		return ex.open? 3: 2;
//	// forward interested keys to the PopUp
//	// if it's open
//	case K_UP:		case K_DOWN:
//	case K_PAGEUP:	case K_PAGEDOWN:
//	case K_ENTER:	case K_ESCAPE:	
//	case K_TAB:
//		if(ex.open && ex.ipop->DoKey(key, count))
//			return 0;
//	}
//	return 1;
//}
//
//}

//#endif

// a default implementation
Size PopMan::GetPreferredSize()const
{
	return GetScreenSize()/2;
}

// Pop up or repop up.
//
void PopMan::PopUp(Rect& r)
{
	Ctrl& c=*GetCtrl();
	c.SetRect(r);
	PopUp();
}

void PopMan::PopUp()
{
	Ctrl& c=*GetCtrl();
	if(!c.IsOpen())
		c.PopUp(&main->GetMain(), true, false, true, true);
}


void PopMan::AddHint(const PopUpHint& hint)
{
//	LOG(String().Cat()<<"Before AddHint(), Hint Count:"<<(int)hint_count<<", cur index"<<cur_hint_index
//	    <<"hints[0]={"<<hints[0].reason<<","<<hints[0].text<<"},hints[1]={"
//	    <<hints[1].reason<<","<<hints[1].text<<"}"
//	); 
	
	switch(hint_count)
	{
	case 0:
		hints[0]=hint;
		cur_hint_index=0;
		++hint_count;
		// not currently working on any hints, so start it
		//
		PostCallback(THISBACK(ProcessHint));
		break;
	case 1:
		++hint_count;
		// deliberate fall-through		
	case 2:
		hints[cur_hint_index==0?1:0]=hint;
		break;
	}
}

// single thread approach
// supplied PrepareData() should call Ctrl::ProcessEvents periodically to accept subsequent user inputs
//
// must guarantee only one instance of ProcessHint will actually be running.
// at its finish, if it detects there are more hint(s) waiting to be processed, it should call 
// PostCallback with itself as callback so that another round of ProcessHint will start after the
// current exits.
// 
void PopMan::ProcessHint()
{
	ASSERT( unsigned(cur_hint_index)<2 && unsigned(hint_count-1)<2);
	PopUpHint& hint=hints[cur_hint_index];
	
	if(hint.reason!=HR_SHOW && !IsOpen() && !GetAutoPopUp()) 
	{
		Ctrl::ProcessEvent(); // AddHint() may be called because of this line.
		if(--hint_count==1)
		{
			cur_hint_index=cur_hint_index==1?0:1;// next hint to be processed
			PostCallback(THISBACK(ProcessHint));
		}
		return;
	}

	String suffix;
	bool autocomplete=GetAutoComplete() && !hint.no_autocompletion;
	int rcnt=PrepareData(hints[cur_hint_index], autocomplete?&suffix:NULL);
	
	Ctrl::ProcessEvent();
	
	if(--hint_count==1) // means the current one has been cancelled.
	{
		//--hint_count;
		cur_hint_index=cur_hint_index==1?0:1;
		PostCallback(THISBACK(ProcessHint));
	}else{
#ifdef _DEBUG
		if(hint_count!=0)
		{
			LOG("Error: PopMan::ProcessHint()-hint_count expected to be 0 but not");
		}
#endif
		//DUMP(rcnt);
		switch(rcnt)
		{
		case 0:
			Unpop();
			return;
		case 1:
			if(GetAutoSelect())
			{
				Select();
				//Unpop();
				return;
			}
			
		}
		// data preparation is ready.
		// now negotiation location.
		Rect rt;
		NegotiateSizePosition(rt);
		this->PopUp(rt);
		//DUMP(autocomplete);
		DUMP(suffix);
		if(autocomplete)
		{
			main->AcceptSuffix(hint, suffix);
		}
	}
}

void PopMan::NegotiateSizePosition(Rect& rt)
{
	if(!this->GetMain())
	{
		rt=Null;
		return;
	}
	GetMain()->GetSizePosition(rt);
	if(IsNull(rt))
	{
		Size prefer, screen_size;
		prefer=GetPreferredSize();
		screen_size=GetScreenSize();
		// intended future extension. Main will provide a outer rect (not necessarily screen rect)
		// and an inner rect. That's why we have seemingly meaningless outer here.
		//
		Rect outer=RectC(0,0,screen_size.cx, screen_size.cy);
		Rect inner=main->GetMain().GetScreenRect();
		
		++outer.left; ++outer.top; --outer.right; --outer.bottom;
		--inner.left; --inner.top; ++inner.right; ++inner.bottom;
		
		// test if bottom can accomodate the popup at its preferred size
		if(outer.bottom-inner.bottom>=prefer.cy )
		{
			rt.left=inner.left;
			rt.right=rt.left+prefer.cx;
			rt.top=inner.bottom;
			rt.bottom=rt.top+prefer.cy;
			if(rt.right>outer.right)
			{
				rt.right=outer.right;
				rt.left=rt.right-prefer.cx;
				if(rt.left<outer.left)
					rt.left=outer.left;
			}
		}else if(inner.top-outer.top>=prefer.cy)
		{
			rt.left=inner.left;
			rt.right=rt.left+prefer.cx;
			rt.bottom=inner.top;
			rt.top=rt.bottom-prefer.cy;
			if(rt.right>outer.right)
			{
				rt.right=outer.right;
				rt.left=rt.right-prefer.cx;
				if(rt.left<outer.left)
					rt.left=outer.left;
			}
		}else if(outer.right-inner.right>=prefer.cx)
		{
			rt.left=inner.right;
			rt.right=rt.left+prefer.cx;
			rt.top=inner.top;
			rt.bottom=rt.top+prefer.cy;
			if(rt.bottom>outer.bottom)
			{
				rt.bottom=outer.bottom;
				rt.top=rt.bottom-prefer.cy;
				if(rt.top<outer.top)
					rt.top=outer.top;
			}
		}else if(inner.left-outer.left>=prefer.cx)
		{
			rt.right=inner.left;
			rt.left=rt.right-prefer.cx;
			rt.top=inner.top;
			rt.bottom=rt.top+prefer.cy;
			if(rt.bottom>outer.bottom)
			{
				rt.bottom=outer.bottom;
				rt.top=rt.bottom-prefer.cy;
				if(rt.top<outer.top)
					rt.top=outer.top;
			}
		}else{ // take top or bottom whichever has larger area.
			if(inner.top-outer.top>outer.bottom-inner.bottom)
			{
				rt.top=outer.top;
				rt.bottom=inner.top;
			}else{
				rt.top=inner.bottom;
				rt.bottom=outer.bottom;
			}
			rt.left=inner.left;
			rt.right=rt.left+prefer.cx;
			if(rt.right>outer.right)
			{
				rt.right=outer.right;
				rt.left=rt.right-prefer.cx;
				if(rt.left<outer.left)
					rt.left=outer.left;
			}
			
		}
	}
}

Ctrl* PopMan::GetMainCtrl()
{
	return main? (&main->GetMain()):NULL;
}


bool PopMan::DoKey(dword key, int repcount)
{
	switch(key)
	{
	case K_ENTER:
		if(Select())
		{
			Unpop();
		}
		return true;
	case K_ESCAPE:
		if(main){
			main->Cancel();
		}
		Unpop();
		return true;
	case K_UP:
	case K_DOWN:
	case K_PAGEUP:
	case K_PAGEDOWN:
		if(this->GetCtrl()->Key(key, repcount))
			return true;
	}
		
	return false;
}

PopListBase::PopListBase()
	: batch_size(200)
{
	NoWantFocus();
	EvenRowColor();
}

void   PopListBase::LeftDouble(Point p, dword keyflags)
{
	ArrayCtrl::LeftDouble(p, keyflags);;
	DoKey(K_ENTER, 1);
}

// utf-8 support needed!
static int common_prefix_length_i(const char * s1, const char * s2)
{
	///LOG(String().Cat()<<"common_prefix_length_i:: s1="<<s1<<", s2="<<s2);
	int i;
	for(i=0; s1[i]!='\0' && ToUpper(s1[i])==ToUpper(s2[i]); ++i)
		;
	//DUMP(i);
	return i;
}

int PopListBase::PrepareData(const PopUpHint& hint, String * suffix)
{
	int rcnt=GetRowCount();
	int ccnt=GetColumnCount();
	String htext=ToUpper(hint.text);
	
	bool nosuffix=suffix==NULL;
	String tmp_suffix;
	Clear();
	
	for(int i=0; i<rcnt; ++i)
	{
		for(int j=0; j<ccnt; ++j)
		{
			String s=String().Cat()<<GetCellAt(i,j);
			//String s=ToUpper(String().Cat()<<GetCellAt(i, j));
			int p=ToUpper(s).Find(htext);
			if(p!=-1)
			{
				Vector<Value> v;
				for(j=0; j<ccnt; ++j)
					v.Add(GetCellAt(i,j)); // more complicated logic needed to cope with multiple occurances in single line
				Add(v);
				
				// calculate common suffix;
				if(!nosuffix)
				{
					
					if(tmp_suffix.IsEmpty())
					{
						tmp_suffix=s.Mid(p+htext.GetLength());
					}else
					{
						
						int len=common_prefix_length_i(tmp_suffix, ((const char*)s)+p+htext.GetLength());
						if(len==0)
							nosuffix=true;
						else
							tmp_suffix=tmp_suffix.Left(len);
					}
				}
				
				break;
			}
		}
		if(i%batch_size==0)
		{
			Ctrl::ProcessEvent();
			if(IsCurHintObselete())
				break;
		}
	}
	if(rcnt!=0)
		SetCursor(0);
	if(!nosuffix)
		*suffix=tmp_suffix;
	return GetCount();
}

bool PopListBase::Select()
{
	if(IsCursor())
	{
		if(this->GetColumnCount()==1)
			main->AcceptData(Get(0), Get(0));
		else
			main->AcceptData(Get(0), Get(1));
	}
	return true;
}


#define E__Addv(I)    v.At(I-1)=p##I
#define E__AddF(I) \
void PopList::Add(__List##I(E__Value)) { \
	Vector<Value>& v=data.Add();\
	__List##I(E__Addv); \
}
__Expand(E__AddF)


TreeListPopUp::TreeListPopUp()
	:fake_focus_ctrl(&list)
{
	Horz(tree, list);
	tree.NoWantFocus();
	list.NoWantFocus();
	
	RefreshTree();
	
	list.EvenRowColor();
	list.WhenLeftDouble=THISBACK(ListLeftDouble);
	list.WhenLeftClick=THISBACK(ListWhenLeft);
	
	tree.WhenLeftClick=THISBACK(TreeWhenLeft);
	
	SetViewStyle(VS_TreeList);
}

bool TreeListPopUp::DoKey(dword key, int repcount)
{
	switch(key)
	{
	case K_TAB:
		if(view_style==VS_TreeList)
		{
			FakeShiftFocus();
			return true;
		}
		return false;
	case K_UP:
	case K_DOWN:
	case K_PAGEUP:
	case K_PAGEDOWN:
		if(fake_focus_ctrl==&list && list.GetCursor()<0)
		{
			list.SetCursor(key==K_UP||key==K_PAGEUP?list.GetCount()-1:0);
			if(key!=K_PAGEUP && key!=K_PAGEDOWN)
				return true;			
		}
		if(fake_focus_ctrl->Key(key, repcount))
			return true;
		break;
	}
	return _Parent::DoKey(key, repcount);
}

TreeListPopUp& TreeListPopUp::SetViewStyle(TreeListPopUp::ViewStyle style)
{
	view_style=style;
	fake_focus_ctrl=&list;
	switch(style)
	{
	case VS_TreeOnly:
		Zoom(0);
		fake_focus_ctrl=&tree;
		break;
	case VS_ListOnly:
		Zoom(1);
		break;
	default:
		Zoom(-1);
		SetPos(3000);
	}
	return *this;
}

bool TreeListPopUp::Select(){ 
	if(main && list.GetCount()!=0)
	{
		if(!list.IsCursor())
			list.SetCursor(0);
		main->AcceptData(list.Get(0), Null);
		//main->SetData(list.Get(0));
		return true;
	}
	return false;
}


void TreeListPopUp::FakeShiftFocus()
{
	// here we do it the easier way cause there are only two children
	fake_focus_ctrl= fake_focus_ctrl==&tree?(Ctrl*)&list:(Ctrl*)&tree;
}

void TreeListPopUp::TreeWhenLeft()
{
	fake_focus_ctrl=&tree;
}

void TreeListPopUp::ListWhenLeft()
{
	fake_focus_ctrl=&list;
}

void TreeListPopUp::ListLeftDouble()
{
	fake_focus_ctrl=&list;
	DoKey(K_ENTER, 1);
}

// a default implementation, for EditField derivatives, may add a default for LineEdit etc later.
//
void PopUpEx::AcceptSuffix(const PopMan::PopUpHint& hint, String suffix)
{
	PopMan::PopUpHint h;
	GetPopupHint(h);
	if(h!=hint) // don't accept suffix if cursor/text, etc is different from the original hint this suffix is generate from.
		return;
	EditField * d=dynamic_cast<EditField*>(&GetMain());
	if(d==NULL)
		return;
	if(h.sel_start!=h.sel_end)
		d->RemoveSelection();
	d->Insert(h.sel_end, suffix);
	d->SetSelection(h.sel_start+suffix.GetLength());
	d->Refresh();
}

void PopUpEx::GetPopupHint(PopMan::PopUpHint& hint)
{
	hint.text.Clear();
	EditField* e=dynamic_cast<EditField*>(this);
	if(e)
	{
		hint.text<<e->GetText();
		e->GetSelection(hint.sel_start, hint.sel_end);
		hint.no_autocompletion=false;
	}
}




END_UPP_NAMESPACE
