#ifndef _PopEasy_PopEasy_h_
#define _PopEasy_PopEasy_h_

#include <CtrlLib/CtrlLib.h>

NAMESPACE_UPP


// user or main ask to popup, eg by keyboard/mouse/pseudoKey;
//
// content negotiation
// main communicates its content, caret location, selection etc to PopMan (how?)
// PopMan prepare content to be shown accordingly. Many interesting things can happen here
// for example, if there are nothing to be shown, it may asked not to be PopUp'd; if there's
// only one candidate, it may do the auto selection; etc
//
// if both agrees to the PopUP action, then size/location negotiation starts
// 
// PopMan propose a location and size and communicated to main;
// main authorize or modify the proposal and give it back to popup
// PopMan do the popup.
//
// or both can be combined?
//
// interface that a PopUp is expected to implement/provide
//
struct PopUpEx;

struct PopMan
{
	enum HintReason
	{
		HR_SHOW,
		///HR_CLOSE,
		HR_CHANGED		
	};
	
	struct PopUpHint
	{
		int reason;  // HR_SHOW: explicit request to show; 
		             // HR_CHANGED: text/cursor location, etc, changed.
		String text;
		int     sel_start; // if sel_start==sel_end, it's the caret position.
		int     sel_end;
		bool    no_autocompletion; // if last_key==K_BACKSPACE, no auto completion should be performed
		bool operator ==(const PopUpHint& h)const
		{
			return text==h.text && sel_start==h.sel_start && sel_end==h.sel_end;
		}
		bool operator !=(const PopUpHint& h)const
		{
			return !(*this==h);
		}
		
		String ToString()const
		{
			return String().Cat()<<"Text:"<<text<<", sel_start:"<<sel_start<<", sel_end: "<<sel_end;
		}
		// mouse location omitted for now
	};
	
	

	virtual bool DoKey(dword key, int repcount);
	
	virtual int PrepareData(const PopUpHint& hint, String* suffix)=0; //{ return 0; }
	virtual Size GetPreferredSize()const;
	virtual bool Select(){ return true; }
	
	virtual void SetAutoPopUp(bool popup=true){ autopopup=popup;}
	virtual bool GetAutoPopUp()const{ return autopopup; }
	virtual void SetAutoComplete(bool v=true){ autocomplete=v;}
	virtual bool GetAutoComplete()const{ return autocomplete; }
	virtual void SetAutoSelect(bool v=true){ autoselect=v;}
	virtual bool GetAutoSelect()const{ return autoselect; }
	
	PopMan():main(NULL), _dummy(0){}

	Ctrl* GetCtrl(){
		struct _P: PopMan, Ctrl
		{
		};
		return static_cast<Ctrl*>(reinterpret_cast<_P*>(this)); 
	}
	const   Ctrl* GetCtrl()const{ 
		return const_cast<const Ctrl*>(
			const_cast<PopMan&>(*this).GetCtrl()
		);
	}
	void SetMain(PopUpEx* _main){ main=_main; }
	PopUpEx* GetMain(){ return main; }
	const PopUpEx* GetMain()const{ return main; }
	Ctrl* GetMainCtrl();
	bool IsOpen()const{ return GetCtrl()->IsOpen(); }
	
	void NegotiateSizePosition(Rect& rect);

	void PopUp(Rect& r);
	void PopUp();
	
	void Unpop()
	{
		GetCtrl()->Close();
	}

	void AddHint(const PopUpHint& hint, PopUpEx * main);
	void ProcessHint();

	bool IsCurHintObselete()const{ return hint_count>1; }
protected:
	PopUpEx* main;
	//Ctrl* main;
	//Callback1<Rect&> WhenSizeNegotiate;
	PopUpHint hints[2];
	union{
		struct{
			bool  autopopup:1;
			bool  autocomplete:1;
			bool  autoselect:1;
			int8  cur_hint_index;
			volatile int8  hint_count;
		};
		int32 _dummy;
	};
	typedef PopMan CLASSNAME;
	
};

class PopListBase: public PopMan, public ArrayCtrl
{
public:
	PopListBase();
	
	virtual int PrepareData(const PopUpHint& hint, String* suffix); //{ return 0; }
	virtual bool Select();
	// define the storage interface
	//
	virtual int GetRowCount()const=0;
	virtual int GetColumnCount()const=0;
	virtual Value GetCellAt(int row, int col)const=0;
	
	virtual void   LeftDouble(Point p, dword keyflags);
protected:

	int batch_size;	
};


class PopList: public PopListBase
{
public:
	void Add(const Vector<Value>& v)
	{
		data.Add(v);
	}
	
#define  E__Add(I)      void Add(__List##I(E__Value));
	__Expand(E__Add)
#undef   E__Add

protected:
	virtual int GetRowCount()const
	{
		return data.GetCount();
	}
	virtual int GetColumnCount()const
	{
		return data.GetCount()==0?0:data[0].GetCount();
	}
	virtual Value GetCellAt(int row, int col)const
	{
		if(row>=data.GetCount() || col>=data[row].GetCount())
			return Null;
		return data[row][col];
	}

	Vector<Vector<Value> > data; // provides naive local storage
};

class TreeListPopUp: public PopMan, public Splitter
{
public:
	enum ViewStyle{VS_TreeOnly, VS_ListOnly, VS_TreeList};

	TreeListPopUp();
	
	TreeListPopUp& SetViewStyle(ViewStyle style);	

	virtual bool DoKey(dword key, int repcount);
	virtual bool Select();
	virtual void RefreshTree(){} // newly added
	virtual void RefreshList(){} // newly added

	typedef TreeListPopUp CLASSNAME;
	typedef PopMan _Parent;
protected:
	ArrayCtrl  list;
	TreeCtrl   tree;
	Ctrl*      fake_focus_ctrl;
	String     hint_text;
	ViewStyle  view_style; 
	
	
	void FakeShiftFocus();
	
	void TreeWhenLeft();
	void ListLeftDouble();
	void ListWhenLeft();
};

//#define COMPACT_WITHPOPUP
//#ifndef COMPACT_WITHPOPUP


// it becomes increasingly apparent WithPopUp<T> also need to have some virtual methods or
// even member variables (eg., one can argue AutoPopUp, AutoComplete, AutoSelct should 
// be properties of WithPopUp<T> instead),
// instead of simply add it t0 the class, we collect them into an interface like thing so that
// they can be accessed more uniformly.
struct PopUpEx
{
	virtual void GetSizePosition(Rect& rt){ rt=Null; }
	virtual void GetPopupHint(PopMan::PopUpHint& hint);
	virtual void AcceptData(const Value& key, const Value& text){ GetMain().SetData(key); }
	virtual void AcceptSuffix(const PopMan::PopUpHint& hint, String suffix);
	virtual bool UnacceptSuffix();
	virtual void Cancel(){} // when use close popup without make a selection, eg by Esc key.
	
	//virtual ~PopUpEx(); - not required right now. 
	
	Ctrl& GetMain(){ return *reinterpret_cast<Ctrl*>(
	     	reinterpret_cast<char*>(this)-delta
	     );
	}
	const Ctrl& GetMain()const
	{ 
		return const_cast<const Ctrl&>(
			const_cast<PopUpEx&>(*this).GetMain()
		);
	}
	PopUpEx(size_t delta):delta(delta), man(NULL), len_of_suffix_just_accepted(0){}

protected:	                                                           
	PopMan  *man;	
	const size_t delta; // delta is used to convert this to WithPopUp<T>
	int  len_of_suffix_just_accepted;
	
};

template <class T>class WithPopUp : public T, public PopUpEx
{
public:
	typedef WithPopUp<T> _Self;
	typedef T			 _Parent;
	
	WithPopUp():PopUpEx(sizeof(T)){		
	}
	

	virtual bool Key(dword key, int count);
	//virtual void SetData(const Value& v);

	PopMan* SetPopMan(PopMan* _new);
	
	bool IsPopUpOpen(){ return man && man->GetCtrl()->IsOpen(); }
protected:
	void Unpop()
	{
		if(man && man->GetMainCtrl()==this)
			man->Unpop();
	}		
		
	virtual void LostFocus(){
	 	Unpop();
	 	this->_Parent::LostFocus(); 
	 }	
	 
	 virtual void State(int reason)
	 {
	     if(reason==static_cast<int>(Ctrl::POSITION) && IsPopUpOpen())
	     {
            Rect rt;
            man->NegotiateSizePosition(rt);
            man->PopUp(rt); 
	     }
	     else if(!this->IsVisible())
	         Unpop();
	     this->_Parent::State(reason);
	 }
	
//protected:
//		
	typedef WithPopUp<T> CLASSNAME;
};

template <class T>
bool WithPopUp<T>::Key(dword key, int count)
{
	if(man)
	{
		PopMan::PopUpHint hint;
		switch(key)
		{
		case K_ALT_DOWN:
		case K_ALT_UP:
			if(IsPopUpOpen())
			{
				Unpop();

			}else
			{
				hint.reason=PopMan::HR_SHOW;
				this->GetPopupHint(hint);
				man->AddHint(hint, this);
				return true;
			}
			break;
		default:
			if( IsPopUpOpen() && man->DoKey(key, count))
				return true;
		}
		if( (key==K_BACKSPACE && len_of_suffix_just_accepted!=0 && UnacceptSuffix() ) || 
				this->T::Key(key, count)
		){
			hint.reason=PopMan::HR_CHANGED;
			this->GetPopupHint(hint);
			hint.no_autocompletion=key==K_BACKSPACE;
			if(IsPopUpOpen() || man->GetAutoPopUp())
			{
				man->AddHint(hint, this);
			}
			len_of_suffix_just_accepted=0;
			return true;
		}
		return false;
	}else
		return this->T::Key(key, count);
}



template <class T>
PopMan* WithPopUp<T>::SetPopMan(PopMan* _new)
{
	PopMan *old=man;
	if(old)
	{
		old->SetMain(NULL);
		Unpop();
	}
	man=_new;
	man->SetMain(this);
	return old;
}

END_UPP_NAMESPACE

#endif
