#include "gex.h"

bool gex::Open(const char *file, bool delete_share)
{
	f.Close();

	if (f.Open(file, delete_share) && f.Map(0, static_cast<dword>(f.GetFileSize())))
	{
		Title(file);

		view.SetTotal(0xffffffff);
		view.SetSc((int64)f.Begin());
		view.SetCursor((int64)f.Begin());
		
		return true;
	}
	
	return false;
}

void gex::OpenFile()
{
	FileSel fs;
	fs.Type("Any file", "*");
	if(fs.ExecuteOpen())
		Open(~fs);
}

void gex::main_menu(Bar& menu)
{
	menu.Add("File", THISBACK(menu_file));
}

void gex::menu_file(Bar& menu)
{
	menu.Add("Open file", THISBACK(OpenFile)).Key(K_CTRL_O);
	menu.Separator();
	menu.Add("Exit", Breaker(IDOK));
}

void gex::DragAndDrop(Point p, PasteClip& d)
{
	if (AcceptFiles(d))
	{
		const String name = GetFiles(d).Top();
		
		Open(name);
	}
}

gex::gex()
{
	Sizeable().Zoomable();

//	Icon(AmapImg::diamond_16());
//	LargeIcon(AmapImg::diamond_32());
	AddFrame(menu);
	menu.Set(THISBACK(main_menu));

#if 0
	const char* name = NULL;
	
#ifdef PLATFORM_WIN32
	name = "c:/local/home/sergey/cpp/upp/lasso/lasso.cpp";
#else
	name = "/home/ssg/dvlp/cpp/sergey/upp/lasso/lasso.cpp";
#endif

	Open(name);
#endif

	Add(view.SizePos());	

}

GUI_APP_MAIN
{
	gex().Run();
}
