#include "BarCode128_test.h"

#define IMAGECLASS BarCode128_testImg
#define IMAGEFILE <BarCode128_test/BarCode128_test.iml>
#include <Draw/iml_source.h>


#include <BarCode128/BarCode128.h>
BarCode128_test::BarCode128_test()
{
	CtrlLayoutOK(*this, "BarCode128_test");
	str << THISBACK(ImageRecalc);
	im.SetImage(BarCode128().Code128_To_Image("test",CODE128B));
	Icon(BarCode128_testImg::barcode128());
	stripwidth<<=2;
	imagehieght<<=80;
	quietzone<<=30;
	debugbackground<<=0;
	str <<= "AIM1234";
	savepng << THISBACK(ImageSavePng);
	


	stripwidth<<THISBACK(ImageRecalc);
	imagehieght<<THISBACK(ImageRecalc);
	quietzone<<THISBACK(ImageRecalc);
	debugbackground<<THISBACK(ImageRecalc);
	
}

void BarCode128_test::ImageSavePng(){
	PNGEncoder png;
	FileSel fs;
	fs.MkDirOption();
	fs.DefaultExt("png");
	fs.Type("PNG image","png");
	fs.AllFilesType();
	if(!fs.ExecuteSaveAs(t_("Enter File Name to save PNG Image"))) 
		return;
	png.SaveFile(~fs, image);

}

void BarCode128_test::ImageRecalc() {
	Single<BarCode128>().StripWidth(~stripwidth);
	Single<BarCode128>().ImageHieght((int(~imagehieght)<20)? 20:int(~imagehieght));
	Single<BarCode128>().QuietZone(~quietzone);
	Single<BarCode128>().DebugBackground(~debugbackground);
	image = Single<BarCode128>().Code128_To_Image(~str,CODE128B);
	im.SetImage(image);
	im.Refresh();
	im.Sync();
}

GUI_APP_MAIN
{
	BarCode128_test().Run();
}
