#ifndef _BarCode128_BarCode128_h
#define _BarCode128_BarCode128_h

#include <Core/Core.h>

using namespace Upp;

typedef enum {CODE128A=1,CODE128B,CODE128C} CodeTable128;
typedef enum {STARTWRITE=1,TEXTWRITE,CHECKWRITE,STOPWRITE} WriteOrder;
#define		START_CODE_A 	103
#define 	START_CODE_B 	104
#define		START_CODE_C 	105
#define		STOP_SYM 		106

class BarCode128 {
	typedef BarCode128 CLASSNAME;
public:
	Image Code128_To_Image(String s1, CodeTable128 ct);
	BarCode128();
	void StripWidth(int sw=2)		{stripwidth=sw;}
	void ImageHieght(int ih=80)		{imagehieght=ih;}
	void QuietZone(int qz=30)		{quietzone=qz;}
	void DebugBackground(int db=0)	{debugbackground=db;};
	void ShowRect(int sr=1)			{showrect=sr;}

protected:
	ImageDraw* idrp;
	String str;
	int strlen;
	CodeTable128 codeset;
	
	Size is;
	Size ts;
	void DrawStrips();
	void DrawStripSym(int sym,int len=11);
	void Draw1Strip(int s);
	int nextstrip;
	int stripwidth;
	int imagehieght;
	int quietzone;
	int showrect;
	int debugbackground;
	int odd;
	WriteOrder ord;
	
	int StartCode();
	int Encode128(int sym);
	int CodeShift(int sym);
	int CheckCode();
};



#endif
