#include <Core/Core.h>
#include <Web/Web.h>

using namespace Upp;

bool CheckContentTypeGetBoundary(const String &contentType, const String &multipartType, String &boundary)
{
	const static String BOUNDARY = "boundary=";

	int multipartI;
	if ((multipartI = contentType.Find(multipartType)) < 0)
		return false; //!multipart/*****
	
	int boundaryI = contentType.Find(BOUNDARY, multipartI+multipartType.GetLength());
	if (boundaryI < 0)
		return false; //!boundary=
	
	boundaryI += BOUNDARY.GetLength();
	int l = 0;
	for (int i=boundaryI; i<contentType.GetLength(); ++i, ++l)
	{
		char c = contentType[i];
		if (c == ';' || c == '\r' || c == '\n')
			break;
	}
	
	boundary = contentType.Mid(boundaryI, l);
	if (boundary.IsEmpty())
		return false; //boundary == ""
	
	return true;
}

bool CheckDisposition(const String &contentDisposition, bool &isFile, String &name, String &filename)
{
	static const String CONTENT_DISPOSITION_HEADER    = "Content-Disposition: ";
	static const String NAME_HEADER                   = " name=\"";
	static const String FILENAME_HEADER               = " filename=\"";
	
	isFile = false;
	if (!contentDisposition.StartsWith(CONTENT_DISPOSITION_HEADER))
		return false;
	int cur = CONTENT_DISPOSITION_HEADER.GetLength();
	
	int curName = contentDisposition.Find(NAME_HEADER, cur);
	if (curName >= 0)
	{
		curName += NAME_HEADER.GetLength();
		int l = 0;
		for (int i=curName; i<contentDisposition.GetLength(); ++i,++l)
		{
			if (contentDisposition[i] == '\"')
				break;
		}
		name = UrlDecode(contentDisposition.Mid(curName, l));
	}

	int curFilename = contentDisposition.Find(FILENAME_HEADER, cur);
	if (curFilename >= 0)
	{
		curFilename += FILENAME_HEADER.GetLength();
		int l = 0;
		for (int i=curFilename; i<contentDisposition.GetLength(); ++i,++l)
		{
			if (contentDisposition[i] == '\"')
				break;
		}
		filename = UrlDecode(contentDisposition.Mid(curFilename, l));
		isFile = true;
	}
	return true;
}

String ReadUntilTerm(Socket &socket, char term, int timeout, int maxlen)
{
	ASSERT(socket.IsOpen() && maxlen != 0);
	int ticks = GetTickCount(), end_ticks = IsNull(timeout) ? int(Null) : ticks + timeout, seek = 0;
	String out = socket.Read(timeout, maxlen);
	if(out.IsVoid())
		return out;

	for(;;) {
		int f = out.Find((byte)term, seek);
		if(f >= 0) {
			socket.UnRead(String(out.Begin() + f + 1, out.GetLength() - f - 1));
			return out.Left(f+1);
		}
		seek = out.GetLength();
		ticks = GetTickCount();
		if(!IsNull(timeout)) timeout = end_ticks - ticks;
		if(!IsNull(timeout) && timeout <= 0 || out.GetLength() >= maxlen)
			return out;
		String part = socket.Read(timeout, maxlen - out.GetLength());
		if(part.IsVoid()) {
			return out;
		}
		out.Cat(part);
	}
}
bool ParseFormData(
	Socket                   &socket, 
	dword                     timeout, 
	const String             &contentType, 
	const String             &dir,
	bool                      isFieldsListOnly, 
	VectorMap<String,String> &fields, 
	VectorMap<String,String> &files,
	const int                 maxFileSize = 100*1024*1024
	)
{
	const static String MULTIPART_FORMDATA = "multipart/form-data";
	const static String MULTIPART_MIXED    = "multipart/mixed";
	const static String DOUBLE_DASH        = "--";
	
	///////////////////////////////
	String boundary;
	if (!CheckContentTypeGetBoundary(contentType, MULTIPART_FORMDATA, boundary))
		return false;
	boundary.Insert(0, DOUBLE_DASH);

	//////////////////////////////	
	static const int CHUNK = 8192;
	String buf;
	
	enum STATE {BOUNDARY, HEADER, DATA} state = BOUNDARY;
	String stateTitle;
	bool   stateFile;
	String boundary2;
	int    fileCounter = 0;
	FileOut fOut;
	
	dword t0 = GetTickCount();
	dword dt;
	while ((dt = GetTickCount() - t0) < timeout)
	{
		dword to = timeout-dt;
		switch (state)
		{
		case BOUNDARY:
			buf = socket.ReadUntil('\n',to,CHUNK);
			if (!boundary2.IsEmpty())
			{
				if (!buf.StartsWith(boundary2))
					return false; //!boundary2
			}
			else
			{
				if (!buf.StartsWith(boundary))
					return false; //!boundary
				else
				{
					if (buf.GetLength() >= boundary.GetLength()+2 
					&& buf[boundary.GetLength()] == '-'
					&& buf[boundary.GetLength()+1] == '-'
					)
						return true;
				}
			}
			state = HEADER;
			break;
		case HEADER:
			buf = socket.ReadUntil('\n',to,CHUNK);
			{
				++fileCounter;
				String name;
				String filename;
				if (!CheckDisposition(buf, stateFile, name, filename))
					return false; //bad content disposition
				if (stateFile)
					filename = GetFileName(UnixPath(filename));
				stateTitle = stateFile ? (filename.IsEmpty() ? (name + FormatInt(fileCounter)) : filename) : name;
				if (stateTitle.IsEmpty())
					return false; //!name
				
				bool allHeaders = false;
				bool b2 = false;
				while ((dt = GetTickCount() - t0) < timeout)
				{
					to = timeout-dt;
					buf = socket.ReadUntil('\n',to,CHUNK);
					if (buf.GetLength() <= 1)
					{
						allHeaders = true;
						break;
					}
					if (!b2 && CheckContentTypeGetBoundary(buf, MULTIPART_MIXED, boundary2))
					{
						boundary2.Insert(0, DOUBLE_DASH);
						b2 = true;
					}
				}
				if (!allHeaders)
					return false;
				state = b2 ? BOUNDARY : DATA;
			}
			break;
		case DATA:
			{
				int fileSize = 0;
				bool ignoreData = false;
				if (isFieldsListOnly)
				{
					if (stateFile && files.Find(stateTitle) < 0)
						ignoreData = true;
					else
					if (!stateFile && fields.Find(stateTitle) < 0)
						ignoreData = true;
				}

				if (!ignoreData)
				{
					if (stateFile)
					{
						String fn = stateTitle;
						if (!dir.IsEmpty())
						{
							char finalChar = dir[dir.GetLength()-1];
							if (finalChar != '/' && finalChar != '\\')
								fn.Insert(0,'/');
							fn.Insert(0,dir);
						}
						fOut.Open(fn);
						files.GetAdd(stateTitle,fn);
					}
					else
					{
						fields.GetAdd(stateTitle).Clear();
					}
				}
				
				buf.Clear();
				String b = boundary2.IsEmpty() ? boundary : boundary2;
				while ((dt = GetTickCount() - t0) < timeout)
				{
					to = timeout-dt;
					buf.Cat(ReadUntilTerm(socket,'\n',to,CHUNK));
					int bI = -1;
					if (buf[buf.GetLength()-1] != '\n'
					|| buf.GetLength() < b.GetLength()+4
					|| (bI = buf.Find(b,buf.GetLength()-b.GetLength()-4 < 0 ? 0 : buf.GetLength()-b.GetLength()-4)) < 0
					)
					{
						int dl = buf.GetLength()-b.GetLength()-4;
						if (dl > 0)
						{
							if (!ignoreData)
							{
								if (stateFile)
								{
									fileSize += dl;
									if (fileSize >= maxFileSize)
										ignoreData = true;
									fOut << buf.Left(dl);
								}
								else
									fields.GetAdd(stateTitle) << buf.Left(dl);
							}
							buf.Remove(0,dl);
						}
					}
					else
					{
						int dl = bI - 2;
						if (dl > 0)
						{
							if (!ignoreData)
							{
								if (stateFile)
								{
									fOut << buf.Left(dl);
									fileSize += dl;
									if (fileSize >= maxFileSize)
										ignoreData = true;
								}
								else
									fields.GetAdd(stateTitle) << buf.Left(dl);
							}
						}
						if (buf.GetLength() < bI+b.GetLength()+2 || buf[bI+b.GetLength()] != '-' || buf[bI+b.GetLength()+1] != '-')
						{
							state = HEADER;
							if (fOut.IsOpen())
								fOut.Close();
							break;
						}
						else
						{
							if (boundary2.IsEmpty())
							{
								if (fOut.IsOpen())
									fOut.Close();
								return true;
							}
							else
							{
								state = BOUNDARY;
								boundary2.Clear();
								if (fOut.IsOpen())
									fOut.Close();
								break;
							}
						}
					}
				}
				
				if (fOut.IsOpen())
					fOut.Close();
			}
			break;
		}
	}
	
	return false;
}

class SClient : public Thread
{
public:
	SClient()
	{
		this->Run(callback(this, &SClient::Work));
	}
	~SClient()
	{
		this->Wait();
	}
	void Work()
	{
		FileIn fIn(GetExeDirFile("test"));
		Socket sck;
		ClientSocket(sck,"localhost",10000);
		DUMP(fIn.GetSize());
		String s = fIn.Get((int)fIn.GetSize());
		sck.WriteWait(~s, s.GetLength(), 100000);
	}
};

CONSOLE_APP_MAIN
{
	Socket socketServer;
	ServerSocket(socketServer, 10000);
	if (socketServer.IsOpen())
	{
		SClient();
		Sleep(100);
		Socket sck;
		if (socketServer.Accept(sck))
		{
			VectorMap<String,String> fields, files;
			ParseFormData(
				sck, 
				100000, 
				"Content-Type: multipart/form-data; boundary=AaB03x", 
				GetExeDirFile(String()),
				false, 
				fields, 
				files
				);
			DUMPC(fields.GetKeys());
			DUMPC(fields);
			DUMPC(files.GetKeys());
			DUMPC(files);
		}
	}
}
