#include "Barcode.h"

int code = 1;

void Barcode::DisplayBarcode() {
	Image img;
	ImageBuffer ib;
	struct zint_symbol *zbarcode;

	zbarcode = ZBarcode_Create();
	zbarcode->input_mode = UNICODE_MODE;
	//zbarcode->height = 20;
	zbarcode->symbology = code.GetData();
	ZBarcode_Encode(zbarcode, (unsigned char *)str.GetData().ToString().Begin(), 0);
	ZBarcode_Buffer(zbarcode, 0);
	
	ib.Create(zbarcode->bitmap_width, zbarcode->bitmap_height);
	int row, col, i = 0;
	for(row = 0; row < zbarcode->bitmap_height; row++) {
		RGBA *rowData = ib[row];
		for(col = 0; col < zbarcode->bitmap_width; col++) {
			rowData[col].a = 255;
			rowData[col].r = zbarcode->bitmap[i];
			rowData[col].g = zbarcode->bitmap[i + 1];
			rowData[col].b = zbarcode->bitmap[i + 2];
			i += 3;
		}
  	}
	img = ib;
	
	imgctrl.SetImage(img);
}

Barcode::Barcode()
{
	CtrlLayoutOKCancel(*this, "Barcode using Zint Library");
	Sizeable().MinimizeBox().MaximizeBox();
	
	str.SetData("http://www.ultimatepp.org");
	
	code.Add(1,  "Code 11");
	code.Add(2,  "Standard 2of5");
	code.Add(3,  "Interleaved 2of5");
	code.Add(4,  "IATA 2of5");
	code.Add(6,  "Data Logic");
	code.Add(7,  "Industrial 2of5");
	code.Add(8,  "Code 39");
	code.Add(9,  "Extended Code 39");
	code.Add(13, "EAN");
	code.Add(16, "GS1-128");
	code.Add(18, "Codabar");
	code.Add(20, "Code 128");
	code.Add(21, "Leitcode");
	code.Add(22, "Identcode");
	code.Add(23, "Code 16k");
	code.Add(24, "Code 49");
	code.Add(25, "Code 93");
	code.Add(28, "Flattermarken");
	code.Add(29, "Databar-14");
	code.Add(30, "Databar Limited");
	code.Add(31, "Databar Extended");
	code.Add(32, "Telepen Alpha");
	code.Add(34, "UPC-A");
	code.Add(37, "UPC-E");
	code.Add(40, "Postnet");
	code.Add(47, "MSI Plessey");
	code.Add(49, "FIM");
	code.Add(50, "Logmars");
	code.Add(51, "Pharma One-Track");
	code.Add(52, "PZN");
	code.Add(53, "Pharma Two-Track");
	code.Add(55, "PDF417");
	code.Add(56, "PDF417 Trunc");
	code.Add(57, "Maxicode");
	code.Add(58, "QR Code");
	code.Add(60, "Code 128-B");
	code.Add(63, "AP Standard Customer");
	code.Add(66, "AP Reply Paid");
	code.Add(67, "AP Routing");
	code.Add(68, "AP Redirection");
	code.Add(69, "ISBN");
	code.Add(70, "RM4SCC");
	code.Add(71, "Data Matrix");
	code.Add(72, "EAN-14");
	code.Add(75, "NVE-18");
	code.Add(76, "Japanese Post");
	code.Add(77, "Korea Post");
	code.Add(79, "Databar-14 Stack");
	code.Add(80, "Databar-14 Stack Omni");
	code.Add(81, "Databar Extended Stack");
	code.Add(82, "Planet");
	code.Add(84, "MicroPDF");
	code.Add(85, "USPS OneCode");
	code.Add(86, "UK Plessey");	
	code.Add(87, "Telepen Numeric");
	code.Add(89, "ITF-14");
	code.Add(90, "KIX Code");
	code.Add(92, "Aztec Code");
	code.Add(93, "DAFT Code");
	code.Add(97, "Micro QR Code");
	code.Add(98, "HIBC Code 128");
	code.Add(99, "HIBC Code 39");
	code.Add(102,"HIBC Data Matrix");
	code.Add(104,"HIBC QR Code");
	code.Add(106,"HIBC PDF417");
	code.Add(108,"HIBC MicroPDF417");
	code.Add(112,"HIBC Aztec Code");
	code.Add(128,"Aztec Runes");
	code.Add(129,"Code 23");
	code.Add(130,"Comp EAN");
	code.Add(131,"Comp GS1-128");
	code.Add(132,"Comp Databar-14");
	code.Add(133,"Comp Databar Ltd");
	code.Add(134,"Comp Databar Ext");
	code.Add(135,"Comp UPC-A");
	code.Add(136,"Comp UPC-E");
	code.Add(137,"Comp Databar-14 Stack");
	code.Add(138,"Comp Databar Stack Omni");
	code.Add(139,"Comp Databar Ext Stack");
	code.Add(140,"Channel Code");
	code.Add(141,"Code One");
	code.Add(142,"Grid Matrix");

	code.SetData(58);
	DisplayBarcode();

	str.WhenAction  = THISBACK(DisplayBarcode);
	code.WhenAction = THISBACK(DisplayBarcode);
}

GUI_APP_MAIN
{
	Barcode().Run();
}
