#include "ModbusComm.h"

#define		idRxTimer			1

ModbusComm::ModbusComm()
{
}

// write modbus registers
// ID, 0x10, Address, NoOfRegs, CRC16
bool	ModbusComm::WriteRegs(byte Id, uint16 Reg, uint16 NoOfRegs, String data)
{
	StringBuffer Packet;
	
	Packet.SetLength(6);
	Packet[0]=Id;					// slave Id
	Packet[1]=0x10;					// write registers command
	Packet[2]=Reg >> 8;				// Register Address MSB
	Packet[3]=Reg & 0xff;			// Register Address LSB
	Packet[4]=NoOfRegs >> 8;		// Register Count MSB
	Packet[5]=NoOfRegs & 0xff;		// Register Count LSB
	Packet.Cat(data);				// concatenate the data we have to send
	
	int16 crc = CRC16(Packet);	// find the crc16 of the packet
	int16 pos = Packet.GetLength();
	Packet.SetLength(pos+2);
	Packet[pos++]=crc & 0xff;	// LSB of crc
	Packet[pos]=crc >> 8;

	SendData(Packet, Packet.GetLength());
	return true;
}


// read modbus registers
// ID, 0x03, Address, NoOfRegs, CRC16
StringBuffer&	ModbusComm::ReadRegs(byte Id, uint16 Reg, uint16 NoOfRegs)
{
	StringBuffer Packet, &Rx=RxPacket;
	String s;
	
	Packet.SetLength(6);
	Packet[0]=Id;					// slave Id
	Packet[1]=0x03;					// read registers command
	Packet[2]=Reg >> 8;				// Register Address MSB
	Packet[3]=Reg & 0xff;			// Register Address LSB
	Packet[4]=NoOfRegs >> 8;		// Register Count MSB
	Packet[5]=NoOfRegs & 0xff;		// Register Count LSB
	
	uint16 crc = CRC16(Packet);		// find the crc16 of the packet
	Packet.SetLength(Packet.GetLength()+2);
	Packet[6]=crc & 0xff;			// LSB of crc
	Packet[7]=crc >> 8;

	SendData(Packet, Packet.GetLength());
	//DUMP(HexString(Packet));
//	Sleep(200);						// sleep for 100mS
	Rx.SetLength(256);		// make a buffer of 256 characters

	int bytes_read = 0;
	if (ReadDataWaiting())	bytes_read = ReadData(Rx, 256);
	else					Rx.Clear();
	Rx.SetLength(bytes_read);
	return Rx;
}

// This will generate a CRC16 integer for ModBus protocol
// Implemented by Jerson Fernandes in 2003
uint16  ModbusComm::CRC16(StringBuffer& Str)
{
uint16  crc;
byte  crclsb, cnt, len;

  len = Str.GetLength();
  
  crc = 0xffff;
  for (int i = 0; i < len; i++)
  {
    crc ^= (byte)Str[i];

    for (cnt = 0; cnt < 8; cnt++)
    {
      crclsb = crc & 1;
      crc >>= 1;

      if (crclsb)        crc ^= 0xA001;
    }
  }
  //DUMP(Format("%04x",crc));
  return crc;
}

