#ifndef _ModbusComm_ModbusComm_h
#define _ModbusComm_ModbusComm_h

#include <CtrlLib/CtrlLib.h>
#include "serial.h"

using namespace Upp;


// Modbus class derived from the SerialPort class
class ModbusComm : SerialPort {
private:
	StringBuffer	RxPacket;			// received data packet
	
public:
	typedef ModbusComm CLASSNAME;
	ModbusComm();
	
	bool	Start(int Port, String Params)
			{ return Open(Port, Params);	};
	
	bool	Stop()
			{ return Close(); };
	bool	WriteRegs(byte Id, uint16 Reg, uint16 NoOfRegs, String data);
	StringBuffer&	ReadRegs(byte Id, uint16 Reg, uint16 NoOfRegs);

private:
	uint16  CRC16(StringBuffer& Str);
};

#endif

