#ifndef _Reports3_RepGen_h_ 
#define _Reports3_RepGen_h_

#include <Core/Core.h>
#include <Report/Report.h>

using namespace Upp;

//Module maximized window
class RepGen;

enum PerformMode {STANDARDMODE=1,SILENTMODE,PDFWRITE};


class RepGen  {
//	friend class RepGenSubProc;
private:
	String tpl,tplb,tplbr;
	String result,resultb;
	bool ENDCALCULATE;
	bool IN_BP_LOOP;
	String *pStr_to_subst;
	String *pTpl_cycle;
	String *pRes_sub_proc;
	void PerformLoopTable(String start_str, String end_str, String &templ);
	void PerformLoopPlain(String start_str, String end_str, String &templ, bool trimlastchar=false);

	
	void PCRE_Replace(String& where, String s_from,String s_to);
	void PCRE_ReplaceConditional(String& where, String s_from,String s_to,bool condition,String cond_start,String cond_end);

public:
	Report report;
	String *pTpl_cycle_res;
	
	typedef RepGen CLASSNAME;
	RepGen();
	~RepGen() {};
	void SetTemplate(String tpl0) { tpl=Join(Split(tpl0,'\n'),""); };
	
	Callback RepGenReportStart;
	Callback RepGenReportVar;
	Callback RepGenReportFinish;
	Callback RepGenCalculateStart;
	Callback RepGenCalculateBody;
	Callback RepGenCalculateFinish;
	void RepGenCalculateBodyBeforeSubst();
	void RepGenCalculateBodyAfterSubst();
	
	void SubstVar(String s_from,String s_to);
	void SubstVarConditional(String s_from,String s_to,bool condition, String cond_start="##IF",String cond_end="##FI");
	bool ExistVar(String s);
	void PlaceImage          (String s_from, Image im_to, Size rep_place = Size(0,0));
	
	void LoopDone(bool indicator=true) { ENDCALCULATE = indicator; };

	void Perform(PerformMode mode = STANDARDMODE, String filename="");
};

#endif
