#include "ZMQ_Helper.h"

#define LLOG(x) RLOG(x)
//#define LLOG(x) ;
ZMQ_Server::ZMQ_Server(): context(1),socket (context, ZMQ_REP) {}

bool ZMQ_Server::debug;

void ZMQ_Server::Bind(String con){
	connect_str = con;
	try
	{
		socket.bind(~connect_str);
	}
	catch (const zmq::error_t& ze){
		String s;
		s.Cat() << "Exception: " << ze.num() << ":" << ze.what() << "\n";
		Cout() << s ;
		Cerr() << s ;
		RLOG(s);
	}

}

void ZMQ_Server::MSend(String mess,int flags){
	int l = mess.GetLength()+1;
	zmq::message_t request (l);
	char *string = (char*)malloc(l);
	for(int i = 0; i < l; i++)
		string[i] = mess[i];
	memcpy ((void *) request.data (),  string, l);
	free(string);
	try
	{
		success_io = socket.send(request,flags);
	}
	catch (const zmq::error_t& ze){
		String s;
		s.Cat() << "Exception: " << ze.num() << ":" << ze.what() << "\n";
		Cout() << s ;
		Cerr() << s ;
		RLOG(s);
	}
	if (ZMQ_Server::debug) Cout() << connect_str << Format(": Sending <%s>  ...\n", mess);
}

String ZMQ_Server::MReceive(int flags){
	String retval;
	zmq::message_t reply;
	try
	{
		success_io = socket.recv (&reply,flags);
	}
	catch (const zmq::error_t& ze){
		String s;
		s.Cat() << "Exception: " << ze.num() << ":" << ze.what() << "\n";
		Cout() << s ;
		Cerr() << s ;
		RLOG(s);
	}
	int size = reply.size();
	char *string = (char*)malloc(size+1);
	memcpy (string, reply.data(), size);
	string[size] = 0;
	retval <<= string;
	free(string);
	if (success_io) {
		if (ZMQ_Server::debug) Cout() << "... " <<connect_str << Format(": Received <%s> \n", retval);
		return retval;
	} else {
		if (ZMQ_Server::debug) Cout() << "... " <<connect_str << ": Received failed \n";
		return "";
	}
}



//==========================================================================================//

bool ZMQ_Client::debug;

ZMQ_Client::ZMQ_Client(): context(1),socket (context, ZMQ_REQ) {}

void ZMQ_Client::Connect(String con){
	connect_str = con;
	connected = true;
	int linger = 100;
	try
	{
		int linger = 0;
		socket.setsockopt(ZMQ_LINGER,&linger,sizeof(linger));
		socket.connect(~connect_str);
	}
	catch (const zmq::error_t& ze){
		String s;
		s.Cat() << "Exception: " << ze.num() << ":" << ze.what() << "\n";
		Cout() << s ;
		Cerr() << s ;
		RLOG(s);
		connected = false;
	}
}

void ZMQ_Client::MSend(String mess,int flags){
	int l = mess.GetLength()+1;
	zmq::message_t request (l);
	char *string = (char*)malloc(l);
	for(int i = 0; i < l; i++)
		string[i] = mess[i];
	memcpy ((void *) request.data (),  string, l);
	free(string);
	try
	{
		success_io = socket.send(request,flags);
	}
	catch (const zmq::error_t& ze){
		String s;
		s.Cat() << "Exception: " << ze.num() << ":" << ze.what() << "\n";
		Cout() << s ;
		Cerr() << s ;
		RLOG(s);
	}
	if (ZMQ_Client::debug) Cout() << connect_str << Format(": Sending <%s>  ...\n", mess);
}

String ZMQ_Client::MReceive(int flags){
	String retval;
	zmq::message_t reply;
	try
	{
		success_io = socket.recv (&reply,flags);
	}
	catch (const zmq::error_t& ze){
		String s;
		s.Cat() << "Exception: " << ze.num() << ":" << ze.what() << "\n";
		Cout() << s ;
		RLOG(s);
	}
	int size = reply.size();
	char *string = (char*)malloc(size+1);
	memcpy (string, reply.data(), size);
	string[size] = 0;
	retval <<= string;
	free(string);
	RDUMP(retval);
	if (success_io) {
		if (ZMQ_Client::debug) Cout() << "... " <<connect_str << Format(": Received <%s> \n", retval);
		return retval;
	} else {
		if (ZMQ_Client::debug) Cout() << "... " <<connect_str << ": Received failed \n";
		return "";
	}

}
