#include "RpcTest.h"

RpcTestAddParam::RpcTestAddParam() {
	CtrlLayoutOKCancel(*this, "XmlRpc Client");
}

Value RpcTestAddParam::getVal() {
	LOG((~str).GetType());
	if(str.GetLength())
		return ~str;
	if(i.GetLength())
		return ~i;
	if(dou.GetLength())
		return ~dou;
	if(dat.GetLength())
		return ~dat;
	if(tim.GetLength())
		return ~tim;
	
}

RpcTest::RpcTest()
{
	params.AddColumn("params");
	CtrlLayout(*this, "XmlRpc Client");
	
	execute<<THISBACK(Execute);
	add<<THISBACK(AddParam);
	getmethods<<THISBACK(CheckForMethods);
	
	host=String("xmlrpc-c.sourceforge.net");
	path=String("/api/sample.php");
	port=80;
	CheckForMethods();
}

void RpcTest::AddParam() {
	RpcTestAddParam p;
	if(p.RunAppModal() == IDOK) {
		Vector<Value> v;
		v.Add() = p.getVal();
		params.Add(v);
	}
	Refresh();
}

void RpcTest::CheckForMethods() {
	Value v;
	
	XmlRpcCall call("system.listMethods");
	xmlClient.Host(host);
	xmlClient.Path(path);
	xmlClient.Port(port);	
	v = xmlClient.Execute(call);
	if(v.IsError())
		Exclamation(v.ToString());
	else {
		ValueArray va(v);
		method.ClearList();
		for(int i=0; i<va.GetCount();i++)
			method.AddList(va[i]);
		method.SetText(va[0].ToString());
	}
}

void RpcTest::Execute() {
	Value v,vv;
	XmlRpcParser p;
	
	XmlRpcCall call(method);
	for(int i=0;i<params.GetCount();i++) {
		call(params.Get(i,0));
	}
	
	rawsent = call.ToXml();
	vv = p.ParseMethodCall(call.ToXml());
	
	xmlClient.Host(host);
	xmlClient.Path(path);
	xmlClient.Port(port);
	v = xmlClient.Execute(call);
	rawreply = xmlClient.GetRawReply();
	
	valToString = v.ToString();
	serverval = vv.ToString();
	
	params.Clear();
	Refresh();
}

GUI_APP_MAIN
{
	RpcTest().Run();
}

