#ifndef _XmlRpc_XmlRpc_h
#define _XmlRpc_XmlRpc_h
#include <Core/Core.h>
#include <ValueMap/ValueMap.h>
#include <Web/Web.h>

class XmlRpcCall {
	private:
		String method;
		ValueArray va;
		VectorMap<int,int> NumberToValue;
		void PrimitiveToXml(XmlNode& xml,const Value& v) const;
		
	public:
		typedef XmlRpcCall CLASSNAME;
		XmlRpcCall();
		XmlRpcCall(String _method);
		XmlRpcCall(const char *_method);
		XmlRpcCall& operator() (const Value& v);
		void Clear();
		String ToXml() const;
};

class XmlRpcParser {
	protected:
		Value ParsePrimitive(XmlParser& p);
		Value ParseStruct(XmlParser& p);
		Value ParseArray(XmlParser& p);
		Value Parse(XmlParser& p);
		
	public:
		typedef XmlRpcParser CLASSNAME;
		XmlRpcParser();
		
		Value ParseMethodCall(String s);
		Value ParseMethodResponse(String s);
		
		
	
};

class XmlRpcClient {
	private:
		HttpClient http;
		String rawReply;
		XmlRpcParser xmlReply;
	public:
		typedef XmlRpcClient CLASSNAME;
		XmlRpcClient();
		XmlRpcClient(String host, String path, int Port);
		XmlRpcClient& Host(String h);
		XmlRpcClient& Path(String p);
		XmlRpcClient& Port(int p);
		//HttpClient& Get();
		const String& GetRawReply() const	{return rawReply;}
		Value Execute(const XmlRpcCall& call);
		
};
#endif

