#include "XmlRpc.h"

XmlRpcClient::XmlRpcClient() {}

XmlRpcClient::XmlRpcClient(String host, String path, int port) {
	Host(host);
	Path(path);
	Port(port);
};
/*
HttpClient& XmlRpcClient::Get() {
	return http;
};
*/

XmlRpcClient& XmlRpcClient::Host(String h) {
	http.Host(h);
	return *this;
}

XmlRpcClient& XmlRpcClient::Path(String p) {
	http.Path(p);
	return *this;
}

XmlRpcClient& XmlRpcClient::Port(int p) {
	http.Port(p);
	return *this;
}
bool IsPrimitive(XmlNode xml) {
	return xml.At(0).IsTag("double") || xml.At(0).IsTag("int") || xml.At(0).IsTag("i4") ||\
	    xml.At(0).IsTag("string") || xml.At(0).IsText() || xml.At(0).IsTag("boolean") ||\
	    xml.At(0).IsTag("dateTime.iso8601") || xml.At(0).IsTag("base64");
};

Value XmlRpcClient::Execute(const XmlRpcCall& call) {
	String request, xml;
	
	http.ClearHeaders();
	xml = call.ToXml();
	request << "User-Agent: Ultimate++ XML-RPC 1.0\r\n";
	request << "Host: "<<http.host<<"\r\n";
	request << "Content-Length: "<< (int) xml.GetLength()+2<<"\r\n";
	request << "Content-Type: text/xml\r\n\r\n";
	http.Post();
	http.std_headers = false;
	http.Headers(request);
	http.AddHeaders(xml);
	
	rawReply.Clear();
	rawReply = http.Execute();
	
	if(http.GetStatusCode() == 200) {
		return xmlReply.ParseMethodResponse(rawReply);
	}
	String stat;
	stat << "http status-code != 200 ("<<http.GetStatusCode()<<")";
	return ErrorValue(stat);
};

