#include "XmlRpc.h"

XmlRpcCall::XmlRpcCall() {};
XmlRpcCall::XmlRpcCall(String _method) {
	method = _method;	
}; 

XmlRpcCall::XmlRpcCall(const char *_method) {
	method = String(_method);
};

void XmlRpcCall::Clear() {
	method.Clear();
	va.Clear();
	NumberToValue.Clear();
}

XmlRpcCall& XmlRpcCall::operator()(const Value& v) {
	if(IsString(v) && method.IsEmpty()) {
		method = v;
		return *this;
	}
	va.Add(v);
	return *this;
};

void XmlRpcCall::PrimitiveToXml(XmlNode& xml,const Value& v) const {
	if(v.GetType() == DOUBLE_V)
		xml("double").Add().CreateText(v.ToString());
	if(v.GetType() == INT_V)
		xml("int").Add().CreateText(v.ToString());
	if(v.GetType() == STRING_V || v.GetType() == WSTRING_V )
		xml("string").Add().CreateText(v.ToString());
	//if(v.GetType() == BOOLEAN_V)
	//	xml("boolean").Add().CreateText(v.ToString());
	if(v.GetType() == DATE_V || v.GetType() == TIME_V) {
		String text;
		Time t=v;
		text << t.year << (t.month<10?"0":"") << (int)t.month << (t.day<10?"0":"") << (int)t.day <<'T'<<(t.hour<10?"0":"") << (int)t.hour;
		text << ':' << (t.minute<10?"0":"");
		text << (int)t.minute << ":"<<(t.second<10?"0":"") << (int)t.second;
		xml("dateTime.iso8601").Add().CreateText(text);
	}
};

String XmlRpcCall::ToXml() const{
	XmlNode xml;
	Value v;
	ValueArray vaa;
	ValueMap vm;
	
	xml("methodCall")("methodName").Add().CreateText(method);
	XmlNode& params=xml.At(xml.FindTag("methodCall"))("params");
	
	for(int i=0;i<va.GetCount();i++) {
		XmlNode& current = params.Add("param").Add("value");
		switch(va[i].GetType()) {
			case DOUBLE_V:
			case INT_V:
			case STRING_V:
			case WSTRING_V:
			case DATE_V:
			case TIME_V:
			//case BOOLEAN_V:
				PrimitiveToXml(current,va[i]);
				break;
			case VALUEARRAY_V:
				vaa=va[i];
				for(int j=0;j<vaa.GetCount();j++) {
					XmlNode& value=current("array")("data").Add("value");
					PrimitiveToXml(value,vaa[j]);		
				};
				break;
			case VALUEMAP_V:
				vm=va[i];
				for(int j=0;j<vm.GetCount();j++) {
					XmlNode& member=current("struct").Add("member");
					member("name").Add().CreateText(vm.GetKey(j));
					PrimitiveToXml(member("value"),vm.Get(j));
				}
				break;
			default:
				v = va[i];
				current("base64").Add().CreateText(StoreAsString(v));
				break;
		}
	}
	return AsXML(xml,XML_HEADER);
};



