#include "XmlRpc.h"

XmlRpcParser::XmlRpcParser() {}

const char *primitives[]= {"string","int","i4","boolean","double","dateTime.iso8601","base64"};

Value XmlRpcParser::ParsePrimitive(XmlParser& p) {
	Value v,vv;
	if(p.IsText()) {
		return Value(p.ReadText());
	}
	for(int i=0;i<7;i++) {
		if(p.Tag(primitives[i])) {
			switch(i) {
			case 0: //string
				v=Value(p.ReadText());
				break;
			case 1: //int
			case 2: //i4
				v = Value(atoi(p.ReadText()));
				break;
			case 3: //boolean
				v = Value((bool)atoi(p.ReadText()));
				break;
			case 4: //double
				v = Value(atof(p.ReadText()));
				break;
			case 5: //dateTime.iso8601
				p.ReadTextE();
				v=Value(Date(1970,1,1));
				break;	
			case 6: //base64
				LoadFromString(vv, p.ReadText());
				v = Value(vv);
				break;
			default:
				throw Exc("unexpected Error");
				break;
			}
			p.PassEnd(); 
			return Value(v);
		}
	}
	throw Exc("unknown primitive");
}

Value XmlRpcParser::ParseArray(XmlParser& p) {
	ValueArray va;
	p.PassTag("data");
	while(!p.End()) {
		Value v = Parse(p);
		va.Add(v);
	}
	return Value(va);
}

Value XmlRpcParser::ParseStruct(XmlParser& p) {
	ValueMap vm;
	Value key, data;
	while(p.Tag("member")) {
		for(int i=0;i<2;i++){
			if(p.Tag("name")) {
				key = Value(p.ReadText());
				p.PassEnd(); //name
			} else 
				data = Parse(p);
		}
		p.PassEnd(); //member
		vm.Add(key,data);
	}
	return Value(vm);
}

Value XmlRpcParser::Parse(XmlParser& p) {
	Value v;
	p.PassTag("value");
	if(p.Tag("struct")) {
		v=ParseStruct(p);
		p.PassEnd(); //struct
	}
	else if(p.Tag("array")) {
		v=ParseArray(p);	
		p.PassEnd(); //array
	}
	else
		v=ParsePrimitive(p);	
	p.PassEnd(); //value
	return Value(v);
}

Value XmlRpcParser::ParseMethodResponse(String s){
	XmlParser p(s);
	Value v;
	String error;
	
	try{
		while(!p.Tag("methodResponse")) 
			p.Skip();
	
	
		if(p.Tag("fault")) {
			ValueMap vm(Parse(p));
			error << vm["faultString"] <<" ("<<vm["faultCode"]<<")";
			p.PassEnd(); //fault
			p.PassEnd(); //methodResponse
			return ErrorValue(error);			
		}
		p.PassTag("params");
		p.PassTag("param");
		v=Parse(p);
		p.PassEnd();	//param
		p.PassEnd();	//params
		p.PassEnd();	//methodResponse
	} catch(Exc e) {
		error << "EXCEPTION: " << e;
		return ErrorValue(error);
	}
	return Value(v);		
}

Value XmlRpcParser::ParseMethodCall(String s){
	XmlParser p(s);
	ValueArray va;
	String error;
	
	try {
		while(!p.Tag("methodCall"))
		      p.Skip();
		p.PassTag("methodName");
		va.Add(Value(p.ReadText()));
		p.PassEnd(); //methodName
		p.PassTag("params");
		while(p.Tag("param")) {
			va.Add(Parse(p));
			p.PassEnd(); //param
		}
		p.PassEnd(); //params
		p.PassEnd(); //methodCall
		LOG("done at all");
	} catch(Exc e) {
		error << "EXCEPTION: " << e;
		return ErrorValue(error);
	}
	return Value(va);
}

