#include "LiveUpdate.h"

NAMESPACE_UPP

readmeDlg::readmeDlg() {
	CtrlLayout(*this, "");
	pbOK <<= THISBACK1(Break, IDOK);
	pbCancel <<= THISBACK1(Break, IDCANCEL);
}

LiveUpdate::LiveUpdate() {
	myVersion = ProductVersion("1.0");
#if defined(PLATFORM_POSIX)
	updater = "LiveUpdate";
#else
	updater = "LiveUpdate.bat";
#endif
	updateSelf = false;
	debug = false;
	localPath = GetFileDirectory(GetExeFilePath());
	appName = GetFileTitle(GetExeFilePath());
	exeName = "";	// force the user to set this value
	prefix = "liveupdate_";	// default download prefix
	source = UseFtp;	// default use ftp
	status = LIVEUPDATE_OK;
	hostVersionFile = "versions";	// default file name
	hostUpdateListFile = "fileindex";	// default file list file name
	localVersionFile = "version";	// default file name
	versionLimit = false;
	backup = false;	// default no backup
	autoUpdate = true;	// default preform auto update
	forceUpdate = false;	// default no force update
	httpTimeout = 1800000;	// default 30 minutes
	httpContentSize = 100000000;	// default 100MB
	readme = NULL;
	readmefile = "readme.qtf";	// default read me file name
	// if the <<newversion>> is find in the following string, it will be replaced with the next avaliable version number
	Msg.Add("askupdate", "Live Update&A new version <<newversion>> of this application is found.&Do you want to install the updates ?");
	Msg.Add("success", "Live Update&Update Success.&You can start your application now, thank you.");
	Msg.Add("fail", "Live Update&Update Failed !");
	Msg.Add("abort", "Live Update&Update Aborted !");
	Msg.Add("pathnotfound", "Live Update&Remote path not found !");
	Msg.Add("uptodate", "Live Update&Application is up to date.");
	Msg.Add("checkupdate", "Live Update&Checking avaliable updates...");
	Msg.Add("connecthost", "Live Update: Connecting to host...");
	Msg.Add("dlerror", "Live Update&Download error !");
	Msg.Add("hostnotfound", "Live Update&Host not found !");
	Msg.Add("connecterror", "Live Update&Cannot connect to host !");
	Msg.Add("writeerror", "Live Update&File write error !");
	Msg.Add("readerror", "Live Update&File read error !");
	Msg.Add("fetchindex", "Downloading update file list...");
	Msg.Add("downloading", "Downloading file: ");
	Msg.Add("installfail", "Installation failed !");
	Msg.Add("usercancel", "Update Cancelled !");
	Msg.Add("proceed", "Do you want to run the existing version ?");
	Msg.Add("cleaning", "Cleaning up the working files.... ");
	Msg.Add("readtitle", "Live Update");
	Msg.Add("buttonInstall", "Install");
	Msg.Add("buttonCancel", "No Thanks");
}

LiveUpdate::~LiveUpdate() {
	String theUpdater = AppendFileName(localPath, updater);
	if (!FileExists(theUpdater)) DeleteFile(theUpdater);	
}

bool LiveUpdate::Run(void) {
	if (IsNull(exeName) || exeName.GetLength() < 1) {
		status = LIVEUPDATE_UpdateFail;
		if (debug) Exclamation("Debug&There is no exeName specified !&Please use SetExeName() to set your executable file name.");
		return false;
	}
	String theUpdater = AppendFileName(localPath, updater);
	const Vector<String> &cmd = CommandLine();
	int cnt = cmd.GetCount();
	if (cnt > 0) {
		if (ToUpper(cmd[0]) == "RESTART") {
			/* 
				The following code is added to delete the updater file.
				This procedure is needed in case your use runs the updater again.
				At the beginning I just add DeleteFile() but it does not work,
				finally I found that my computer to too fast that the updater
				does not has not enough time to shutdown before entering the 
				application again in RESTART mode.
				
				CAUTION: IT MAY NOT WORK IN LINUX
				
			*/
			Progress p(Msg.Get("cleaning"));
			p.SetTotal(10);
			int i = 0;
			do {
				p.Set(i, 10);
				Sleep(500);
				DeleteFile(theUpdater);
				if (!FileExists(theUpdater)) i = 100;
				i++;
			} while (i<10);
			p.Close();
		}
	}
	if (!LoadLocalVersion()) {
		return false;
	}
	if (debug) {
		String _mode = "Ftp";
		if (source == UseHttp) _mode = "Http";
		if (source == UseLan) _mode = "Lan";
		Exclamation(Format("Debug (%s)&Current version: %s&Max. version: %s", _mode, currentVersion.ToString(), maxVersion.ToString()));
	}
	
		if (GetExeFilePath() == theUpdater) {
			if (debug) Exclamation("Debug&Go to install the downloaded application.");
			if (doInstall()) {
				status = LIVEUPDATE_OK;
				if (debug) Exclamation(Format("Restarting&%s", AppendFileName(localPath, exeName)));
				WinExec(AppendFileName(localPath, exeName) + " RESTART", SW_SHOWNORMAL);
				return true;
			}
			status = LIVEUPDATE_InstallFail;
			return false;
		}

	/*
		Prevent the exeName does not match the running application and the updater crash.
	*/
	if (exeName != GetFileName(GetExeFilePath())) {
		status = LIVEUPDATE_UpdateFail;
		if (debug) Exclamation(Format("Debug&The application name %s does not match with SetExeName() !", exeName));
		return false;
	}
		
	if (fetchVersion()) {
		if (status == LIVEUPDATE_NoUpdates) {
			if (debug) Exclamation(Format("Debug&Application is up to date.&Current version: %s&Next version: %s", currentVersion.ToString(), nextVersion.ToString()));
			return true;
		}
	} else {
		return false;
	}
	if (currentVersion >= nextVersion) {
		status = LIVEUPDATE_NoUpdates;
		nextVersion = currentVersion;
		if (debug) Exclamation("Debug&Current application is up to date.");
		return true;
	}
	if (!autoUpdate) {
		String s = Msg.Get("askupdate");
		s.Replace(String("<<newversion>>"), nextVersion.ToString());
		if (IsNull(readme)) {
			if (!PromptYesNo(s)) {
				status = LIVEUPDATE_UserCancel;
				return false;
			}
		} else {
			readmeDlg dlg;
			dlg.Title(Msg.Get("readtitle"));
			dlg.readme <<= readme;
			if (dlg.RunAppModal() == IDCANCEL) {
				status = LIVEUPDATE_UserCancel;
				return false;
			}
		}
	}

	DeleteFile(theUpdater);	// remove the old updater
	return doInstall();
}

bool LiveUpdate::doInstall(void) {
	String theUpdater = AppendFileName(localPath, updater);
	Vector<String> files;
	Vector<String> paths;
	String dlfile, orgfile, extrapath;
	FileOut out;
	if (!out.Open(theUpdater)) {
		if (debug) Exclamation(Format("Cannot create the updater !&%s", theUpdater));
		status = LIVEUPDATE_UpdateFail;
		return false;
	}
#ifdef PLATFORM_POSIX
	// linux does not echo the command being execute, so nothing here
#else
	out.Put("@echo off\r\n");
#endif	
	int pfxlen = prefix.GetLength();
	if (!fetchVersion()) {
		return false;
	}
	if (debug) Exclamation(Format("Debug&Going to download version %s files.", nextVersion.ToString()));
	if (!fetchApps()) {
		return false;
	}
	files = getFiles(localPath);
	for (int i=0; i<files.GetCount(); i++) {
		dlfile = files[i];
		orgfile = dlfile;
		orgfile.Replace(prefix, String(""));
		if (FileExists(orgfile)) {
			if (backup) {
				if (debug) Exclamation(Format("Debug&Backup %s", DeQtfLf(orgfile)));
				DeleteFile(orgfile + "." + currentVersion.ToString());	// delete the old backup file
				if (!FileCopy(orgfile, orgfile + "." + currentVersion.ToString())) {
					if (debug) Exclamation(Format("Debug&Backup error !&From %s&To %s", DeQtfLf(orgfile), DeQtfLf(orgfile + "." + currentVersion.ToString())));
					return false;
				}
			}
		} else {
			if (debug) Exclamation(Format("Debug&Downloaded file is new.&%s", DeQtfLf(orgfile)));
		}
		if (debug) Exclamation(Format("Debug&Creating entries&%s&%s", DeQtfLf(dlfile), DeQtfLf(orgfile)));
#ifdef PLATFORM_POSIX
		out.Put(Format("rm -f \"%s\"\r", orgfile));
		out.Put(Format("mv \"%s\" \"%s\"\r", dlfile, orgfile));
#else
		extrapath = GetFileFolder(orgfile);
		orgfile = GetFileName(orgfile);
		dlfile = GetFileName(dlfile);
		out.Put(Format("cd %s\r\n", extrapath));
		out.Put(Format("del \"%s\"\r\n", orgfile));
		out.Put(Format("rename \"%s\" \"%s\"\r\n", dlfile, orgfile));
#endif
	}
#ifdef PLATFORM_POSIX
	out.Put(Format("\"%s\"\r", exeName));		// needed to test this in linux
#else
	out.Put(Format("cd %s\r\n", localPath));	// always go back to the working folder
	out.Put(Format("start \"\" \"%s\"\r\n", exeName));
#endif
	out.Close();
	if (!SysStartAdmin(Null, theUpdater, "")) {
		return false;
	}
	return true;
}

Vector<String> LiveUpdate::getFiles(String folder) {
	Vector<String> files;
	Vector<String> childs;
	String fn;
	int pfxlen = prefix.GetLength();
	FindFile ff;
	if (ff.Search(AppendFileName(folder, "*"))) {
		do {
			if (ff.IsFile()) {
				fn = ff.GetName();
				if (fn.Left(pfxlen) == prefix) {
					files.Add(AppendFileName(folder, fn));
				}
			} else if (ff.IsFolder()) {
				childs.Clear();
				childs = getFiles(AppendFileName(folder, ff.GetName()));
				for (int i=0; i<childs.GetCount(); i++) {
					files.Add(childs[i]);
				}
			}
		} while (ff.Next());
	}
	return files;
}

bool LiveUpdate::fetchVersionFtp(void) {
	pi = new Progress;
	pi->Create();
	FtpClient ftp;
	ftp.WhenProgress = callback(this, &LiveUpdate::fetchProgress);
	pi->SetText(Msg.Get("connecthost"));
	if (!ftp.Connect(host, ftpuser, ftppwd, true, 10)) {
		pi->Close();
		status = LIVEUPDATE_ConnectError;
		if (debug) Exclamation(Format("Debug&Ftp connect error!&Host:%sUser:&%s&Password:%s", host, ftpuser, ftppwd));
		return false;
	}
	if (!ftp.Cd(hostpath)) {
		ftp.Close();
		pi->Close();
		status = LIVEUPDATE_PathError;
		if (debug) Exclamation(Format("Debug&Ftp CD path:%s fail !", DeQtfLf(hostpath)));
		return false;
	}
	ftp.ClearError();
	String data = ftp.Load(hostVersionFile);
	ftp.Close();
	pi->Close();
	if (!IsNull(ftp.GetError())) {
		status = LIVEUPDATE_DownloadError;
		if (debug) Exclamation(Format("Debug&Ftp %s download fail !", hostVersionFile));
		return false;
	}
	data = TrimBoth(data);
	if (IsNull(data)) {
		status = LIVEUPDATE_DownloadError;
		if (debug) Exclamation(Format("Debug&Ftp %s is empty !", hostVersionFile));
		return false;
	}
	if (saveVersions(data)) {
		return loadVersions();
	}
	return false;
}

bool LiveUpdate::fetchVersionHttp(void) {
	String url, data;
	Progress progress(Msg.Get("downloading") + hostVersionFile);
	HttpClient http;
	http.TimeoutMsecs(httpTimeout);
	http.MaxContentSize(httpContentSize);
	url = host + "/" + hostpath + "/" + hostVersionFile;
	http.URL(url);
	data = http.Execute(progress);
	int err = http.GetStatusCode();
	if (err != 200) {
		http.Close();
		progress.Close();
		status = LIVEUPDATE_DownloadError;
		if (debug) Exclamation(Format("Debug&Http download error %d!&%s&%s", err, DeQtfLf(http.GetError()), url));
		return false;
	}
	progress.Close();
	http.Close();
	if (saveVersions(data)) {
		return loadVersions();
	}
	return false;
}

bool LiveUpdate::fetchVersionLan(void) {
	String source, target;
	if (!createVersion()) return false;
	Progress progress(Msg.Get("downloading") + hostVersionFile);
	source = AppendFileName(hostpath, hostVersionFile);
	target = AppendFileName(localPath, hostVersionFile);
	FileCopy(source, target);
	if (!FileExists(target)) {
		progress.Close();
		status = LIVEUPDATE_DownloadError;
		if (debug) Exclamation(Format("Debug&Lan %s download fail !", hostVersionFile));
		return false;
	}
		
	progress.Close();
	FileIn fi(target);
	if (!fi) {
		status = LIVEUPDATE_ReadError;
		if (debug) {
			Exclamation(Format("Debug&File open error !&%s", DeQtfLf(localPath + hostUpdateListFile)));
			if (!debug)	FileDelete(localPath + hostUpdateListFile);
		}
		return false;
	}
	return loadVersions();
}

bool LiveUpdate::fetchAppsFtp(void) {
	if (!createVersion()) return false;
	pi = new Progress;
	pi->Create();
	FtpClient ftp;
	ftp.WhenProgress = callback(this, &LiveUpdate::fetchProgress);
	pi->SetText(Msg.Get("connecthost"));
	if (!ftp.Connect(host, ftpuser, ftppwd, true, 10)) {
		pi->Close();
		status = LIVEUPDATE_ConnectError;
		if (debug) Exclamation(Format("Debug&Ftp connect error!&Host:%sUser:&%s&Password:%s", host, ftpuser, ftppwd));
		return false;
	}
	if (!ftp.Cd(hostpath)) {
		ftp.Close();
		pi->Close();
		status = LIVEUPDATE_PathError;
		if (debug) Exclamation(Format("Debug&Ftp CD path:%s fail !", DeQtfLf(hostpath)));
		return false;
	}
	if (!ftp.Cd(nextVersion.ToString())) {
		ftp.Close();
		pi->Close();
		status = LIVEUPDATE_PathError;
		if (debug) Exclamation(Format("Debug&Ftp CD path:%s fail !", DeQtfLf(nextVersion.ToString())));
		return false;
	}
	ftp.ClearError();
	pi->SetText(Msg.Get("fetchindex"));
	String data = ftp.Load(hostUpdateListFile);
	if (!IsNull(ftp.GetError())) {
		ftp.Close();
		pi->Close();
		status = LIVEUPDATE_DownloadError;
		if (debug) Exclamation(Format("Debug&Ftp %s download fail !", hostUpdateListFile));
		return false;
	}
	data = TrimBoth(data);
	if (IsNull(data)) {
		status = LIVEUPDATE_DownloadError;
		ftp.Close();
		pi->Close();
		if (debug) Exclamation(Format("Debug&Ftp %s is empty !", hostUpdateListFile));
		return false;
	}
	if (!saveFileList(data)) {
		ftp.Close();
		pi->Close();
		return false;
	}
	if (!FileExists(localPath + hostUpdateListFile)) {
		return false;
	}
	if (!loadFileList()) {
		ftp.Close();
		pi->Close();
		return false;
	}
	
	String dlfile, extrapath, filename;
	for (int i=0; i<filelist.GetCount(); i++) {
		dlfile = filelist[i];
		ftp.ClearError();
		pi->SetText(Msg.Get("downloading") + dlfile);
		if (debug) Exclamation(Format("Debug&Downloading&%s", dlfile));
		data = ftp.Load(dlfile);
		if (!IsNull(ftp.GetError())) {
			status = LIVEUPDATE_DownloadError;
			ftp.Close();
			pi->Close();
			if (debug) Exclamation(Format("Debug&Ftp download error !&%s", dlfile));
			return false;
		}
		filename = GetFileName(dlfile);
		if (filename != dlfile) {
			extrapath = GetFileDirectory(dlfile);
			if (!createFolder(extrapath)) {
				status = LIVEUPDATE_WriteError;
				if (debug) Exclamation(Format("Cannot create child folder !&%s", DeQtfLf(extrapath)));
				return false;
			}
			filename = localPath + extrapath + prefix + filename;
		} else {
			filename = prefix + filename;
		}
		FileOut fo(filename);
		if (fo) {
			fo.Put(data);
			if (fo.IsError()) {
				fo.Close();
				ftp.Close();
				pi->Close();
				status = LIVEUPDATE_WriteError;
				if (debug) Exclamation(Format("Debug&File write error !&%s", DeQtfLf(filename)));
				return false;
			}
			fo.Close();
		} else {
			ftp.Close();
			pi->Close();
			status = LIVEUPDATE_WriteError;
			if (debug) Exclamation(Format("Debug&File create error !&%s", DeQtfLf(filename)));
			return false;
		}
#ifdef PLATFORM_POSIX
		if (updateSelf) {
			if (dlfile == exeName) {
				if(chmod(~filename, 0755) != 0) {
					ftp.Close();
					pi->Close();
					status = LIVEUPDATE_WriteError;
					if (debug) Exclamation(Format("Debug&File create error !&%s", DeQtfLf(filename)));
					return false;
				}
			}
		}
#endif
	}
	ftp.Close();
	pi->Close();
	status = LIVEUPDATE_OK;
	return true;
}

bool LiveUpdate::fetchAppsHttp(void) {
	String url, data, hostbase, dlfile, extrapath, filename;
	FileOut fo;
	if (!createVersion()) return false;
	Progress progress(Msg.Get("downloading") + hostUpdateListFile);
	HttpClient http;
	http.TimeoutMsecs(httpTimeout);
	http.MaxContentSize(httpContentSize);
	hostbase = host + "/" + hostpath + "/" + nextVersion.ToString();
	url = hostbase + "/" + hostUpdateListFile;
	http.URL(url);
	data = http.Execute(progress);
	int err = http.GetStatusCode();
	if (err != 200) {
		http.Close();
		status = LIVEUPDATE_DownloadError;
		if (debug) Exclamation(Format("Debug&Http download error %d!&%s&%s", err, DeQtfLf(http.GetError()), hostUpdateListFile));
		return false;
	}
	if (!saveFileList(data)) {
		http.Close();
		progress.Close();
		return false;
	}
	if (!loadFileList()) {
		http.Close();
		progress.Close();
		return false;
	}
	for (int i=0; i<filelist.GetCount(); i++) {
		dlfile = filelist[i];
		url = hostbase + "/" + dlfile;
		if (debug) Exclamation(Format("Debug Http&Downloading&%s", DeQtfLf(url)));
		http.URL(url);
		progress.SetText(Msg.Get("downloading") + dlfile);
		data = http.Execute(progress);
		err = http.GetStatusCode();
		if (err != 200) {
			status = LIVEUPDATE_DownloadError;
			http.Close();
			progress.Close();
			if (debug) Exclamation(Format("Debug&Http download error %d!&%s&%s", err, DeQtfLf(http.GetError()), DeQtfLf(dlfile)));
			return false;
		}
		filename = GetFileName(dlfile);
		if (filename != dlfile) {
			extrapath = GetFileDirectory(dlfile);
			if (!createFolder(extrapath)) {
				status = LIVEUPDATE_WriteError;
				if (debug) Exclamation(Format("Cannot create child folder !&%s", DeQtfLf(extrapath)));
				return false;
			}
			filename = localPath + extrapath + prefix + filename;
		} else {
			filename = localPath + prefix + filename;
		}
		if (fo.Open(filename)) {
			fo.Put(data);
			if (fo.IsError()) {
				fo.Close();
				http.Close();
				progress.Close();
				status = LIVEUPDATE_WriteError;
				if (debug) Exclamation(Format("Debug&File write error !&%s", DeQtfLf(filename)));
				return false;
			}
			fo.Close();
		} else {
			http.Close();
			progress.Close();
			status = LIVEUPDATE_WriteError;
			if (debug) Exclamation(Format("Debug&File create error !&%s", DeQtfLf(filename)));
			return false;
		}
#ifdef PLATFORM_POSIX
		if (updateSelf) {
			if (dlfile == exeName) {
				if(chmod(~filename, 0755) != 0) {
					http.Close();
					progress.Close();
					status = LIVEUPDATE_WriteError;
					if (debug) Exclamation(Format("Debug&File create error !&%s", DeQtfLf(filename)));
					return false;
				}
			}
		}
#endif
	}
	http.Close();
	progress.Close();
	status = LIVEUPDATE_OK;
	return true;
}

bool LiveUpdate::fetchAppsLan(void) {
	String hostbase, dlfile, source, target, extraPath;
	if (!createVersion()) return false;
	Progress progress(Msg.Get("downloading") + hostUpdateListFile);
	hostbase = AppendFileName(hostpath, nextVersion.ToString());
	source = AppendFileName(hostbase, hostUpdateListFile);
	target = AppendFileName(localPath, hostUpdateListFile);
	FileCopy(source, target);
	if (!FileExists(target)) {
		status = LIVEUPDATE_DownloadError;
		if (debug) Exclamation(Format("Debug&Lan %s download fail !", DeQtfLf(source)));
		return false;
	}
	if (!loadFileList()) {
		progress.Close();
		return false;
	}
	for (int i=0; i<filelist.GetCount(); i++) {
		dlfile = filelist[i];
		source = AppendFileName(hostbase, dlfile);
		progress.SetText(Msg.Get("downloading") + source);
		target = GetFileName(dlfile);
		if (target != dlfile) {
			extraPath = GetFileDirectory(dlfile);
			if (!createFolder(extraPath)) {
				status = LIVEUPDATE_WriteError;
				if (debug) Exclamation(Format("Cannot create child folder !&%s", DeQtfLf(extraPath)));
				return false;
			}
			target = AppendFileName(localPath, extraPath);
			target = AppendFileName(target, prefix + GetFileName(dlfile));
		} else {
			target = AppendFileName(localPath, prefix + dlfile);
		}
		FileCopy(source, target);
		if (!FileExists(target)) {
			progress.Close();
			status = LIVEUPDATE_WriteError;
			if (debug) Exclamation(Format("Debug&Lan %s download fail !", DeQtfLf(source)));
			return false;
		}
#ifdef PLATFORM_POSIX
		if (updateSelf) {
			if (dlfile == exeName) {
				if(chmod(~filename, 0755) != 0) {
					progress.Close();
					status = LIVEUPDATE_WriteError;
					if (debug) Exclamation(Format("Debug&File create error !&%s", DeQtfLf(filename)));
					return false;
				}
			}
		}
#endif
	}
	progress.Close();
	status = LIVEUPDATE_OK;
	return true;
}


bool LiveUpdate::ShowMsg(void) {
	String data;
	if (status == LIVEUPDATE_OK) {
		PromptOK(Msg.Get("success"));
		return true;
	} else if (status == LIVEUPDATE_NoUpdates) {
		PromptOK(Msg.Get("uptodate"));
		return true;
	}
	switch(status) {
		case LIVEUPDATE_HostNotFound:
			data = Msg.Get("hostnotfound");
			break;
		case LIVEUPDATE_ConnectError:
			data = Msg.Get("connecterror");
			break;
		case LIVEUPDATE_PathError:
			data = Msg.Get("pathnotfound");
			break;
		case LIVEUPDATE_DownloadError:
			data = Msg.Get("fail");
			return !forceUpdate;
		case LIVEUPDATE_WriteError:
			Exclamation(Msg.Get("writeerror"));
			return !forceUpdate;
		case LIVEUPDATE_ReadError:
			Exclamation(Msg.Get("readerror"));
			return !forceUpdate;
		case LIVEUPDATE_InstallFail:
			Exclamation(Msg.Get("installfail"));
			return false;
		case LIVEUPDATE_UpdateFail:
			Exclamation(Msg.Get("fail"));
			return false;
		case LIVEUPDATE_UserCancel:
			data = Msg.Get("usercancel");
			break;
		default:
			if (debug) Exclamation("Debug&Unknown status !");
			return false; 
	}
	if (forceUpdate) {
		Exclamation(data);
		return false;
	} else {
		data += "&" + Msg.Get("proceed");
		return PromptYesNo(data);
	}
	return true;
}

bool LiveUpdate::updateVersion() {
	FileOut fo(localPath + localVersionFile);
	if (!fo) {
		if (debug) Exclamation(Format("Debug&File open error !&%s", DeQtfLf(localPath + localVersionFile)));
		return false;
	}
	fo.Put(nextVersion.ToString());
	fo.Close();
	if (fo.IsError()) {
		if (debug) Exclamation(Format("Debug&File write error !&%s", DeQtfLf(localPath + localVersionFile)));
		return false;
	}
	return true;
}

bool LiveUpdate::LoadLocalVersion(void) {
	String _filename;
	_filename = AppendFileName(localPath, localVersionFile);
	if (FileExists(_filename)) {
		FileIn fi(_filename);
		if (!fi) {
			status = LIVEUPDATE_ReadError;
			if (debug) Exclamation(Format("Debug&File open error!&%s", localPath + localVersionFile));
			return false;
		}
		String data = fi.GetLine();
		fi.Close();
		if (fi.IsError()) {
			status = LIVEUPDATE_ReadError;
			if (debug) Exclamation(Format("Debug&File read error!&%s", localPath + localVersionFile));
			return false;
		}
		data = TrimBoth(data);
		if (IsNull(data)) {
			nextVersion = ProductVersion("0.0");
			currentVersion = nextVersion;
			updateVersion();
			if (debug) Exclamation(Format("Debug&Local version file is empty, file updated !&%s", localPath + localVersionFile));
		} else {
			currentVersion = ProductVersion(data);
		}
	} else {
			nextVersion = ProductVersion("0.0");
			currentVersion = nextVersion;
			updateVersion();
			if (debug) Exclamation(Format("Debug&Local version file does not exists, file created.&%s", localPath + localVersionFile));
	}
	return true;
}

bool LiveUpdate::saveVersions(String data) {
	FileOut fo(localPath + hostVersionFile);;
	if (!fo) {
		status = LIVEUPDATE_WriteError;
		if (debug) Exclamation(Format("Debug&File create error !&%s", DeQtfLf(localPath + hostVersionFile)));
		return false;
	}		
	fo.Put(data);
	fo.Close();
	if (fo.IsError()) {
		status = LIVEUPDATE_WriteError;
		if (debug) Exclamation(Format("Debug&File write error!&%s", DeQtfLf(localPath + hostVersionFile)));
		return false;
	}		
	return true;
}

bool LiveUpdate::loadVersions(void) {
	String data;
	FileIn fi(localPath + hostVersionFile);
	if (!fi) {
		status = LIVEUPDATE_WriteError;
		if (debug) Exclamation(Format("Debug&File read error !&%s", DeQtfLf(localPath + hostVersionFile)));
		if (!debug) FileDelete(localPath + hostVersionFile);
		return false;
	}
	Array<String> avaVers;
	while (!fi.IsEof()) {
		avaVers.Add(TrimBoth(fi.GetLine()));
	}
	fi.Close();
	if (avaVers.GetCount() == 0) {
		status = LIVEUPDATE_UpdateFail;
		if (debug) Exclamation(Format("Debug&File %s is empty !", DeQtfLf(localPath + hostVersionFile)));
		if (!debug) FileDelete(localPath + hostVersionFile);
		return false;
	}
	if (!debug) FileDelete(localPath + hostVersionFile);
	status = LIVEUPDATE_NoUpdates;
	for (int i=0; i<avaVers.GetCount(); i++) {
		data = TrimBoth(avaVers[i]);
		if (data.Right(1) == "*") forceUpdate = true;	//  this is a must update, so change to force mode 
		nextVersion = ProductVersion(avaVers[i]);
		if (nextVersion > currentVersion) {
			if (versionLimit) {
				if (nextVersion <= maxVersion) {
					status = LIVEUPDATE_OK;
					loadReadMe();
				}
			} else {
				status = LIVEUPDATE_OK;
			}
			return true;
		}
	}
	nextVersion = currentVersion;
	return true;
}

bool LiveUpdate::createVersion(void) {
	FileOut out(localPath + prefix + localVersionFile);
	if (!out) {
		status = LIVEUPDATE_WriteError;
		if (debug) Exclamation(Format("Debug&File open error!&%s", localPath + prefix + localVersionFile));
		return false;
	}
	out.Put(nextVersion.ToString());
	out.Close();
	if (out.IsError()) {
		FileDelete(localPath + prefix + localVersionFile);
		status = LIVEUPDATE_WriteError;
		if (debug) Exclamation(Format("Debug&File write error!&%s", localPath + prefix + localVersionFile));
		return false;
	}
	return true;
}

bool LiveUpdate::saveFileList(String data) {
	FileOut fo(localPath + hostUpdateListFile);;
	if (!fo) {
		status = LIVEUPDATE_WriteError;
		if (debug) Exclamation(Format("Debug&File create error !&%s", DeQtfLf(localPath + hostUpdateListFile)));
		return false;
	}		
	fo.Put(data);
	fo.Close();
	if (fo.IsError()) {
		status = LIVEUPDATE_WriteError;
		if (debug) Exclamation(Format("Debug&File write error !&%s", DeQtfLf(localPath + hostUpdateListFile)));
		return false;
	}		
	return true;
}

bool LiveUpdate::loadFileList(void) {
	filelist.Clear();
	FileIn fi(localPath + hostUpdateListFile);
	if (!fi) {
		status = LIVEUPDATE_ReadError;
		if (debug) Exclamation(Format("Debug&File open error !&%s", DeQtfLf(localPath + hostUpdateListFile)));
		if (!debug) FileDelete(localPath + hostUpdateListFile);
		return false;
	}
	String thefile;
	updateSelf = false;
	while (!fi.IsEof()) {
		thefile = TrimBoth(fi.GetLine());
		filelist.Add(thefile);
		if (thefile == exeName) {
			updateSelf = true;
		}
	}
	fi.Close();
	if (!debug) FileDelete(localPath + hostUpdateListFile);
	return true;
}

bool LiveUpdate::createFolder(String path) {
	if (DirectoryExists(path)) return true;
	path = AppendFileName(localPath, path) + "\\";
#ifdef PLATFORM_POSIX
	return RealizeDirectory(path);
#else
	return RealizeDirectory(path);
#endif
}

void LiveUpdate::fetchReadMeFtp(void) {
	readme = NULL;
	pi = new Progress;
	pi->Create();
	FtpClient ftp;
	ftp.WhenProgress = callback(this, &LiveUpdate::fetchProgress);
	pi->SetText(Msg.Get("connecthost"));
	if (!ftp.Connect(host, ftpuser, ftppwd, true, 10)) {
		pi->Close();
		status = LIVEUPDATE_ConnectError;
		if (debug) Exclamation(Format("Debug&Ftp connect error!&Host:%sUser:&%s&Password:%s", host, ftpuser, ftppwd));
		return;
	}
	if (!ftp.Cd(hostpath)) {
		ftp.Close();
		pi->Close();
		status = LIVEUPDATE_PathError;
		if (debug) Exclamation(Format("Debug&Ftp CD path:%s fail !", DeQtfLf(hostpath)));
		return;
	}
	if (!ftp.Cd(nextVersion.ToString())) {
		ftp.Close();
		pi->Close();
		status = LIVEUPDATE_PathError;
		if (debug) Exclamation(Format("Debug&Ftp CD path:%s fail !", DeQtfLf(nextVersion.ToString())));
		return;
	}
	ftp.ClearError();
	pi->SetText(Msg.Get("downloading") + readmefile);
	String data = ftp.Load(readmefile);
	ftp.Close();
	pi->Close();
	if (!IsNull(ftp.GetError())) {
		if (debug) Exclamation(Format("Debug&Ftp %s download fail !", readmefile));
		return;
	}
	readme = TrimBoth(data);
	if (IsNull(readme)) {
		if (debug) Exclamation(Format("Debug&Ftp %s is empty !", readmefile));
	}
	return;
}

void LiveUpdate::fetchReadMeHttp(void) {
	readme = NULL;
	String url, data, hostbase, dlfile, extrapath, filename;
	FileOut fo;
	Progress progress(Msg.Get("downloading") + readmefile);
	HttpClient http;
	http.TimeoutMsecs(httpTimeout);
	http.MaxContentSize(httpContentSize);
	hostbase = host + "/" + hostpath + "/" + nextVersion.ToString();
	url = hostbase + "/" + readmefile;
	http.URL(url);
	data = http.Execute(progress);
	int err = http.GetStatusCode();
	if (err != 200) {
		http.Close();
		status = LIVEUPDATE_DownloadError;
		if (debug) Exclamation(Format("Debug&Http download error %d!&%s&%s", err, DeQtfLf(http.GetError()), readmefile));
		return;
	}
	readme = data;
}

void LiveUpdate::fetchReadMeLan(void) {
	String hostbase, source, target;
	readme = NULL;
	hostbase = AppendFileName(hostpath, nextVersion.ToString());
	source = AppendFileName(hostbase, readmefile);
	target = AppendFileName(localPath, readmefile);
	FileCopy(source, target);
	if (!FileExists(target)) {
		if (debug) Exclamation(Format("Debug&Lan download error !&%s", readmefile));
		return;
	} else {
		FileIn fi(target);
		if (!fi) return;
		readme = "";
		while (!fi.IsEof()) {
			readme.Cat(fi.GetLine());
		}
		fi.Close();
	}
	return;
}

END_UPP_NAMESPACE
