#ifndef _LiveUpdate_LiveUpdate_h
#define _LiveUpdate_LiveUpdate_h

#include <CtrlLib/CtrlLib.h>
#include <SysExec/SysExec.h>
#include <ProductVersion/ProductVersion.h>
#include <plugin/ftp/ftp.h>
#include <Web/Web.h>
#include <SysExecGui/SysExecGui.h>

NAMESPACE_UPP
#define LIVEUPDATE_OK 1
#define LIVEUPDATE_NoUpdates 2
#define LIVEUPDATE_InstallOK 3
#define LIVEUPDATE_HostNotFound -1
#define LIVEUPDATE_ConnectError -2
#define LIVEUPDATE_PathError -3
#define LIVEUPDATE_DownloadError -4
#define LIVEUPDATE_WriteError -5
#define LIVEUPDATE_UpdateFail -6
#define LIVEUPDATE_ReadError -7
#define LIVEUPDATE_InstallFail -8
#define LIVEUPDATE_UserCancel -9


#define LAYOUTFILE <LiveUpdate/LiveUpdate.lay>
#include <CtrlCore/lay.h>

class readmeDlg : public Withreadme<TopWindow> {
	typedef readmeDlg CLASSNAME;

public:
	readmeDlg();
};

class LiveUpdate {
public:
	typedef enum {
		UseHttp, UseFtp, UseLan
	} UpdateMethod;

private:
	ProductVersion myVersion;	// this package version
	String updater;	// name of the updater program name
	bool debug;	// debug flag
	bool updateSelf;	// flag indicate the application needs to update or not
	UpdateMethod source;	// update source
	bool versionLimit;		// limit max. update version
	String localPath;	// local application path
	String appName;	// application name
	String exeName;	// application filename
	String prefix;	// prefix added to downloaded file
	String host;	// http or ftp host name
	String ftpuser;	// ftp user name
	String ftppwd;	// ftp password
	String hostpath;	// http or ftp host path or lan path
	String hostVersionFile;		// version file name stored in host side, an ASCII file contains the avaliable versions for download
	String hostUpdateListFile;	// host file name contains the file(s) needed to download for update
	String localVersionFile;	// version file name stored in local machine, an ASCII file contain only the current version number
	ProductVersion maxVersion;	// contains the max. version can be updated to
	ProductVersion currentVersion;	// version contains in local folder
	ProductVersion nextVersion;	// next version to update
	bool backup;	// create backup under the current folder with version name before update
	bool autoUpdate;	// update method
	bool forceUpdate;	// force update
	VectorMap<String, String> Msg;	// store update message
	int status;	// last execution status
	Progress *pi;		// progress bar pointer
	Array<String> filelist;	// store the update file list
	int httpTimeout;	// http timeout
	int httpContentSize;	// http content size
	String readmefile, readme;
	
public:
	LiveUpdate();
	~LiveUpdate();
	
	LiveUpdate &SetUpdater(String const &_updater)
		{updater = _updater; return *this;};
	LiveUpdate &SetFtp(String const &_host, String const &user, String const &pwd, String const &path)
		{source = UseFtp; host = _host; ftpuser = user; ftppwd = pwd; hostpath = path; return *this;};
	LiveUpdate &SetHttp(String const &_host, String const &path)
		{source = UseHttp; host = _host; hostpath = path; return *this;};
	LiveUpdate &SetLan(String const &path)
		{source = UseLan; hostpath = path; return *this;};
	LiveUpdate &SetAppName(String const &_appName)
		{appName = _appName; return *this;};
	LiveUpdate &SetExeName(String const &_exeName)
		{exeName = _exeName; return *this;};
	LiveUpdate &SetPrefix(String const &_prefix)
		{prefix = _prefix; return *this;};
	LiveUpdate &SetHostVersionFile(String const &filename)
		{hostVersionFile = filename; return *this;};
	LiveUpdate &SetHostListFile(String const &filename)
		{hostUpdateListFile = filename; return *this;};
	LiveUpdate &SetLocalVersionFile(String const &filename)
		{localVersionFile = filename; return *this;};
	LiveUpdate &SetDebugOn()
		{debug = true; return *this;};
	LiveUpdate &SetDebugOff(void)
		{debug = false; return *this;};
	LiveUpdate &SetHttpTimeout(int const msec)
		{httpTimeout = msec; return *this;};
	LiveUpdate &SetHttpContentSize(int const sz)
		{httpContentSize = sz; return *this;};
	LiveUpdate &SetReadmeFile(String const &filename)
		{readmefile = filename; return *this;};

	LiveUpdate &SetMaxVersion(String const &s)
		{maxVersion = ProductVersion(s); versionLimit = true; return *this;};
	LiveUpdate &SetMaxVersion(ProductVersion const &v)
		{maxVersion = v; versionLimit = true; return *this;};
	LiveUpdate &SetMaxVersion(int maj, int min)
		{maxVersion.SetMajor(maj).SetMinor(min); versionLimit = true; return *this;};
	LiveUpdate &SetMaxVersion(int maj, int min, int dev)
		{maxVersion.SetMajor(maj).SetMinor(min).SetDevel(dev); versionLimit = true; return *this;};

	LiveUpdate &SetBackupOn()
		{backup = true; return *this;};
	LiveUpdate &SetBackupOff()
		{backup = false; return *this;};
	LiveUpdate &ManualUpdate(void)
		{autoUpdate = false; return *this;};
	LiveUpdate &AutoUpdate(void)
		{autoUpdate = true; return *this;};
	LiveUpdate &ForceUpdate(void)
		{forceUpdate = true; return *this;};
	LiveUpdate &SetAskUpdateMsg(String const &txt)
		{Msg.GetAdd("askupdate") = txt; return *this;};
	LiveUpdate &SetSuccessMsg(String const &txt)
		{Msg.GetAdd("success") = txt; return *this;};
	LiveUpdate &SetFailMsg(String const &txt)
		{Msg.GetAdd("fail") = txt; return *this;};
	LiveUpdate &SetAbortMsg(String const &txt)
		{Msg.GetAdd("abort") = txt; return *this;};
	LiveUpdate &SetPathNotFoundMsg(String const &txt)
		{Msg.GetAdd("pathnotfound") = txt; return *this;};
	LiveUpdate &SetUpToDateMsg(String const &txt)
		{Msg.GetAdd("uptodate") = txt; return *this;};
	LiveUpdate &SetCheckUpdateMsg(String const &txt)
		{Msg.GetAdd("checkupdate") = txt; return *this;};
	LiveUpdate &SetConnectHostMsg(String const &txt)
		{Msg.GetAdd("connecthost") = txt; return *this;};
	LiveUpdate &SetDownloadErrorMsg(String const &txt)
		{Msg.GetAdd("dlerror") = txt; return *this;};
	LiveUpdate &SetHostNotFoundMsg(String const &txt)
		{Msg.GetAdd("hostnotfound") = txt; return *this;};
	LiveUpdate &SetConnectErrorMsg(String const &txt)
		{Msg.GetAdd("connecterror") = txt; return *this;};
	LiveUpdate &SetWriteErrorMsg(String const &txt)
		{Msg.GetAdd("writeerror") = txt; return *this;};
	LiveUpdate &SetReadErrorMsg(String const &txt)
		{Msg.GetAdd("readerror") = txt; return *this;};
	LiveUpdate &SetFetchIndexMsg(String const &txt)
		{Msg.GetAdd("fetchindex") = txt; return *this;};
	LiveUpdate &SetDownloadingMsg(String const &txt)
		{Msg.GetAdd("downloading") = txt; return *this;};
	LiveUpdate &SetInstallFailMsg(String const &txt)
		{Msg.GetAdd("installfail") = txt; return *this;};
	LiveUpdate &SetUserCancelMsg(String const &txt)
		{Msg.GetAdd("usercancel") = txt; return *this;};
	LiveUpdate &SetProceedMsg(String const &txt)
		{Msg.GetAdd("proceed") = txt; return *this;};
	LiveUpdate &SetCleanupMsg(String const &txt)
		{Msg.GetAdd("cleaning") = txt; return *this;};
	LiveUpdate &SetButtonInstallMsg(String const &txt)
		{Msg.GetAdd("buttonInstall") = txt; return *this;};
	LiveUpdate &SetButtonCancelMsg(String const &txt)
		{Msg.GetAdd("buttonCancel") = txt; return *this;};
	LiveUpdate &SetReadMeTitleMsg(String const &txt)
		{Msg.GetAdd("readtitle") = txt; return *this;};
	
	String GetCurrentVersion(void)
		{LoadLocalVersion(); return currentVersion.ToString();};
		
	int GetStatus(void)
		{return status;};
	bool ShowMsg(void);
	bool Run(void);
	
private:
	bool fetchVersion(void) {
		if (source == UseFtp) return fetchVersionFtp();
		if (source == UseHttp) return fetchVersionHttp();
		if (source == UseLan) return fetchVersionLan();
	};
	bool fetchVersionFtp(void);
	bool fetchVersionHttp(void);
	bool fetchVersionLan(void);
	bool fetchApps(void) {
		if (source == UseFtp) return fetchAppsFtp();
		if (source == UseHttp) return fetchAppsHttp();
		if (source == UseLan) return fetchAppsLan();
	};
	bool fetchAppsFtp(void);
	bool fetchAppsHttp(void);
	bool fetchAppsLan(void);
	bool fetchProgress(int xfered, int total)
		{pi->Set(xfered, total); return false;};
	bool updateVersion();
	bool doInstall(void);
	bool LoadLocalVersion(void);
	Vector<String> getFiles(String folder);
	bool saveVersions(String data);
	bool loadVersions(void);
	bool createVersion(void);
	bool saveFileList(String data);
	bool loadFileList(void);
	bool createFolder(String path);
	void fetchReadMeFtp(void);
	void fetchReadMeHttp(void);
	void fetchReadMeLan(void);
	void loadReadMe(){
		if (source == UseFtp) fetchReadMeFtp();
		if (source == UseHttp) fetchReadMeHttp();
		if (source == UseLan) fetchReadMeLan();
	};
};

END_UPP_NAMESPACE

#endif
