#include "C3.h"

C3::C3() : done(true)
{
	CtrlLayout(*this, "NMEA GPS receivers checker");
	MinimizeBox();

	btnCheck.WhenPush = THISBACK(Check);
}

C3::~C3()
{
	work.ShutdownThreads();
	work.Wait();
}

void C3::Check()
{
	work.Run(THISBACK(DoCheck));
}

void C3::DoCheck()
{
	if (!done)
		return;
	done = false;

	Insert(check_Ports(1, 20));
	Insert(check_Baud());
	Insert(receive_parse());

	done = true;
}

void C3::Insert(const std::string& data)
{
	GuiLock __;
	text.Insert(0, String(data));
}

GUI_APP_MAIN
{
	Ctrl::GlobalBackPaint();
	C3().Run();
}
