#include "stdio.h"

#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
#include <SqlCtrl/SqlCtrl.h>
#include <plugin/sqlite3/Sqlite3.h>

using namespace Upp;
#define SCHEMADIALECT <plugin/sqlite3/Sqlite3Schema.h>
#define MODEL "Sqlite3bug.sch"
#include <Sql/sch_header.h>
#include <Sql/sch_source.h>
#include <Sql/sch_schema.h>



int main(int argc, const char *argv[])
{
	SQL;

	Sqlite3Session sqlite3;
	if(!sqlite3.Open(ConfigFile("Sqlite3bug.db"))) {
		Cout() << "Cannot open databasefile\n";
		return 1;
	}
	sqlite3.SetTrace();
	
	SQL = sqlite3;
	SqlSchema sch(SQLITE3);
	All_Tables(sch);
	SqlPerformScript(sch.Upgrade());
	SqlPerformScript(sch.Attributes());
	SQL.ClearError();


	Sql sql;
	
	int aantal=0, nieuw_bedrag=345, minimum=300, correctie=455,btw=345 ; //random stuff
	sql*Insert(TEST)(BD_KORTING, 1);   //random stuff
	int id=sql.GetInsertedId();
	
	sql*SqlUpdate(TEST)
		(BD_AANTAL,aantal+1)
		(BD_BEDRAG,nieuw_bedrag)
		(BD_EXTRA_VAN,id)
		(BD_KORTING, 1)
		(BD_BTW_BEDRAG,btw)
		.Where(BD_ID==id);

	sql*Select(BD_ID, BD_BEDRAG, BD_BTW_BEDRAG).Where(BD_EXTRA_VAN==id && BD_KORTING==1);
	if (sql.Fetch())  //<---------crashes in debug mode
		Cout() << "Test passed";
	else
		Cout() << "Test failed"; // test fails in optimal mode
	
	return 0;
}
