#ifndef _AlphaButtonTest_AlphaButtonTest_h
#define _AlphaButtonTest_AlphaButtonTest_h

#include <CtrlLib/CtrlLib.h>
#include <Controls4U/Controls4U.h>

using namespace Upp;


// =============================
//     C H A M E L E O N  START
// =============================
	typedef enum {
		ABTSTYLE_LEFT_WITH_CIRCLE = 0,
		ABTSTYLE_RIGHT_WITH_CIRCLE,
		ABTSTYLE_LEFT_EMPTY,
		ABTSTYLE_RIGHT_EMPTY,
		ABTSTYLE_LEFT_WITH_ROUND_BUTTON,
		ABTSTYLE_RIGHT_WITH_ROUND_BUTTON,
	} SkinTypes;

typedef struct {
	int skinType;
	Color circleColor;

	Image bandStyle;
	Color alphaColor;
	int alphaValue;
} ABT_SideStyle;

Button::Style ABTStyle(int skinNum);
Button::Style ABTStyle2(int skinNum);

// =============================
//     C H A M E L E O N   END
// =============================



#define LAYOUTFILE <AlphaButtonTest/AlphaButtonTest.lay>
#include <CtrlCore/lay.h>

#define IMAGECLASS AlphaButtonImg
#define IMAGEFILE <AlphaButtonTest/AlphaButtonTest.iml>
#include <Draw/iml_header.h>

class AlphaButtonTest : public WithAlphaButtonTestLayout<TopWindow> {
public:
	typedef AlphaButtonTest CLASSNAME;
	AlphaButtonTest();
	
	Button::Style styleL;
	Button::Style styleR;
	Button::Style styleBL;
	Button::Style styleBR;

};

#endif
